/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import bagu_chan.bagus_lib.client.camera.CameraEvent;
import bagu_chan.bagus_lib.client.camera.CameraHolder;
import bagu_chan.bagus_lib.entity.ISmartJump;
import bagu_chan.bagus_lib.util.GlobalVec3;
import baguchan.tofucraft.client.particle.ParticleStink;
import baguchan.tofucraft.entity.AbstractTofunian;
import baguchan.tofucraft.entity.ShuDofuSpiderPart;
import baguchan.tofucraft.entity.TofuSpider;
import baguchan.tofucraft.entity.projectile.FukumameEntity;
import baguchan.tofucraft.entity.projectile.NattoBallEntity;
import baguchan.tofucraft.entity.projectile.NattoStringEntity;
import baguchan.tofucraft.registry.TofuDamageSource;
import baguchan.tofucraft.registry.TofuParticleTypes;
import baguchan.tofucraft.registry.TofuSounds;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class ShuDofuSpider
extends Monster
implements ISmartJump {
    private static final EntityDataAccessor<Boolean> DATA_ID_JUMP = SynchedEntityData.m_135353_(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ATTACK_ANIMATION = SynchedEntityData.m_135353_(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> JUMP_ANIMATION = SynchedEntityData.m_135353_(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_RANGED = SynchedEntityData.m_135353_(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GRASP_ANIMATION = SynchedEntityData.m_135353_(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID ATTACK_MODIFIER_UUID = UUID.fromString("084afd3c-89c3-f8bd-1c76-c9a7a507c9f3");
    private static final AttributeModifier ATTACK_MODIFIER = new AttributeModifier(ATTACK_MODIFIER_UUID, "attack boost", 0.1, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("216e1242-75c7-8114-0500-6fc7e324dae6");
    private static final AttributeModifier ARMOR_MODIFIER = new AttributeModifier(ARMOR_MODIFIER_UUID, "armor boost", -0.15, AttributeModifier.Operation.MULTIPLY_BASE);
    private int attackTime;
    private int jumpTime;
    private int impactTime;
    private int stinkTime;
    private int rangedTime;
    private int graspTime;
    private final ShuDofuSpiderPart[] subEntities;
    public final ShuDofuSpiderPart body;
    private final ShuDofuSpiderPart leg1;
    private final ShuDofuSpiderPart leg2;
    private final ShuDofuSpiderPart leg3;
    private final ShuDofuSpiderPart leg4;
    private final ShuDofuSpiderPart leg5;
    private final ShuDofuSpiderPart leg6;
    private float leftLegAnimation;
    private float leftLegAnimationOld;
    private float rightLegAnimation;
    private float rightLegAnimationOld;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    public final AnimationState jumpAnimationState = new AnimationState();
    public final AnimationState graspAnimationState = new AnimationState();
    public final AnimationState graspPreAnimationState = new AnimationState();
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private float graspDamageReceived;

    public ShuDofuSpider(EntityType<? extends ShuDofuSpider> p_27508_, Level p_27509_) {
        super(p_27508_, p_27509_);
        this.body = new ShuDofuSpiderPart(this, "body", 2.0f, 3.0f);
        this.leg1 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg2 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg3 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg4 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg5 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg6 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.subEntities = new ShuDofuSpiderPart[]{this.body, this.leg1, this.leg2, this.leg3, this.leg4, this.leg5, this.leg6};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(id + i + 1);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_ANIMATION, (Object)false);
        this.f_19804_.m_135372_(JUMP_ANIMATION, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_JUMP, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_RANGED, (Object)false);
        this.f_19804_.m_135372_(GRASP_ANIMATION, (Object)false);
        this.f_19804_.m_135372_(ANGRY, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new JumpAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new graspAttackGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, null));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractTofunian.class, 10, true, true, null));
    }

    protected float m_6431_(Pose p_33799_, EntityDimensions p_33800_) {
        return 1.25f;
    }

    private boolean isMovingOnLand() {
        return this.m_20096_() && this.m_20184_().m_165925_() > 1.0E-6 && !this.m_20072_();
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.6f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TofuSounds.TOFUSPIDER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return (SoundEvent)TofuSounds.TOFUSPIDER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TofuSounds.TOFUSPIDER_DEATH.get();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction p_19958_) {
        if (this.isGraspAnim()) {
            if (!this.m_20197_().isEmpty()) {
                Vec3 riderPos = this.getRiderPosition();
                p_19958_.m_20372_(passenger, riderPos.m_7096_(), riderPos.m_7098_(), riderPos.m_7094_());
            }
        } else {
            super.m_19956_(passenger, p_19958_);
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    private Vec3 getRiderPosition() {
        if (!this.m_20197_().isEmpty()) {
            float distance = 3.0f;
            double dx = Math.cos((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            return new Vec3(this.m_20185_() + dx, this.m_20186_() + this.m_6048_() + ((Entity)this.m_20197_().get(0)).m_6049_(), this.m_20189_() + dz);
        }
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public double m_6048_() {
        return this.isGraspAnim() ? (double)this.m_6972_((Pose)this.m_20089_()).f_20378_ * 0.15 : super.m_6048_();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_8119_() {
        ++this.stinkTime;
        if (this.stinkTime == 120) {
            this.m_9236_().m_7106_((ParticleOptions)new ParticleStink.StinkData((ParticleType<ParticleStink.StinkData>)((ParticleType)TofuParticleTypes.STINK.get()), 45.0f, 20, ParticleStink.EnumStinkBehavior.GROW, 2.0f), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
            this.stinkTime = this.f_19796_.m_216339_(0, 20);
        }
        if (this.m_6084_() && !this.isMovingOnLand()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.idleAnimationState.m_216973_();
        }
        if (this.m_6084_() && this.isGraspAnim()) {
            this.graspAnimationState.m_216982_(this.f_19797_);
        } else {
            this.graspAnimationState.m_216973_();
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.m_6084_() && !this.isGraspAnim() && this.isAttackAnim() && this.m_5448_() != null) {
                ++this.attackTime;
                if (this.attackTime == 10) {
                    this.m_9236_().m_7605_((Entity)this, (byte)100);
                }
                if (this.attackTime == 14) {
                    float radius = 2.0f;
                    float swipePosX = (float)(this.m_20185_() + (double)radius * Math.cos(Math.toRadians(this.m_6080_() + 90.0f)));
                    float swipePosZ = (float)(this.m_20189_() + (double)radius * Math.sin(Math.toRadians(this.m_6080_() + 90.0f)));
                    AABB hitBox = new AABB(BlockPos.m_274561_((double)swipePosX, (double)(this.m_20186_() - 0.5), (double)swipePosZ)).m_82377_(1.55, 1.55, 1.55);
                    List entitiesHit = this.m_9236_().m_45976_(LivingEntity.class, hitBox);
                    for (Object entity : entitiesHit) {
                        if (entity == this || !this.m_6779_((LivingEntity)entity)) continue;
                        this.m_7327_((Entity)entity);
                    }
                    this.attackTime = 0;
                    this.setAttackAnimation(false);
                }
            }
            if (this.m_6084_() && this.isRanged() && this.m_5448_() != null) {
                ++this.rangedTime;
                if (this.rangedTime == 1) {
                    this.m_9236_().m_7605_((Entity)this, (byte)103);
                }
                if (this.rangedTime == 30) {
                    if (this.f_19796_.m_188503_(2) == 1) {
                        this.performRangedAttack(this.m_5448_());
                        this.m_5496_((SoundEvent)TofuSounds.TOFUSPIDER_SPIT.get(), 2.0f, (float)((double)0.6f + this.f_19796_.m_188500_() * (double)0.2f));
                    } else {
                        this.performBreathAttack(this.m_5448_());
                        this.m_5496_(SoundEvents.f_11896_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                    }
                }
                if (this.rangedTime == 50) {
                    this.rangedTime = 0;
                    this.setRanged(false);
                }
            }
            if (this.m_6084_() && this.isGraspAnim() && this.m_5448_() != null) {
                LivingEntity target = this.m_5448_();
                ++this.graspTime;
                if (this.graspTime == 1) {
                    this.m_21563_().m_24960_((Entity)target, 60.0f, 60.0f);
                    Vec3 vec3 = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_(), target.m_20189_() - this.m_20189_()).m_82541_();
                    this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_ * 1.25, 0.325, vec3.f_82481_ * 1.25));
                }
                if (this.graspTime > 1) {
                    Vec3 movement = this.m_20184_();
                    this.checkGraspAttack(this.m_20191_(), this.m_20191_().m_82363_(movement.f_82479_, movement.f_82480_, movement.f_82481_).m_82400_(1.0));
                }
                if (this.graspTime == 100) {
                    this.graspTime = 0;
                    this.setGraspAnimation(false);
                    this.m_20153_();
                }
            } else if (this.isGraspAnim()) {
                this.setGraspAnimation(false);
            }
            if (this.m_6084_() && this.isJumpAnim()) {
                ++this.jumpTime;
                if (this.jumpTime == 1) {
                    this.m_9236_().m_7605_((Entity)this, (byte)102);
                }
                if (this.jumpTime == 2) {
                    Vec3 movement = this.m_20184_();
                    this.checkJumpAttack(this.m_20191_(), this.m_20191_().m_82363_(movement.f_82479_, movement.f_82480_, movement.f_82481_));
                }
                if (this.jumpTime == 30 && this.m_20096_()) {
                    this.impactTime = this.jumpTime + 40;
                }
                if (this.jumpTime >= this.impactTime && this.m_20096_()) {
                    ServerLevel world = (ServerLevel)this.m_9236_();
                    int count = 36;
                    float distance = 4.0f;
                    for (int i = 1; i <= count; ++i) {
                        double yaw = (float)i * 360.0f / (float)count;
                        world.m_8767_((ParticleOptions)new ParticleStink.StinkData((ParticleType<ParticleStink.StinkData>)((ParticleType)TofuParticleTypes.STINK.get()), 20.0f, 20, ParticleStink.EnumStinkBehavior.GROW, 1.0f), this.m_20185_() + Math.cos(Math.toRadians(yaw)) * (double)distance, this.m_20186_(), this.m_20189_() + Math.sin(Math.toRadians(yaw)) * (double)distance, 0, 0.0, 0.0, 0.0, 0.0);
                    }
                    float radius = 5.0f;
                    AABB hitBox = new AABB(BlockPos.m_274561_((double)(this.m_20185_() - (double)radius), (double)(this.m_20186_() - 1.0), (double)(this.m_20189_() - (double)radius)), BlockPos.m_274561_((double)(this.m_20185_() + (double)radius), (double)(this.m_20186_() + 2.0), (double)(this.m_20189_() + (double)radius)));
                    List entitiesHit = this.m_9236_().m_45976_(LivingEntity.class, hitBox);
                    for (LivingEntity entity : entitiesHit) {
                        if (entity == this || !this.m_6779_(entity)) continue;
                        double d12 = Math.sqrt(entity.m_20280_((Entity)entity)) / (double)radius * 2.0;
                        double d14 = Explosion.m_46064_((Vec3)new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), (Entity)entity);
                        double d10 = (1.0 - d12) * d14;
                        entity.m_6469_(this.m_269291_().m_269298_(TofuDamageSource.SOY_SPORE, (Entity)this), (float)((d10 * d10 + d10) / 2.0 * 38.0));
                    }
                    this.m_5496_(SoundEvents.f_12555_, 2.0f, 1.0f);
                    this.impactTime = 0;
                    this.jumpTime = 0;
                    this.setJumpAnimation(false);
                    CameraEvent.addCameraHolderList((Level)this.m_9236_(), (CameraHolder)new CameraHolder(16, 60, 0.4f, GlobalVec3.of((ResourceKey)this.m_9236_().m_46472_(), (Vec3)this.m_20182_())));
                }
            }
            if (this.isJump() && this.isInFluidType()) {
                this.m_6862_(false);
                this.setJumpAnimation(false);
            }
        } else {
            this.rightLegAnimationOld = this.rightLegAnimation;
            this.leftLegAnimationOld = this.leftLegAnimation;
            if (!this.isJump() && this.subEntities != null) {
                Direction direction = Direction.m_122364_((double)this.f_20883_);
                BlockPos pos = this.m_20183_();
                BlockState air = Blocks.f_50016_.m_49966_();
                BlockState rBlock = this.m_9236_().m_8055_(this.leg1.m_20183_().m_7495_());
                BlockState rBlockF = this.m_9236_().m_8055_(this.leg2.m_20183_().m_7495_());
                BlockState rBlockB = this.m_9236_().m_8055_(this.leg3.m_20183_().m_7495_());
                this.rightLegAnimation = rBlock == air && rBlockF == air && rBlockB == air ? Mth.m_14036_((float)(this.rightLegAnimation + 0.1f), (float)-1.0f, (float)1.0f) : Mth.m_14036_((float)(this.rightLegAnimation * 0.5f), (float)-1.0f, (float)1.0f);
                boolean lBlock = this.hasEmptyCollisionOnLeg(this.leg4.m_20183_().m_7495_());
                boolean lBlockF = this.hasEmptyCollisionOnLeg(this.leg5.m_20183_().m_7495_());
                boolean lBlockB = this.hasEmptyCollisionOnLeg(this.leg6.m_20183_().m_7495_());
                this.leftLegAnimation = lBlock && lBlockF && lBlockB ? Mth.m_14036_((float)(this.leftLegAnimation + 0.1f), (float)-1.0f, (float)1.0f) : Mth.m_14036_((float)(this.leftLegAnimation * 0.5f), (float)-1.0f, (float)1.0f);
            } else {
                this.rightLegAnimation = Mth.m_14036_((float)(this.rightLegAnimation + 0.1f), (float)-1.0f, (float)1.0f);
                this.leftLegAnimation = Mth.m_14036_((float)(this.leftLegAnimation + 0.1f), (float)-1.0f, (float)1.0f);
            }
        }
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
        }
        Vec3 vec3 = new Vec3(0.0, 1.0, -2.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        Vec3 vec32 = new Vec3(2.0, 0.0, 1.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        Vec3 vec33 = new Vec3(2.0, 0.0, 0.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        Vec3 vec34 = new Vec3(2.0, 0.0, -1.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        Vec3 vec35 = new Vec3(-2.0, 0.0, 1.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        Vec3 vec36 = new Vec3(-2.0, 0.0, 0.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        Vec3 vec37 = new Vec3(-2.0, 0.0, -1.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        this.tickPart(this.body, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        this.tickPart(this.leg1, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_);
        this.tickPart(this.leg2, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_);
        this.tickPart(this.leg3, vec34.f_82479_, vec34.f_82480_, vec34.f_82481_);
        this.tickPart(this.leg4, vec35.f_82479_, vec35.f_82480_, vec35.f_82481_);
        this.tickPart(this.leg5, vec36.f_82479_, vec36.f_82480_, vec36.f_82481_);
        this.tickPart(this.leg6, vec37.f_82479_, vec37.f_82480_, vec37.f_82481_);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].f_19854_ = avec3[l].f_82479_;
            this.subEntities[l].f_19855_ = avec3[l].f_82480_;
            this.subEntities[l].f_19856_ = avec3[l].f_82481_;
            this.subEntities[l].f_19790_ = avec3[l].f_82479_;
            this.subEntities[l].f_19791_ = avec3[l].f_82480_;
            this.subEntities[l].f_19792_ = avec3[l].f_82481_;
        }
    }

    private void tickPart(ShuDofuSpiderPart p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.m_6034_(this.m_20185_() + p_31117_, this.m_20186_() + p_31118_, this.m_20189_() + p_31119_);
    }

    public boolean hasEmptyCollisionOnLeg(BlockPos blockPos) {
        boolean rBlock = this.m_9236_().m_8055_(blockPos).m_60812_((BlockGetter)this.m_9236_(), blockPos).m_83281_();
        return rBlock;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRightLegAnimationScale(float p_29570_) {
        return Mth.m_14179_((float)p_29570_, (float)this.rightLegAnimationOld, (float)this.rightLegAnimation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getLeftLegAnimationScale(float p_29570_) {
        return Mth.m_14179_((float)p_29570_, (float)this.leftLegAnimationOld, (float)this.leftLegAnimation);
    }

    public boolean m_213824_() {
        return this.isGraspAnim();
    }

    public void performRangedAttack(LivingEntity p_29912_) {
        this.m_5496_((SoundEvent)TofuSounds.TOFUSPIDER_SPIT.get(), 2.0f, (float)((double)0.6f + this.f_19796_.m_188500_() * (double)0.2f));
        for (int i = 0; i < 3; ++i) {
            NattoStringEntity natto = new NattoStringEntity(this.m_9236_(), (LivingEntity)this);
            double d1 = p_29912_.m_20185_() - this.m_20185_();
            double d2 = p_29912_.m_20186_() - this.m_20188_();
            double d3 = p_29912_.m_20189_() - this.m_20189_();
            float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
            natto.m_6686_(d1, d2 + (double)f, d3, 1.0f, 2.0f + (float)this.f_19796_.m_188503_(20) + 10.0f);
            this.m_9236_().m_7967_((Entity)natto);
        }
    }

    public void performBreathAttack(LivingEntity p_29912_) {
        NattoBallEntity ball = new NattoBallEntity(this.m_9236_(), (LivingEntity)this);
        double d1 = p_29912_.m_20185_() - this.m_20185_();
        double d2 = p_29912_.m_20188_() - this.m_20186_();
        double d3 = p_29912_.m_20189_() - this.m_20189_();
        ball.m_6686_(d1, d2 + 0.5, d3, 1.0f, 0.0f);
        this.m_9236_().m_7967_((Entity)ball);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 100) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (p_70103_1_ == 101) {
            this.deathAnimationState.m_216977_(this.f_19797_);
        } else if (p_70103_1_ == 102) {
            this.jumpAnimationState.m_216977_(this.f_19797_);
        } else if (p_70103_1_ == 104) {
            this.graspPreAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    protected void checkJumpAttack(AABB p_21072_, AABB p_21073_) {
        AABB aabb = p_21072_.m_82367_(p_21073_);
        List list = this.m_9236_().m_45933_((Entity)this, aabb);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity == this) continue;
                this.jumpAttack(entity);
                break;
            }
        } else if (this.f_19862_ && this.f_19797_ % 3 == 0) {
            this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
        }
    }

    public void jumpAttack(Entity p_36347_) {
        if (p_36347_.m_6097_() && !this.m_7307_(p_36347_)) {
            p_36347_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 18.0f);
            float i = (float)this.m_21133_(Attributes.f_22282_);
            i += (float)EnchantmentHelper.m_44894_((LivingEntity)this) + 1.5f;
            if (i > 0.0f) {
                if (p_36347_ instanceof LivingEntity) {
                    ((LivingEntity)p_36347_).m_147240_((double)i, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                } else {
                    p_36347_.m_5997_((double)(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * i), 0.1, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * i));
                }
                this.m_6858_(false);
            }
        }
    }

    protected void checkGraspAttack(AABB p_21072_, AABB p_21073_) {
        AABB aabb = p_21072_.m_82367_(p_21073_);
        List list = this.m_9236_().m_45933_((Entity)this, aabb);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity == this) continue;
                this.graspAttack(entity);
                break;
            }
        } else if (this.f_19862_ && this.f_19797_ % 3 == 0) {
            this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
        }
    }

    public void graspAttack(Entity p_36347_) {
        if (p_36347_.m_6097_() && !this.m_7307_(p_36347_)) {
            float f = (float)this.m_21133_(Attributes.f_22281_);
            if (p_36347_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f * 0.2f)) {
                this.m_5634_(f * 0.2f);
            }
            if (p_36347_ instanceof LivingEntity && !p_36347_.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) && this.m_20197_().isEmpty()) {
                p_36347_.m_8127_();
                p_36347_.m_7998_((Entity)this, true);
            }
            this.m_6858_(false);
        }
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12435_, 1.0f, 0.6f);
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        this.m_5496_(SoundEvents.f_12433_, 1.0f, 0.6f);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)101);
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 38) {
            // empty if block
        }
        if (this.f_20919_ == 40) {
            // empty if block
        }
        if (this.f_20919_ == 100 && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)101);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_6469_(DamageSource p_31461_, float p_31462_) {
        float f = this.m_21223_();
        if (this.m_6673_(p_31461_)) {
            return false;
        }
        if (!(p_31461_.m_276093_(DamageTypes.f_268469_) || p_31461_.m_276093_(DamageTypes.f_268585_) || p_31461_.m_276093_(DamageTypes.f_268613_) || p_31461_.m_276093_(DamageTypes.f_268612_) || p_31461_.m_276093_(DamageTypes.f_268669_))) {
            Entity entity = p_31461_.m_7640_();
            if (!this.isAngry() && this.m_21223_() < this.m_21233_() / 2.0f) {
                this.setAngry(true);
                this.m_5496_(SoundEvents.f_12555_, 2.0f, 1.0f);
            }
            if (entity instanceof FukumameEntity || p_31461_.m_276093_(DamageTypes.f_268515_) || p_31461_.m_276093_(DamageTypes.f_268530_)) {
                return false;
            }
            if (entity instanceof Projectile) {
                return super.m_6469_(p_31461_, p_31462_ * 0.35f);
            }
            if (this.isGraspAnim()) {
                this.graspDamageReceived = this.graspDamageReceived + f - this.m_21223_();
                if (this.graspDamageReceived > 0.1f * this.m_21233_()) {
                    this.graspDamageReceived = 0.0f;
                    this.setGraspAnimation(false);
                    this.attackTime = -60;
                }
            }
            return super.m_6469_(p_31461_, p_31462_);
        }
        return false;
    }

    public boolean hurt(ShuDofuSpiderPart shuDofuSpiderPart, DamageSource damageSource, float damage) {
        float f = this.m_21223_();
        this.reallyHurt(damageSource, damage * 0.9f);
        if (!this.isAngry() && this.m_21223_() < this.m_21233_() / 2.0f) {
            this.setAngry(true);
            this.m_5496_(SoundEvents.f_12555_, 2.0f, 1.0f);
        }
        if (this.isGraspAnim()) {
            this.graspDamageReceived = this.graspDamageReceived + f - this.m_21223_();
            if (this.graspDamageReceived > 0.1f * this.m_21233_()) {
                this.graspDamageReceived = 0.0f;
                this.setGraspAnimation(false);
                this.attackTime = -60;
            }
        }
        return true;
    }

    private boolean reallyHurt(DamageSource damageSource, float damage) {
        return super.m_6469_(damageSource, damage);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_142535_(float p_148989_, float p_148990_, DamageSource p_148991_) {
        return false;
    }

    protected void m_7840_(double p_29370_, boolean p_29371_, BlockState p_29372_, BlockPos p_29373_) {
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 5.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22285_, 1.0).m_22268_(Attributes.f_22281_, 16.0);
    }

    public boolean m_7307_(Entity p_20355_) {
        if (p_20355_ instanceof ShuDofuSpider || p_20355_ instanceof TofuSpider) {
            return this.m_5647_() == null && p_20355_.m_5647_() == null;
        }
        return super.m_7307_(p_20355_);
    }

    protected float m_6118_() {
        float f = 0.42f;
        Path path = this.f_21344_.m_26570_();
        if (path != null && !path.m_77392_()) {
            Vec3 vec3 = path.m_77380_((Entity)this);
            if (vec3.f_82480_ > this.m_20186_() + 0.5) {
                f = 0.5f;
            }
            if (vec3.f_82480_ > this.m_20186_() + 1.5) {
                f = 0.65f;
            }
        }
        return f / 0.42f * this.m_20098_() + this.m_285755_();
    }

    public float getSuppportJump() {
        return 2.125f;
    }

    protected int m_7302_(int p_28882_) {
        return p_28882_;
    }

    protected void m_8024_() {
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static boolean isPathClear(ShuDofuSpider p_28472_, LivingEntity p_28473_) {
        double d0 = p_28473_.m_20189_() - p_28472_.m_20189_();
        double d1 = p_28473_.m_20185_() - p_28472_.m_20185_();
        double d2 = d0 / d1;
        for (int j = 0; j < 6; ++j) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (p_28472_.m_9236_().m_8055_(BlockPos.m_274561_((double)(p_28472_.m_20185_() + d4), (double)(p_28472_.m_20186_() + (double)k), (double)(p_28472_.m_20189_() + d3))).m_247087_()) continue;
                return false;
            }
        }
        return true;
    }

    public void m_6457_(ServerPlayer p_31483_) {
        super.m_6457_(p_31483_);
        this.bossEvent.m_6543_(p_31483_);
    }

    public void m_6452_(ServerPlayer p_31488_) {
        super.m_6452_(p_31488_);
        this.bossEvent.m_6539_(p_31488_);
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128379_("Angry", this.isAngry());
    }

    public void m_7378_(CompoundTag p_31474_) {
        super.m_7378_(p_31474_);
        this.setAngry(p_31474_.m_128471_("Angry"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@javax.annotation.Nullable Component p_31476_) {
        super.m_6593_(p_31476_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setAttackAnimation(boolean attack) {
        this.f_19804_.m_135381_(ATTACK_ANIMATION, (Object)attack);
    }

    public boolean isAttackAnim() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK_ANIMATION);
    }

    public void setGraspAnimation(boolean grasp) {
        this.f_19804_.m_135381_(GRASP_ANIMATION, (Object)grasp);
    }

    public boolean isGraspAnim() {
        return (Boolean)this.f_19804_.m_135370_(GRASP_ANIMATION);
    }

    public void setJumpAnimation(boolean jump) {
        this.f_19804_.m_135381_(JUMP_ANIMATION, (Object)jump);
    }

    public boolean isJumpAnim() {
        return (Boolean)this.f_19804_.m_135370_(JUMP_ANIMATION);
    }

    private void setJump(boolean jump) {
        this.f_19804_.m_135381_(DATA_ID_JUMP, (Object)jump);
    }

    public boolean isJump() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_JUMP);
    }

    public void setRanged(boolean ranged) {
        this.f_19804_.m_135381_(DATA_ID_RANGED, (Object)ranged);
    }

    public boolean isRanged() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_RANGED);
    }

    public void setAngry(boolean angry) {
        this.f_19804_.m_135381_(ANGRY, (Object)angry);
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22281_);
            attributeinstance.m_22130_(ATTACK_MODIFIER);
            AttributeInstance attributeinstance2 = this.m_21051_(Attributes.f_22284_);
            attributeinstance2.m_22130_(ARMOR_MODIFIER);
            if (angry) {
                attributeinstance.m_22118_(ATTACK_MODIFIER);
                attributeinstance2.m_22118_(ARMOR_MODIFIER);
            }
        }
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    static class AttackGoal
    extends Goal {
        private final ShuDofuSpider spider;
        private int attackTime;
        private int attackStep;
        private int lastSeen;
        private Path path;

        public AttackGoal(ShuDofuSpider p_32247_) {
            this.spider = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.spider.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.spider.isGraspAnim()) {
                return false;
            }
            if (this.spider.isJumpAnim()) {
                return false;
            }
            this.path = this.spider.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.spider.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.lastSeen = 0;
        }

        protected double getAttackReachSqr(LivingEntity p_29587_) {
            return 4.0f + p_29587_.m_20205_();
        }

        public void m_8037_() {
            --this.attackTime;
            ShuDofuSpider entity = this.spider;
            LivingEntity entityTarget = entity.m_5448_();
            if (entityTarget != null) {
                boolean flag = this.spider.m_21574_().m_148306_((Entity)entityTarget);
                double d0 = this.spider.m_20280_((Entity)entityTarget);
                if (!this.spider.isRanged()) {
                    this.spider.m_21573_().m_26536_(this.path, 0.8);
                }
                if (!flag) {
                    return;
                }
                if (entity.m_20270_((Entity)entityTarget) <= 4.0f && this.attackTime <= 10) {
                    entity.setAttackAnimation(true);
                    this.attackTime = 20;
                    this.attackStep = 0;
                }
                if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 20;
                        } else if (this.attackStep <= 2) {
                            this.attackTime = 10;
                        } else {
                            this.attackTime = 20;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1 && !entity.isRanged()) {
                            this.spider.setRanged(true);
                        }
                    }
                    entity.m_21563_().m_24960_((Entity)entityTarget, 10.0f, 10.0f);
                }
            }
            super.m_8037_();
        }

        public boolean m_183429_() {
            return true;
        }

        private double getFollowDistance() {
            return this.spider.m_21133_(Attributes.f_22277_);
        }
    }

    public class JumpAttackGoal
    extends JumpGoal {
        private int attackTime;

        public boolean m_8036_() {
            if (this.attackTime == 0) {
                if (ShuDofuSpider.this.m_21223_() <= ShuDofuSpider.this.m_21233_() / 1.5f && !ShuDofuSpider.this.isGraspAnim()) {
                    LivingEntity livingentity = ShuDofuSpider.this.m_5448_();
                    if (livingentity != null && livingentity.m_6084_() && 10.0f >= ShuDofuSpider.this.m_20270_((Entity)livingentity)) {
                        if (ShuDofuSpider.this.f_19796_.m_188503_(2) == 0) {
                            return false;
                        }
                        if (livingentity.m_6374_() != livingentity.m_6350_()) {
                            return false;
                        }
                        boolean flag = ShuDofuSpider.isPathClear(ShuDofuSpider.this, livingentity);
                        if (!flag) {
                            ShuDofuSpider.this.m_21573_().m_6570_((Entity)livingentity, 0);
                        }
                        ShuDofuSpider.this.setJump(true);
                        this.attackTime = 120;
                        return flag;
                    }
                    return false;
                }
                return false;
            }
            --this.attackTime;
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = ShuDofuSpider.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                double d0 = ShuDofuSpider.this.m_20184_().f_82480_;
                return !(d0 * d0 < (double)0.05f) || !(Math.abs(ShuDofuSpider.this.m_146909_()) < 15.0f) || !ShuDofuSpider.this.m_20096_();
            }
            return false;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            ShuDofuSpider.this.m_6862_(true);
            LivingEntity livingentity = ShuDofuSpider.this.m_5448_();
            if (livingentity != null) {
                ShuDofuSpider.this.setJumpAnimation(true);
                ShuDofuSpider.this.m_21563_().m_24960_((Entity)livingentity, 60.0f, 60.0f);
                Vec3 vec3 = new Vec3(livingentity.m_20185_() - ShuDofuSpider.this.m_20185_(), livingentity.m_20186_() - ShuDofuSpider.this.m_20186_(), livingentity.m_20189_() - ShuDofuSpider.this.m_20189_()).m_82541_();
                ShuDofuSpider.this.m_20256_(ShuDofuSpider.this.m_20184_().m_82520_(vec3.f_82479_ * 1.2, 1.2, vec3.f_82481_ * 1.2));
            }
            ShuDofuSpider.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            ShuDofuSpider.this.setJump(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = ShuDofuSpider.this.m_5448_();
            Vec3 vec3 = ShuDofuSpider.this.m_20184_();
            if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && ShuDofuSpider.this.m_146909_() != 0.0f) {
                ShuDofuSpider.this.m_146926_(Mth.m_14189_((float)ShuDofuSpider.this.m_146909_(), (float)0.0f, (float)0.2f));
            } else {
                double d0 = vec3.m_165924_();
                double d1 = Math.signum(-vec3.f_82480_) * Math.acos(d0 / vec3.m_82553_()) * 57.2957763671875;
                ShuDofuSpider.this.m_146926_((float)d1);
            }
        }
    }

    static class graspAttackGoal
    extends Goal {
        private final ShuDofuSpider spider;
        private int attackTime;
        private int preAttackTime;

        public graspAttackGoal(ShuDofuSpider p_32247_) {
            this.spider = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.attackTime == 0) {
                LivingEntity livingentity = this.spider.m_5448_();
                if (livingentity != null && this.spider.isAngry() && livingentity.m_6084_() && 10.0f >= this.spider.m_20270_((Entity)livingentity)) {
                    if (livingentity.m_6374_() != livingentity.m_6350_()) {
                        return false;
                    }
                    boolean flag = ShuDofuSpider.isPathClear(this.spider, livingentity);
                    if (!flag) {
                        this.spider.m_21573_().m_6570_((Entity)livingentity, 0);
                    }
                    this.attackTime = 350;
                    return flag;
                }
                return false;
            }
            --this.attackTime;
            return false;
        }

        public boolean m_8045_() {
            return this.preAttackTime < 30;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            LivingEntity livingentity = this.spider.m_5448_();
            if (livingentity != null) {
                this.spider.m_9236_().m_7605_((Entity)this.spider, (byte)104);
                this.spider.m_8032_();
            }
            this.preAttackTime = 0;
        }

        public void m_8037_() {
            this.spider.m_21573_().m_26573_();
            ++this.preAttackTime;
        }

        public void m_8041_() {
            super.m_8041_();
            LivingEntity livingentity = this.spider.m_5448_();
            if (livingentity != null) {
                this.spider.setGraspAnimation(true);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

