/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import baguchan.tofucraft.client.particle.ParticleZundaCloud;
import baguchan.tofucraft.entity.HealInteractable;
import baguchan.tofucraft.entity.ItemBasedInteractable;
import baguchan.tofucraft.entity.ItemInteractable;
import baguchan.tofucraft.registry.TofuBiomes;
import baguchan.tofucraft.registry.TofuEntityTypes;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuParticleTypes;
import baguchan.tofucraft.registry.TofuTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IExtensibleEnum;
import org.jetbrains.annotations.Nullable;

public class TofuPig
extends Pig
implements ItemInteractable {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TofuItems.LEEK.get(), Items.f_42619_});
    private static final EntityDataAccessor<Integer> DATA_HEALING_TIME = SynchedEntityData.m_135353_(TofuPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemBasedInteractable healilng;
    private static final EntityDataAccessor<String> TOFUPIG_TYPE = SynchedEntityData.m_135353_(TofuPig.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public TofuPig(EntityType<? extends Pig> p_29462_, Level p_29463_) {
        super(p_29462_, p_29463_);
        this.healilng = new HealInteractable(this.f_19804_, DATA_HEALING_TIME);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder m_29503_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public static boolean checkTofuAnimalSpawnRules(EntityType<? extends Animal> p_27578_, LevelAccessor p_27579_, MobSpawnType p_27580_, BlockPos p_27581_, RandomSource p_27582_) {
        return p_27579_.m_8055_(p_27581_.m_7495_()).m_204336_(TofuTags.Blocks.TOFU_TERRAIN) && p_27579_.m_45524_(p_27581_, 0) > 8;
    }

    public InteractionResult m_6071_(Player p_28298_, InteractionHand p_28299_) {
        ItemStack var3 = p_28298_.m_21120_(p_28299_);
        if (var3.m_150930_((Item)TofuItems.TOFUMETAL.get()) && !this.m_6162_() && this.getTofuPigType().equals((Object)TofuPigType.NORMAL)) {
            p_28298_.m_5496_(SoundEvents.f_11671_, 1.0f, 1.0f);
            var3.m_41774_(1);
            this.setTofuPigType(TofuPigType.METAL);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (var3.m_150930_((Item)TofuItems.TOFUGRILLED.get()) && !this.m_6162_() && this.getTofuPigType().equals((Object)TofuPigType.NORMAL)) {
            p_28298_.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            var3.m_41774_(1);
            this.setTofuPigType(TofuPigType.GRILLED);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (var3.m_150930_((Item)TofuItems.TOFUZUNDA.get()) && !this.m_6162_() && this.getTofuPigType().equals((Object)TofuPigType.NORMAL)) {
            p_28298_.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            var3.m_41774_(1);
            this.setTofuPigType(TofuPigType.ZUNDA);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_28298_, p_28299_);
    }

    @javax.annotation.Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (this.m_6254_() && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            if (this.getTofuPigType() == TofuPigType.ZUNDA && (player.m_21205_().m_150930_((Item)TofuItems.ZUNDAMUSHROOM_ON_A_STICK.get()) || player.m_21206_().m_150930_((Item)TofuItems.ZUNDAMUSHROOM_ON_A_STICK.get()))) {
                return player;
            }
            if (player.m_21205_().m_150930_(Items.f_42684_) || player.m_21206_().m_150930_(Items.f_42684_)) {
                return player;
            }
        }
        return null;
    }

    public void m_8038_(ServerLevel p_29473_, LightningBolt p_29474_) {
        if (this.getTofuPigType() == TofuPigType.NORMAL) {
            this.setTofuPigType(TofuPigType.ZUNDA);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        if (p_146746_.m_204166_(this.m_20183_()).m_203565_(TofuBiomes.ZUNDA_FOREST)) {
            this.setTofuPigType(TofuPigType.ZUNDA);
        }
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public boolean isActivated() {
        return this.healilng.on;
    }

    public void m_8119_() {
        if (this.isActivated() && this.getTofuPigType() == TofuPigType.ZUNDA) {
            this.healEffect();
            this.healilng.deActive();
        }
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (this.getTofuPigType() == TofuPigType.METAL) {
            damage = (float)((double)damage * 0.5);
        } else if (this.getTofuPigType() == TofuPigType.GRILLED && source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    public void setTofuPigType(TofuPigType type) {
        this.f_19804_.m_135381_(TOFUPIG_TYPE, (Object)type.name());
    }

    public TofuPigType getTofuPigType() {
        return TofuPigType.get((String)this.f_19804_.m_135370_(TOFUPIG_TYPE));
    }

    @Override
    public boolean canHeal() {
        return this.healilng.active(this.m_217043_());
    }

    private void healEffect() {
        float radius = 5.0f;
        AABB box = new AABB(BlockPos.m_274561_((double)(this.m_20185_() - (double)radius), (double)(this.m_20186_() - 1.0), (double)(this.m_20189_() - (double)radius)), BlockPos.m_274561_((double)(this.m_20185_() + (double)radius), (double)(this.m_20186_() + 3.0), (double)(this.m_20189_() + (double)radius)));
        List hitEntities = this.m_9236_().m_45976_(LivingEntity.class, box);
        for (LivingEntity hitEntity : hitEntities) {
            if (hitEntity.m_9236_().f_46443_) continue;
            hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200));
        }
        if (this.m_9236_().f_46443_) {
            int count = 20;
            for (int i = 1; i <= count; ++i) {
                double yaw = (float)i * 365.0f / (float)count;
                double speed = 0.5;
                double xSpeed = speed * Math.cos(Math.toRadians(yaw));
                double zSpeed = speed * Math.sin(Math.toRadians(yaw));
                this.m_9236_().m_7106_((ParticleOptions)new ParticleZundaCloud.CloudData((ParticleType<ParticleZundaCloud.CloudData>)((ParticleType)TofuParticleTypes.ZUNDA_CLOUD.get()), 40.0f, 20, ParticleZundaCloud.EnumCloudBehavior.GROW, 1.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), xSpeed, 0.0, zSpeed);
            }
        }
    }

    public TofuPig getBreedOffspring(ServerLevel p_148890_, AgeableMob p_148891_) {
        TofuPig tofuPig = (TofuPig)((EntityType)TofuEntityTypes.TOFUPIG.get()).m_20615_((Level)p_148890_);
        if (tofuPig != null) {
            TofuPigType variant = this.f_19796_.m_188499_() ? this.getTofuPigType() : ((TofuPig)p_148891_).getTofuPigType();
            tofuPig.setTofuPigType(variant);
        }
        return tofuPig;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("TofuPigType", this.getTofuPigType().name());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("TofuPigType")) {
            this.setTofuPigType(TofuPigType.get(compound.m_128461_("TofuPigType")));
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_29480_) {
        if (DATA_HEALING_TIME.equals(p_29480_) && this.m_9236_().f_46443_) {
            this.healilng.onSynced();
        }
        super.m_7350_(p_29480_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TOFUPIG_TYPE, (Object)TofuPigType.NORMAL.name());
        this.f_19804_.m_135372_(DATA_HEALING_TIME, (Object)0);
    }

    public float getSteeringSpeed() {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.35f;
    }

    public boolean m_6898_(ItemStack p_27600_) {
        return FOOD_ITEMS.test(p_27600_);
    }

    public static enum TofuPigType implements IExtensibleEnum
    {
        NORMAL,
        METAL,
        GRILLED,
        ZUNDA;


        public static TofuPigType get(String nameIn) {
            for (TofuPigType role : TofuPigType.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return NORMAL;
        }

        public static TofuPigType create(String name) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

