/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import baguchan.tofucraft.registry.TofuBiomes;
import baguchan.tofucraft.registry.TofuItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;

public class TofuSlime
extends Slime {
    private static final EntityDataAccessor<Boolean> DATA_CONVERSION_ID = SynchedEntityData.m_135353_(TofuSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int onZundaTime;
    private int conversionTime;

    public TofuSlime(EntityType<? extends Slime> p_33588_, Level p_33589_) {
        super(p_33588_, p_33589_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_CONVERSION_ID, (Object)false);
    }

    public boolean isZundaConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERSION_ID);
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_21525_()) {
            if (this.isZundaConverting()) {
                --this.conversionTime;
                if (this.conversionTime < 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20562_, timer -> {
                    this.conversionTime = timer;
                })) {
                    this.doZundaConversion();
                }
            } else if (this.convertsOnZunda()) {
                if (this.m_9236_().m_204166_(this.m_20183_()).m_203565_(TofuBiomes.ZUNDA_FOREST)) {
                    ++this.onZundaTime;
                    if (this.onZundaTime >= 600) {
                        this.startZundaConversion(300);
                    }
                } else {
                    this.onZundaTime = -1;
                }
            }
        }
        super.m_8119_();
    }

    protected boolean convertsOnZunda() {
        return true;
    }

    private void startZundaConversion(int p_34279_) {
        this.conversionTime = p_34279_;
        this.m_20088_().m_135381_(DATA_CONVERSION_ID, (Object)true);
    }

    protected void doZundaConversion() {
        this.m_19983_(new ItemStack((ItemLike)TofuItems.TOFUZUNDA.get(), 2 * this.m_33632_()));
        this.m_216990_(SoundEvents.f_12616_);
        this.m_146870_();
    }

    public void m_7380_(CompoundTag p_34319_) {
        super.m_7380_(p_34319_);
        p_34319_.m_128405_("OnZundaTime", this.convertsOnZunda() ? this.onZundaTime : -1);
        p_34319_.m_128405_("ZundaConversionTime", this.isZundaConverting() ? this.conversionTime : -1);
        p_34319_.m_128379_("ZundaConverting", this.isZundaConverting());
    }

    public void m_7378_(CompoundTag p_34305_) {
        super.m_7378_(p_34305_);
        this.onZundaTime = p_34305_.m_128451_("OnZundaTime");
        if (p_34305_.m_128425_("ZundaConversionTime", 99) && p_34305_.m_128451_("ZundaConversionTime") > -1) {
            this.startZundaConversion(p_34305_.m_128451_("ZundaConversionTime"));
        }
    }

    protected ParticleOptions m_6300_() {
        return new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)TofuItems.TOFUKINU.get()));
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor p_33009_, BlockPos p_33010_, RandomSource p_33011_) {
        if (p_33009_.m_45517_(LightLayer.SKY, p_33010_) > p_33011_.m_188503_(32)) {
            return false;
        }
        int var3 = p_33009_.m_6018_().m_46470_() ? p_33009_.m_46849_(p_33010_, 10) : p_33009_.m_46803_(p_33010_);
        return var3 <= p_33011_.m_188503_(8);
    }

    public void m_8038_(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            this.doZundaConversion();
        }
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends TofuSlime> p_33018_, ServerLevelAccessor p_33019_, MobSpawnType p_33020_, BlockPos p_33021_, RandomSource p_33022_) {
        return p_33019_.m_46791_() != Difficulty.PEACEFUL && TofuSlime.isDarkEnoughToSpawn(p_33019_, p_33021_, p_33022_) && TofuSlime.m_217057_(p_33018_, (LevelAccessor)p_33019_, (MobSpawnType)p_33020_, (BlockPos)p_33021_, (RandomSource)p_33022_);
    }
}

