/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity.effect;

import baguchan.tofucraft.entity.ShuDofuSpider;
import baguchan.tofucraft.registry.TofuEntityTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class NattoCobWebEntity
extends LivingEntity {
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int lifeTime;
    private static final int discardTime = 600;

    public NattoCobWebEntity(EntityType<? extends NattoCobWebEntity> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.f_19811_ = true;
    }

    public NattoCobWebEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends NattoCobWebEntity>)((EntityType)TofuEntityTypes.NATTO_COBWEB.get()), level);
        this.m_6034_(x, y, z);
    }

    public void m_8119_() {
        this.downGround();
        this.stepSlow();
        if (this.lifeTime >= 600) {
            this.m_146870_();
        }
        ++this.lifeTime;
        super.m_8119_();
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public void downGround() {
        BlockHitResult hitResult;
        HitResult rayTrace = this.rayTrace(this);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK && (hitResult = (BlockHitResult)rayTrace).m_82434_() == Direction.UP) {
            BlockState hitBlock = this.m_9236_().m_8055_(hitResult.m_82425_());
            if (this.lifeTime > 600 && hitBlock != this.m_9236_().m_8055_(this.m_20183_().m_7495_())) {
                this.m_146870_();
            }
            if (hitBlock.m_60734_() instanceof SlabBlock && hitBlock.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                this.m_6034_(this.m_20185_(), (float)hitResult.m_82425_().m_123342_() + 1.0625f - 0.5f, this.m_20189_());
            } else {
                this.m_6034_(this.m_20185_(), (float)hitResult.m_82425_().m_123342_() + 1.0625f, this.m_20189_());
            }
            if (this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundTeleportEntityPacket((Entity)this));
            }
        }
    }

    private HitResult rayTrace(NattoCobWebEntity entity) {
        Vec3 startPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 endPos = new Vec3(entity.m_20185_(), 0.0, entity.m_20189_());
        return entity.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    public void stepSlow() {
        AABB area = new AABB(BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 0.5), (double)this.m_20189_())).m_82377_(1.0, 0.5, 1.0);
        List entitiesHit = this.m_9236_().m_45976_(LivingEntity.class, area);
        for (LivingEntity entity : entitiesHit) {
            double d0 = Math.abs(entity.m_20184_().f_82480_);
            double d1 = Math.abs(entity.m_20184_().f_82479_) + Math.abs(entity.m_20184_().f_82481_);
            this.m_183634_();
            entity.m_7601_(Blocks.f_50033_.m_49966_(), new Vec3(0.3, (double)0.05f, 0.3));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22278_, 5.0);
    }

    public boolean isSpawing() {
        return this.lifeTime < 4;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 3 && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_6469_(DamageSource p_31461_, float p_31462_) {
        if (this.m_6673_(p_31461_)) {
            return false;
        }
        if (!(p_31461_.m_276093_(DamageTypes.f_268469_) || p_31461_.m_276093_(DamageTypes.f_268585_) || p_31461_.m_276093_(DamageTypes.f_268613_) || p_31461_.m_276093_(DamageTypes.f_268612_) || p_31461_.m_276093_(DamageTypes.f_268669_) || p_31461_.m_276093_(DamageTypes.f_268722_) || p_31461_.m_7639_() instanceof ShuDofuSpider)) {
            Entity entity = p_31461_.m_7640_();
            if (entity instanceof Projectile) {
                return false;
            }
            return super.m_6469_(p_31461_, p_31462_);
        }
        return false;
    }

    protected void m_6138_() {
    }

    public Iterable<ItemStack> m_6167_() {
        return this.handItems;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot p_31612_) {
        switch (p_31612_.m_20743_()) {
            case HAND: {
                return (ItemStack)this.handItems.get(p_31612_.m_20749_());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(p_31612_.m_20749_());
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot p_31584_, ItemStack p_31585_) {
        this.m_181122_(p_31585_);
        switch (p_31584_.m_20743_()) {
            case HAND: {
                this.m_238392_(p_31584_, (ItemStack)this.handItems.set(p_31584_.m_20749_(), (Object)p_31585_), p_31585_);
                break;
            }
            case ARMOR: {
                this.m_238392_(p_31584_, (ItemStack)this.armorItems.set(p_31584_.m_20749_(), (Object)p_31585_), p_31585_);
            }
        }
    }

    public void m_7380_(CompoundTag p_31619_) {
        super.m_7380_(p_31619_);
        ListTag listtag = new ListTag();
        for (ItemStack itemstack : this.armorItems) {
            CompoundTag compoundtag = new CompoundTag();
            if (!itemstack.m_41619_()) {
                itemstack.m_41739_(compoundtag);
            }
            listtag.add((Object)compoundtag);
        }
        p_31619_.m_128365_("ArmorItems", (Tag)listtag);
        ListTag listtag1 = new ListTag();
        for (ItemStack itemstack1 : this.handItems) {
            CompoundTag compoundtag1 = new CompoundTag();
            if (!itemstack1.m_41619_()) {
                itemstack1.m_41739_(compoundtag1);
            }
            listtag1.add((Object)compoundtag1);
        }
    }

    public void m_7378_(CompoundTag p_31600_) {
        super.m_7378_(p_31600_);
        if (p_31600_.m_128425_("ArmorItems", 9)) {
            ListTag listtag = p_31600_.m_128437_("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)ItemStack.m_41712_((CompoundTag)listtag.m_128728_(i)));
            }
        }
        if (p_31600_.m_128425_("HandItems", 9)) {
            ListTag listtag1 = p_31600_.m_128437_("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                this.handItems.set(j, (Object)ItemStack.m_41712_((CompoundTag)listtag1.m_128728_(j)));
            }
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }
}

