/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public abstract class TofuDoorInteractGoal
extends Goal {
    protected Mob mob;
    protected BlockPos doorPos = BlockPos.f_121853_;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;

    public TofuDoorInteractGoal(Mob p_25193_) {
        this.mob = p_25193_;
        if (!GoalUtils.m_26894_((Mob)p_25193_)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState blockstate = this.mob.m_9236_().m_8055_(this.doorPos);
        if (!(blockstate.m_60734_() instanceof DoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return (Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_);
    }

    protected void setOpen(boolean p_25196_) {
        BlockState blockstate;
        if (this.hasDoor && (blockstate = this.mob.m_9236_().m_8055_(this.doorPos)).m_60734_() instanceof DoorBlock) {
            ((DoorBlock)blockstate.m_60734_()).m_153165_((Entity)this.mob, this.mob.m_9236_(), blockstate, this.doorPos, p_25196_);
        }
    }

    public boolean m_8036_() {
        if (!GoalUtils.m_26894_((Mob)this.mob)) {
            return false;
        }
        if (!this.mob.f_19862_) {
            return false;
        }
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.mob.m_21573_();
        Path path = groundpathnavigation.m_26570_();
        if (path != null && !path.m_77392_() && groundpathnavigation.m_26492_()) {
            for (int i = 0; i < Math.min(path.m_77399_() + 2, path.m_77398_()); ++i) {
                Node node = path.m_77375_(i);
                this.doorPos = new BlockPos(node.f_77271_, node.f_77272_ + 1, node.f_77273_);
                if (this.mob.m_20275_((double)this.doorPos.m_123341_(), this.mob.m_20186_(), (double)this.doorPos.m_123343_()) > 2.25) continue;
                this.hasDoor = TofuDoorInteractGoal.isWoodenDoorOrTofuDoor(this.mob.m_9236_(), this.doorPos);
                if (!this.hasDoor) continue;
                return true;
            }
            this.doorPos = this.mob.m_20183_().m_7494_();
            this.hasDoor = TofuDoorInteractGoal.isWoodenDoorOrTofuDoor(this.mob.m_9236_(), this.doorPos);
            return this.hasDoor;
        }
        return false;
    }

    public static boolean isWoodenDoorOrTofuDoor(Level p_52746_, BlockPos p_52747_) {
        return DoorBlock.m_52817_((BlockState)p_52746_.m_8055_(p_52747_)) || TofuDoorInteractGoal.isTofuDoor(p_52746_.m_8055_(p_52747_));
    }

    public static boolean isTofuDoor(BlockState p_52818_) {
        return p_52818_.m_60734_() instanceof DoorBlock;
    }

    public boolean m_8045_() {
        return !this.passed;
    }

    public void m_8056_() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.m_123341_() + 0.5 - this.mob.m_20185_());
        this.doorOpenDirZ = (float)((double)this.doorPos.m_123343_() + 0.5 - this.mob.m_20189_());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        float f1;
        float f = (float)((double)this.doorPos.m_123341_() + 0.5 - this.mob.m_20185_());
        float f2 = this.doorOpenDirX * f + this.doorOpenDirZ * (f1 = (float)((double)this.doorPos.m_123343_() + 0.5 - this.mob.m_20189_()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }
}

