/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.inventory;

import baguchan.tofucraft.blockentity.tfenergy.TFCraftingTableBlockEntity;
import baguchan.tofucraft.inventory.slot.TofuPotResultSlot;
import baguchan.tofucraft.registry.TofuMenus;
import baguchan.tofucraft.registry.TofuRecipeBookTypes;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TFCraftingTableMenu
extends RecipeBookMenu<Container> {
    public final Container inventory;
    private final ContainerData data;
    protected final Level level;

    public TFCraftingTableMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, (Container)new SimpleContainer(10), (ContainerData)new SimpleContainerData(4));
    }

    public TFCraftingTableMenu(int windowId, Inventory playerInventory, Container furnaceInventoryIn, ContainerData cookingPotDataIn) {
        super((MenuType)TofuMenus.TF_CRAFTING_TABLE.get(), windowId);
        int column;
        this.inventory = furnaceInventoryIn;
        this.data = cookingPotDataIn;
        this.level = playerInventory.f_35978_.m_9236_();
        int startX = 8;
        int startY = 18;
        int inputStartX = 30;
        int inputStartY = 17;
        int borderSlotSize = 18;
        for (int row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                this.m_38897_(new Slot(this.inventory, row * 3 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_(new TofuPotResultSlot(playerInventory.f_35978_, this.inventory, 9, 123, 34){

            @Override
            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        int startPlayerInvY = 84;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.m_38884_(cookingPotDataIn);
    }

    private static TFCraftingTableBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof TFCraftingTableBlockEntity) {
            return (TFCraftingTableBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(Player p_75145_1_) {
        return this.inventory.m_6542_(p_75145_1_);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int indexMealDisplay = 6;
        int indexContainerInput = 7;
        int indexOutput = 8;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack slotStackCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            slotStackCopy = slotStack.m_41777_();
            if (index != indexOutput ? (index >= startPlayerInv && index < endPlayerInv - 9 ? !this.m_38903_(slotStack, endPlayerInv - 9, endPlayerInv, false) : index >= endPlayerInv - 9 && index < endPlayerInv && !this.m_38903_(slotStack, startPlayerInv, endPlayerInv - 9, false)) : !this.m_38903_(slotStack, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == slotStackCopy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return slotStackCopy;
    }

    public int getCookProgressionScaled() {
        int i = this.data.m_6413_(0);
        int j = this.data.m_6413_(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getTFEnergy() {
        int i = this.data.m_6413_(2);
        return i;
    }

    public int getTFMaxEnergy() {
        int i = this.data.m_6413_(3);
        return i;
    }

    public void m_5816_(StackedContents helper) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            helper.m_36466_(this.inventory.m_8020_(i));
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 8; ++i) {
            this.inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super Container> p_38980_) {
        return p_38980_.m_5818_(this.inventory, this.level);
    }

    public int m_6636_() {
        return 9;
    }

    public int m_6635_() {
        return 3;
    }

    public int m_6656_() {
        return 3;
    }

    public int m_6653_() {
        return 9;
    }

    public RecipeBookType m_5867_() {
        return TofuRecipeBookTypes.TF_CRAFT;
    }

    public boolean m_142157_(int slot) {
        return slot < this.m_6635_() * this.m_6656_();
    }
}

