/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.inventory;

import baguchan.tofucraft.blockentity.TofuPotBlockEntity;
import baguchan.tofucraft.inventory.slot.TofuPotResultSlot;
import baguchan.tofucraft.registry.TofuMenus;
import baguchan.tofucraft.registry.TofuRecipeBookTypes;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TofuPotMenu
extends RecipeBookMenu<Container> {
    public final Container inventory;
    private final ContainerData cookingPotData;
    protected final Level level;

    public TofuPotMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, (Container)new SimpleContainer(14), (ContainerData)new SimpleContainerData(2));
    }

    public TofuPotMenu(int windowId, Inventory playerInventory, Container furnaceInventoryIn, ContainerData cookingPotDataIn) {
        super((MenuType)TofuMenus.TOFU_POT.get(), windowId);
        int column;
        this.inventory = furnaceInventoryIn;
        this.cookingPotData = cookingPotDataIn;
        this.level = playerInventory.f_35978_.m_9236_();
        int startX = 8;
        int startY = 18;
        int inputStartX = 44;
        int inputStartY = 8;
        int borderSlotSize = 18;
        for (int row = 0; row < 4; ++row) {
            for (column = 0; column < 3; ++column) {
                this.m_38897_(new Slot(this.inventory, row * 3 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_(new TofuPotResultSlot(playerInventory.f_35978_, this.inventory, 13, 130, 37){

            @Override
            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        int startPlayerInvY = 96;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 154));
        }
        this.m_38884_(cookingPotDataIn);
    }

    private static TofuPotBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof TofuPotBlockEntity) {
            return (TofuPotBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(Player p_75145_1_) {
        return this.inventory.m_6542_(p_75145_1_);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int indexMealDisplay = 6;
        int indexContainerInput = 7;
        int indexOutput = 11;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack slotStackCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            slotStackCopy = slotStack.m_41777_();
            if (index != indexOutput ? (index >= startPlayerInv && index < endPlayerInv - 9 ? !this.m_38903_(slotStack, endPlayerInv - 9, endPlayerInv, false) : index >= endPlayerInv - 9 && index < endPlayerInv && !this.m_38903_(slotStack, startPlayerInv, endPlayerInv - 9, false)) : !this.m_38903_(slotStack, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == slotStackCopy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return slotStackCopy;
    }

    public int getCookProgressionScaled() {
        int i = this.cookingPotData.m_6413_(0);
        int j = this.cookingPotData.m_6413_(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public void m_5816_(StackedContents helper) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            helper.m_36466_(this.inventory.m_8020_(i));
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 12; ++i) {
            this.inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super Container> p_38980_) {
        return p_38980_.m_5818_(this.inventory, this.level);
    }

    public int m_6636_() {
        return 13;
    }

    public int m_6635_() {
        return 3;
    }

    public int m_6656_() {
        return 4;
    }

    public int m_6653_() {
        return 12;
    }

    public RecipeBookType m_5867_() {
        return TofuRecipeBookTypes.COOKING;
    }

    public boolean m_142157_(int slot) {
        return slot < this.m_6635_() * this.m_6656_();
    }
}

