/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.item;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.capability.TofuLivingCapability;
import baguchan.tofucraft.registry.TofuEffects;
import baguchan.tofucraft.registry.TofuItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnableDishItem
extends Item {
    private final Supplier<Item> dishItem;
    private final boolean comfortable;
    private final boolean salt;

    public ReturnableDishItem(Supplier<Item> dishItem, Item.Properties p_41383_) {
        this(dishItem, p_41383_, true, false);
    }

    public ReturnableDishItem(Supplier<Item> dishItem, Item.Properties p_41383_, boolean comfortable) {
        this(dishItem, p_41383_, comfortable, false);
    }

    public ReturnableDishItem(Supplier<Item> dishItem, Item.Properties p_41383_, boolean comfortable, boolean salt) {
        super(p_41383_);
        this.dishItem = dishItem;
        this.comfortable = comfortable;
        this.salt = salt;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        TofuLivingCapability capability;
        ItemStack resultItem = super.m_5922_(itemStack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, itemStack);
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if (this.comfortable) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("farmersdelight", "comfort"));
            FoodProperties foodProperties = this.getFoodProperties(itemStack, livingEntity);
            if (foodProperties != null && effect != null) {
                livingEntity.m_7292_(new MobEffectInstance(effect, 600 * foodProperties.m_38744_()));
            }
        }
        if (this.salt && (capability = (TofuLivingCapability)livingEntity.getCapability(TofuCraftReload.TOFU_LIVING_CAPABILITY).orElse(null)) != null && itemStack.m_41614_()) {
            capability.setSaltBoost(itemStack.getFoodProperties(livingEntity).m_38744_() * 20 * 20, itemStack.getFoodProperties(livingEntity).m_38744_() * 20 * 60, livingEntity);
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_150110_().f_35937_) {
                if (itemStack.m_41619_()) {
                    resultItem = new ItemStack((ItemLike)this.dishItem.get());
                } else {
                    ItemStack itemstack = new ItemStack((ItemLike)this.dishItem.get());
                    if (!player.m_150109_().m_36054_(itemstack)) {
                        player.m_36176_(itemstack, false);
                    }
                }
            }
        }
        return resultItem;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("farmersdelight", "comfort"));
        if (effect != null) {
            p_41423_.add((Component)Component.m_237115_((String)"tofucraft.has_comfort").m_130940_(ChatFormatting.GOLD));
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Wolf wolf;
        if (target instanceof Wolf && (wolf = (Wolf)target).m_6084_() && wolf.m_21824_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Mod.EventBusSubscriber(modid="tofucraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SoyFoodEvent {
        @SubscribeEvent
        public static void onSoyFoodForWolf(PlayerInteractEvent.EntityInteract event) {
            Player player = event.getEntity();
            Entity target = event.getTarget();
            ItemStack itemStack = event.getItemStack();
            if (target instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)target;
                if (target instanceof Wolf) {
                    Wolf wolf = (Wolf)target;
                    if (entity.m_6084_() && wolf.m_21824_() && itemStack.m_150930_((Item)TofuItems.YUDOFU.get())) {
                        if (!((TofuLivingCapability)wolf.getCapability(TofuCraftReload.TOFU_LIVING_CAPABILITY).orElse((Object)new TofuLivingCapability())).isWolfEatCooldown()) {
                            entity.m_5634_(1.0f);
                            entity.m_7292_(new MobEffectInstance((MobEffect)TofuEffects.SOY_HEALTHY.get(), 3200, 1));
                            ((TofuLivingCapability)wolf.getCapability(TofuCraftReload.TOFU_LIVING_CAPABILITY).orElse((Object)new TofuLivingCapability())).setWolfEatCooldown(3200);
                            entity.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
                            if (itemStack.getCraftingRemainingItem() != ItemStack.f_41583_ && !player.m_7500_()) {
                                player.m_36356_(itemStack.getCraftingRemainingItem());
                                itemStack.m_41774_(1);
                            }
                            event.setCancellationResult(InteractionResult.SUCCESS);
                            event.setCanceled(true);
                        } else {
                            player.m_5661_((Component)Component.m_237110_((String)"tofucraft.soy_food.cannot_give_on_wolf", (Object[])new Object[]{wolf.m_7755_()}), true);
                            event.setCancellationResult(InteractionResult.FAIL);
                            event.setCanceled(true);
                        }
                    }
                }
            }
        }
    }
}

