/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.message;

import baguchan.tofucraft.blockentity.SaltFurnaceBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SaltFurnaceWaterMessage {
    public BlockPos blockPos;
    public FluidStack fluid;

    public SaltFurnaceWaterMessage(BlockPos blockPos, FluidStack fluid) {
        this.blockPos = blockPos;
        this.fluid = fluid;
    }

    public void writePacketData(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        CompoundTag fluidTag = new CompoundTag();
        if (this.fluid != null) {
            this.fluid.writeToNBT(fluidTag);
        }
        buffer.m_130079_(fluidTag);
    }

    public static SaltFurnaceWaterMessage readPacketData(FriendlyByteBuf buffer) {
        BlockPos blockPos = buffer.m_130135_();
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)buffer.m_130260_());
        return new SaltFurnaceWaterMessage(blockPos, fluid);
    }

    public static boolean handle(SaltFurnaceWaterMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                BlockEntity tileentity = Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(message.blockPos);
                if (tileentity instanceof SaltFurnaceBlockEntity) {
                    SaltFurnaceBlockEntity tileentity1 = (SaltFurnaceBlockEntity)tileentity;
                    tileentity1.waterTank.setFluid(message.fluid);
                }
            });
        }
        return true;
    }
}

