/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.mixin;

import baguchan.tofucraft.block.TofuTerrainBlock;
import baguchan.tofucraft.registry.TofuBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningBolt.class})
public abstract class LightningBoltMixin
extends Entity {
    @Shadow
    private int f_20860_;

    @Shadow
    protected abstract BlockPos m_147162_();

    public LightningBoltMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LightningBolt;gameEvent(Lnet/minecraft/world/level/gameevent/GameEvent;)V", shift=At.Shift.AFTER)})
    public void tick(CallbackInfo callbackInfo) {
        if (this.f_20860_ == 2) {
            LightningBoltMixin.makeZundaOnLightningStrike(this.m_9236_(), this.m_147162_());
        }
    }

    private static void makeZundaOnLightningStrike(Level p_147151_, BlockPos p_147152_) {
        BlockState blockstate1;
        BlockPos blockpos;
        BlockState blockstate = p_147151_.m_8055_(p_147152_);
        if (blockstate.m_60713_(Blocks.f_152587_)) {
            blockpos = p_147152_.m_121945_(((Direction)blockstate.m_61143_((Property)LightningRodBlock.f_52588_)).m_122424_());
            blockstate1 = p_147151_.m_8055_(blockpos);
        } else {
            blockpos = p_147152_;
            blockstate1 = blockstate;
        }
        if (blockstate1.m_60734_() instanceof TofuTerrainBlock) {
            p_147151_.m_46597_(blockpos, ((Block)TofuBlocks.TOFU_TERRAIN_ZUNDA.get()).m_49966_());
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_147152_.m_122032_();
            int i = p_147151_.f_46441_.m_188503_(3) + 3;
            for (int j = 0; j < i; ++j) {
                int k = p_147151_.f_46441_.m_188503_(8) + 1;
                LightningBoltMixin.randomWalkCleaningCopper(p_147151_, blockpos, blockpos$mutableblockpos, k);
            }
        }
    }

    private static void randomWalkCleaningCopper(Level p_147146_, BlockPos p_147147_, BlockPos.MutableBlockPos p_147148_, int p_147149_) {
        Optional<BlockPos> optional;
        p_147148_.m_122190_((Vec3i)p_147147_);
        for (int i = 0; i < p_147149_ && !(optional = LightningBoltMixin.randomStepZunda(p_147146_, (BlockPos)p_147148_)).isEmpty(); ++i) {
            p_147148_.m_122190_((Vec3i)optional.get());
        }
    }

    private static Optional<BlockPos> randomStepZunda(Level p_147154_, BlockPos p_147155_) {
        for (BlockPos blockpos : BlockPos.m_235650_((RandomSource)p_147154_.f_46441_, (int)10, (BlockPos)p_147155_, (int)1)) {
            BlockState blockstate = p_147154_.m_8055_(blockpos);
            if (!(blockstate.m_60734_() instanceof TofuTerrainBlock)) continue;
            if (TofuTerrainBlock.canBeGrass(blockstate, (LevelReader)p_147154_, blockpos)) {
                p_147154_.m_46597_(blockpos, ((Block)TofuBlocks.TOFU_TERRAIN_ZUNDA.get()).m_49966_());
            }
            return Optional.of(blockpos);
        }
        return Optional.empty();
    }
}

