/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.recipe;

import baguchan.tofucraft.recipe.TFCraftingCategory;
import baguchan.tofucraft.recipe.TFCraftingRecipe;
import baguchan.tofucraft.recipe.TFShapedRecipe;
import baguchan.tofucraft.registry.TofuRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;

public class TFShapelessRecipe
implements TFCraftingRecipe {
    final String group;
    final TFCraftingCategory category;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    private final int tfNeed;
    private final boolean isSimple;
    private final ResourceLocation id;

    public TFShapelessRecipe(ResourceLocation id, String group, TFCraftingCategory category, ItemStack result, NonNullList<Ingredient> ingredients, int tfNeed) {
        this.id = id;
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
        this.tfNeed = tfNeed;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TofuRecipes.RECIPE_TF_CRAFT_SHAPELESS.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public TFCraftingCategory category() {
        return this.category;
    }

    @Override
    public int getNeedTF() {
        return this.tfNeed;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.result;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_5818_(Container p_44002_, Level p_44003_) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < p_44002_.m_6643_() - 1; ++j) {
            ItemStack itemstack = p_44002_.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && (this.isSimple ? stackedcontents.m_36475_((Recipe)this, (IntList)null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<TFShapelessRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shapeless");

        public TFShapelessRecipe fromJson(ResourceLocation p_44290_, JsonObject p_44291_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44291_, (String)"group", (String)"");
            TFCraftingCategory craftingbookcategory = (TFCraftingCategory)TFCraftingCategory.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)p_44291_, (String)"category", (String)null), (Enum)TFCraftingCategory.MISC);
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)p_44291_, (String)"ingredients"));
            int tf = GsonHelper.m_13824_((JsonObject)p_44291_, (String)"tf", (int)0);
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > TFShapedRecipe.MAX_WIDTH * TFShapedRecipe.MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is " + TFShapedRecipe.MAX_WIDTH * TFShapedRecipe.MAX_HEIGHT);
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_44291_, (String)"result"));
            return new TFShapelessRecipe(p_44290_, s, craftingbookcategory, itemstack, nonnulllist, tf);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray p_44276_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_44276_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)p_44276_.get(i), (boolean)false);
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public TFShapelessRecipe fromNetwork(ResourceLocation p_44293_, FriendlyByteBuf p_44294_) {
            String s = p_44294_.m_130277_();
            TFCraftingCategory craftingbookcategory = (TFCraftingCategory)p_44294_.m_130066_(TFCraftingCategory.class);
            int i = p_44294_.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)p_44294_));
            }
            ItemStack itemstack = p_44294_.m_130267_();
            int tf = p_44294_.readInt();
            return new TFShapelessRecipe(p_44293_, s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist, tf);
        }

        public void toNetwork(FriendlyByteBuf p_44281_, TFShapelessRecipe p_44282_) {
            p_44281_.m_130070_(p_44282_.group);
            p_44281_.m_130068_((Enum)p_44282_.category);
            p_44281_.m_130130_(p_44282_.ingredients.size());
            for (Ingredient ingredient : p_44282_.ingredients) {
                ingredient.m_43923_(p_44281_);
            }
            p_44281_.m_130055_(p_44282_.result);
            p_44281_.writeInt(p_44282_.tfNeed);
        }
    }
}

