/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.recipe;

import baguchan.tofucraft.recipe.FluidIngredient;
import baguchan.tofucraft.recipe.TofuPotCategory;
import baguchan.tofucraft.recipe.TofuPotRecipe;
import baguchan.tofucraft.registry.TofuRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.Nullable;

public class TofuPotShapelessRecipe
implements TofuPotRecipe {
    final ResourceLocation id;
    final String group;
    final TofuPotCategory category;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    final FluidIngredient ingredientFluid;
    private final int cookTime;
    private final float experience;
    private final boolean isSimple;

    public TofuPotShapelessRecipe(ResourceLocation id, String group, TofuPotCategory category, ItemStack result, NonNullList<Ingredient> ingredients, FluidIngredient ingredientFluid, int cookTime, float experience) {
        this.id = id;
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
        this.ingredientFluid = ingredientFluid;
        this.cookTime = cookTime;
        this.experience = experience;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TofuRecipes.RECIPE_TOFU_POT_SHAPELESS.get();
    }

    public String m_6076_() {
        return this.group;
    }

    @Override
    public TofuPotCategory category() {
        return this.category;
    }

    @Override
    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    public FluidIngredient fluidIngredient() {
        return this.ingredientFluid;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    public ItemStack m_8043_(RegistryAccess registries) {
        return this.result;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_5818_(Container p_44002_, Level p_44003_) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < p_44002_.m_6643_() - 1; ++j) {
            ItemStack itemstack = p_44002_.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && (this.isSimple ? stackedcontents.m_36475_((Recipe)this, (IntList)null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public ItemStack m_5874_(Container input, RegistryAccess registries) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<TofuPotShapelessRecipe> {
        private static NonNullList<Ingredient> itemsFromJson(JsonArray p_44276_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_44276_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)p_44276_.get(i), (boolean)false);
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public TofuPotShapelessRecipe fromJson(ResourceLocation p_44290_, JsonObject p_44291_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44291_, (String)"group", (String)"");
            TofuPotCategory craftingbookcategory = (TofuPotCategory)TofuPotCategory.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)p_44291_, (String)"category", (String)null), (Enum)TofuPotCategory.MISC);
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)p_44291_, (String)"ingredients"));
            FluidIngredient fluid = FluidIngredient.fromJson(p_44291_.get("fluid"));
            int cookTime = GsonHelper.m_13824_((JsonObject)p_44291_, (String)"cook_time", (int)300);
            float experience = GsonHelper.m_13820_((JsonObject)p_44291_, (String)"exp", (float)0.0f);
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 12) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is 12");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_44291_, (String)"result"));
            return new TofuPotShapelessRecipe(p_44290_, s, craftingbookcategory, itemstack, nonnulllist, fluid, cookTime, experience);
        }

        @Nullable
        public TofuPotShapelessRecipe fromNetwork(ResourceLocation p_44105_, FriendlyByteBuf buffer) {
            String s = buffer.m_130277_();
            TofuPotCategory craftingbookcategory = (TofuPotCategory)buffer.m_130066_(TofuPotCategory.class);
            int i = buffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemstack = buffer.m_130267_();
            FluidIngredient fluidIngredient = FluidIngredient.fromNetwork(buffer);
            return new TofuPotShapelessRecipe(p_44105_, s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist, fluidIngredient, buffer.readInt(), buffer.readFloat());
        }

        public void toNetwork(FriendlyByteBuf buffer, TofuPotShapelessRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130068_((Enum)recipe.category);
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
            recipe.fluidIngredient().toNetwork(buffer);
            buffer.writeInt(recipe.cookTime);
            buffer.writeFloat(recipe.experience);
        }
    }
}

