/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.utils;

import baguchan.tofucraft.recipe.BitternRecipe;
import baguchan.tofucraft.recipe.HardenRecipe;
import baguchan.tofucraft.registry.TofuRecipes;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RecipeHelper {
    @Nullable
    public static ItemStack getTofu(ServerLevel serverLevel, Block block) {
        RecipeManager manager = serverLevel.m_7465_();
        if (block.m_5456_() != null) {
            Stream<Recipe> tofuRecipe = manager.m_44051_().stream().filter(recipe -> recipe.m_6671_() == TofuRecipes.RECIPETYPE_HARDER.get());
            for (Recipe recipe2 : tofuRecipe.collect(Collectors.toList())) {
                if (!(recipe2 instanceof HardenRecipe) || !((HardenRecipe)recipe2).getTofu().test(new ItemStack((ItemLike)block.m_5456_()))) continue;
                return ((HardenRecipe)recipe2).m_8043_(serverLevel.m_9598_());
            }
        }
        return null;
    }

    @Nullable
    public static ItemStack getBitternResult(ServerLevel serverLevel, Fluid fluid, ItemStack itemStack) {
        RecipeManager manager = serverLevel.m_7465_();
        if (fluid != null) {
            Stream<Recipe> tofuRecipe = manager.m_44051_().stream().filter(recipe -> {
                BitternRecipe bittern;
                return recipe instanceof BitternRecipe && (bittern = (BitternRecipe)recipe).m_6671_() == TofuRecipes.RECIPETYPE_BITTERN.get();
            });
            for (Recipe recipe2 : tofuRecipe.collect(Collectors.toList())) {
                BitternRecipe bitternRecipe;
                if (!(recipe2 instanceof BitternRecipe) || !(bitternRecipe = (BitternRecipe)recipe2).getFluid().test(new FluidStack(fluid, 1000)) || !bitternRecipe.getIngredient().test(itemStack)) continue;
                return bitternRecipe.m_8043_(serverLevel.m_9598_());
            }
        }
        return null;
    }

    public static RecipeManager getManager() {
        return RecipeHelper.getManager(null);
    }

    public static RecipeManager getManager(@Nullable RecipeManager manager) {
        return manager != null ? manager : (RecipeManager)DistExecutor.runForDist(() -> () -> Minecraft.m_91087_().f_91074_.f_108617_.m_105141_(), () -> () -> ServerLifecycleHooks.getCurrentServer().m_129894_());
    }
}

