/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.world;

import baguchan.tofucraft.block.TofuPortalBlock;
import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuDimensions;
import baguchan.tofucraft.registry.TofuPoiTypes;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class TofuLevelTeleporter
implements ITeleporter {
    protected final ServerLevel level;
    private final BlockState frame = ((Block)TofuBlocks.GRILLEDTOFU.get()).m_49966_();

    public TofuLevelTeleporter(ServerLevel level) {
        this.level = level;
    }

    public Optional<BlockUtil.FoundRectangle> getExistingPortal(BlockPos pos) {
        PoiManager poiManager = this.level.m_8904_();
        poiManager.m_27056_((LevelReader)this.level, pos, 64);
        Optional<PoiRecord> optional = poiManager.m_27166_(poiType -> poiType.m_203565_(TofuPoiTypes.TOFU_PORTAL_POI.getKey()), pos, 64, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).filter(poi -> this.level.m_8055_(poi.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_)).findFirst();
        return optional.map(poi -> {
            BlockPos blockpos = poi.m_27257_();
            this.level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.m_8055_(blockpos);
            return BlockUtil.m_124334_((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, blockPos -> this.level.m_8055_(blockPos) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> makePortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = this.level.m_6857_();
        int i = Math.min(this.level.m_151558_(), this.level.m_141937_() + this.level.m_143344_()) - 1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (BlockPos.MutableBlockPos checkPos : BlockPos.m_121935_((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int validStartHeight = Math.min(i, this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, checkPos.m_123341_(), checkPos.m_123343_()));
            if (!worldborder.m_61937_((BlockPos)checkPos) || !worldborder.m_61937_((BlockPos)checkPos.m_122175_(direction, 1))) continue;
            checkPos.m_122175_(direction.m_122424_(), 1);
            for (int l = validStartHeight; l >= this.level.m_141937_(); --l) {
                int j1;
                checkPos.m_142448_(l);
                if (!this.canPortalReplaceBlock(checkPos)) continue;
                int i1 = l;
                while (l > this.level.m_141937_() && this.canPortalReplaceBlock(checkPos.m_122173_(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                checkPos.m_142448_(l);
                if (!this.canHostFrame((BlockPos)checkPos, blockpos$mutableblockpos, direction, 0)) continue;
                double d2 = pos.m_123331_((Vec3i)checkPos);
                if (this.canHostFrame((BlockPos)checkPos, blockpos$mutableblockpos, direction, -1) && this.canHostFrame((BlockPos)checkPos, blockpos$mutableblockpos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = checkPos.m_7949_();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = checkPos.m_7949_();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            int i2 = i - 9;
            int k1 = Math.max(this.level.m_141937_() + 1, 70);
            if (i2 < k1) {
                return Optional.empty();
            }
            blockpos = new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)k1, (int)i2), pos.m_123343_()).m_7949_();
            Direction direction1 = direction.m_122427_();
            if (!worldborder.m_61937_(blockpos)) {
                return Optional.empty();
            }
            for (int i3 = -1; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < 2; ++j3) {
                    for (int k3 = -1; k3 < 3; ++k3) {
                        BlockState blockstate1 = k3 < 0 ? this.frame : Blocks.f_50016_.m_49966_();
                        blockpos$mutableblockpos.m_122154_((Vec3i)blockpos, j3 * direction.m_122429_() + i3 * direction1.m_122429_(), k3, j3 * direction.m_122431_() + i3 * direction1.m_122431_());
                        this.level.m_46597_((BlockPos)blockpos$mutableblockpos, blockstate1);
                    }
                }
            }
        }
        for (int l1 = -1; l1 < 3; ++l1) {
            for (int j2 = -1; j2 < 4; ++j2) {
                if (l1 != -1 && l1 != 2 && j2 != -1 && j2 != 3) continue;
                blockpos$mutableblockpos.m_122154_(blockpos, l1 * direction.m_122429_(), j2, l1 * direction.m_122431_());
                this.level.m_7731_((BlockPos)blockpos$mutableblockpos, this.frame, 3);
            }
        }
        BlockState blockstate = (BlockState)((TofuPortalBlock)((Object)TofuBlocks.TOFU_PORTAL.get())).m_49966_().m_61124_(TofuPortalBlock.AXIS, (Comparable)axis);
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutableblockpos.m_122154_((Vec3i)blockpos, k2 * direction.m_122429_(), l2, k2 * direction.m_122431_());
                this.level.m_7731_((BlockPos)blockpos$mutableblockpos, blockstate, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.m_7949_(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos pos) {
        BlockState blockstate = this.level.m_8055_((BlockPos)pos);
        return blockstate.m_247087_() && blockstate.m_60819_().m_76178_();
    }

    private boolean canHostFrame(BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction direction, int offsetScale) {
        Direction checkDir = direction.m_122427_();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.m_122154_((Vec3i)originalPos, direction.m_122429_() * i + checkDir.m_122429_() * offsetScale, j, direction.m_122431_() * i + checkDir.m_122431_() * offsetScale);
                if (j < 0 && !this.level.m_8055_((BlockPos)offsetPos).m_280296_()) {
                    return false;
                }
                if (j < 0 || this.canPortalReplaceBlock(offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel level, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        boolean destinationIs;
        boolean bl = destinationIs = level.m_46472_() == TofuDimensions.tofu_world;
        if (entity.m_9236_().m_46472_() != TofuDimensions.tofu_world && !destinationIs) {
            return null;
        }
        WorldBorder border = level.m_6857_();
        double coordinateDifference = DimensionType.m_63908_((DimensionType)entity.m_9236_().m_6042_(), (DimensionType)level.m_6042_());
        BlockPos pos = border.m_187569_(entity.m_20185_() * coordinateDifference, entity.m_20186_(), entity.m_20189_() * coordinateDifference);
        return this.getOrMakePortal(entity, pos).map(result -> {
            Vec3 vector3d;
            Direction.Axis axis;
            BlockState blockstate = entity.m_9236_().m_8055_(entity.f_19819_);
            if (blockstate.m_61138_((Property)BlockStateProperties.f_61364_)) {
                axis = (Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle rectangle = BlockUtil.m_124334_((BlockPos)entity.f_19819_, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, blockPos -> entity.m_9236_().m_8055_(blockPos) == blockstate);
                vector3d = PortalShape.m_77738_((BlockUtil.FoundRectangle)rectangle, (Direction.Axis)axis, (Vec3)entity.m_20182_(), (EntityDimensions)entity.m_6972_(entity.m_20089_()));
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_257966_((ServerLevel)level, (BlockUtil.FoundRectangle)result, (Direction.Axis)axis, (Vec3)vector3d, (Entity)entity, (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        }).orElse(null);
    }

    protected Optional<BlockUtil.FoundRectangle> getOrMakePortal(Entity entity, BlockPos pos) {
        Optional<BlockUtil.FoundRectangle> existingPortal = this.getExistingPortal(pos);
        if (existingPortal.isPresent()) {
            return existingPortal;
        }
        Direction.Axis portalAxis = this.level.m_8055_(entity.f_19819_).m_61145_(TofuPortalBlock.AXIS).orElse(Direction.Axis.X);
        return this.makePortal(pos, portalAxis);
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
        return false;
    }
}

