/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.world.gen.features;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.world.gen.foliage.MushroomFoliagePlacer;
import baguchan.tofucraft.world.gen.foliage.TofuFoliagePlacer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class ModTreeFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> TOFU_TREE = ModTreeFeatures.registerKey("tofu_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TOFU_TREE_BIG = ModTreeFeatures.registerKey("tofu_tree_big");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZUNDA_MUSHROOM = ModTreeFeatures.registerKey("zunda_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZUNDA_MUSHROOM_BIG = ModTreeFeatures.registerKey("zunda_mushroom_big");
    public static final ResourceKey<ConfiguredFeature<?, ?>> APRICOT_TREE = ModTreeFeatures.registerKey("apricot_tree");

    private static TreeConfiguration.TreeConfigurationBuilder createTofuTree() {
        return ModTreeFeatures.createStraightBlobTree((Block)TofuBlocks.ISHITOFU.get(), (Block)TofuBlocks.LEAVES_TOFU.get(), 4, 2, 2).m_68244_().m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TofuBlocks.TOFU_TERRAIN.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createTofuTreeBig() {
        return ModTreeFeatures.createStraightBlobTree((Block)TofuBlocks.ISHITOFU.get(), (Block)TofuBlocks.LEAVES_TOFU.get(), 5, 3, 3).m_68244_().m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TofuBlocks.TOFU_TERRAIN.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createZunda() {
        return ModTreeFeatures.createMushroom((Block)TofuBlocks.TOFU_STEM.get(), (Block)TofuBlocks.ZUNDA_MUSHROOM_BLOCK.get(), 2, 1).m_68244_().m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TofuBlocks.TOFU_TERRAIN.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createZundaBig() {
        return ModTreeFeatures.createBigTrunkMushroom((Block)TofuBlocks.TOFU_STEM.get(), (Block)TofuBlocks.ZUNDA_MUSHROOM_BLOCK.get(), 8, 2).m_68244_().m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TofuBlocks.TOFU_TERRAIN.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createBigTrunkMushroom(Block trunk, Block leaves, int trunkSize, int foliageSize) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)trunk), (TrunkPlacer)new FancyTrunkPlacer(trunkSize, 4, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves), (FoliagePlacer)new MushroomFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)foliageSize), (IntProvider)ConstantInt.m_146483_((int)1), foliageSize + 1), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createMushroom(Block trunk, Block leaves, int trunkSize, int foliageSize) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)trunk), (TrunkPlacer)new StraightTrunkPlacer(trunkSize, 2, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves), (FoliagePlacer)new MushroomFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)foliageSize), (IntProvider)ConstantInt.m_146483_((int)0), foliageSize + 1), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block trunk, Block leaves, int trunkSize, int foliageSize, int twoLayerSize) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)trunk), (TrunkPlacer)new StraightTrunkPlacer(trunkSize, 2, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leaves), (FoliagePlacer)new TofuFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)foliageSize), (IntProvider)ConstantInt.m_146483_((int)0), foliageSize + 1), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createApricotTree() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TofuBlocks.LEAVES_APRICOT.get())), (FoliagePlacer)new TofuFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)TofuCraftReload.prefix(name));
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.m_254977_(context, TOFU_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)ModTreeFeatures.createTofuTree().m_68251_());
        FeatureUtils.m_254977_(context, TOFU_TREE_BIG, (Feature)Feature.f_65760_, (FeatureConfiguration)ModTreeFeatures.createTofuTreeBig().m_68251_());
        FeatureUtils.m_254977_(context, APRICOT_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)ModTreeFeatures.createApricotTree().m_68251_());
        FeatureUtils.m_254977_(context, ZUNDA_MUSHROOM, (Feature)Feature.f_65760_, (FeatureConfiguration)ModTreeFeatures.createZunda().m_68251_());
        FeatureUtils.m_254977_(context, ZUNDA_MUSHROOM_BIG, (Feature)Feature.f_65760_, (FeatureConfiguration)ModTreeFeatures.createZundaBig().m_68251_());
    }
}

