/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.render.screen;

import bagu_chan.bagus_lib.client.render.book.BaguPageButton;
import bagu_chan.bagus_lib.client.render.book.Book;
import bagu_chan.bagus_lib.client.render.book.BookAccess;
import bagu_chan.bagus_lib.client.render.book.component.BookComponentDefinition;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class BookScreen
extends Screen {
    private final Book book;
    private int pageSize;
    private int currentPage;
    private int mouseX;
    private int mouseY;
    private BaguPageButton leftButton;
    private BaguPageButton rightButton;

    public BookScreen(Book book) {
        super((Component)Component.m_237119_());
        book.removeDisabled();
        this.book = book;
        this.currentPage = -2;
    }

    protected void m_7856_() {
        this.leftButton = (BaguPageButton)this.m_142416_((GuiEventListener)new BaguPageButton(this.getBaseX(), this.getBaseY() + this.book.height(), this.book, false, true, button -> this.flipLeft()));
        this.rightButton = (BaguPageButton)this.m_142416_((GuiEventListener)new BaguPageButton(this.getBaseX() + this.book.width() - this.book.buttonWidth(), this.getBaseY() + this.book.height(), this.book, true, true, button -> this.flipRight()));
        this.pageSize = 0;
        for (BookComponentDefinition definition : this.getComponents()) {
            this.pageSize += definition.component().getPageCount(this.pageSize, this.f_96547_);
        }
        this.updateVisibility();
    }

    public void m_94757_(double d, double e) {
        super.m_94757_(d, e);
        this.mouseX = (int)d;
        this.mouseY = (int)e;
    }

    public boolean m_6375_(double x, double y, int i) {
        if (this.bookOpened()) {
            BookComponentDefinition left = this.getCurrentComponent(true);
            BookComponentDefinition right = this.getCurrentComponent(false);
            if (left != null) {
                left.component().onClick(this.createBookAccess(true), this.f_96547_, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), (int)x, (int)y);
            }
            if (right != null) {
                right.component().onClick(this.createBookAccess(false), this.f_96547_, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), (int)x, (int)y);
            }
        } else if (this.currentPage < 0) {
            if (x >= (double)((float)this.getBaseX() + (float)this.book.width() / 2.0f) && x <= (double)(this.getBaseX() + this.book.width()) && y >= (double)this.getBaseY() && y <= (double)(this.getBaseY() + this.book.height())) {
                this.setPage(0);
            }
        } else if (x >= (double)this.getBaseX() && x <= (double)((float)this.getBaseX() + (float)this.book.width() / 2.0f) && y >= (double)this.getBaseY() && y <= (double)(this.getBaseY() + this.book.height())) {
            this.setPage(this.pageSize - 1);
        }
        return super.m_6375_(x, y, i);
    }

    public void m_86600_() {
        if (this.bookOpened()) {
            BookComponentDefinition left = this.getCurrentComponent(true);
            BookComponentDefinition right = this.getCurrentComponent(false);
            if (left != null) {
                left.component().tick(this.createBookAccess(true), this.f_96547_, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
            }
            if (right != null) {
                right.component().tick(this.createBookAccess(false), this.f_96547_, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), this.mouseX, this.mouseY);
            }
        }
        this.updateVisibility();
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        if (this.bookOpened()) {
            guiGraphics.m_280163_(this.book.background(), this.getBaseX(), this.getBaseY(), 0.0f, 0.0f, this.book.width(), this.book.height(), this.book.width(), this.book.height());
            BookComponentDefinition left = this.getCurrentComponent(true);
            BookComponentDefinition right = this.getCurrentComponent(false);
            if (left != null) {
                left.component().render(this.createBookAccess(true), guiGraphics, this.f_96547_, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
            }
            if (right != null) {
                right.component().render(this.createBookAccess(false), guiGraphics, this.f_96547_, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), this.mouseX, this.mouseY);
            }
        } else if (this.currentPage < 0) {
            guiGraphics.m_280163_(this.book.cover(), this.getBaseX() + this.book.width() / 2, this.getBaseY(), 0.0f, 0.0f, this.book.width() / 2, this.book.height(), this.book.width() / 2, this.book.height());
        } else {
            guiGraphics.m_280163_(this.book.backCover(), this.getBaseX(), this.getBaseY(), 0.0f, 0.0f, this.book.width() / 2, this.book.height(), this.book.width() / 2, this.book.height());
        }
    }

    public void m_88315_(GuiGraphics p_281549_, int p_281550_, int p_282878_, float p_282465_) {
        this.m_280273_(p_281549_);
        super.m_88315_(p_281549_, p_281550_, p_282878_, p_282465_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void flipLeft() {
        this.setPage(this.currentPage - 2);
        this.updateVisibility();
    }

    public void flipRight() {
        this.setPage(this.currentPage + 2);
        this.updateVisibility();
    }

    private int getBaseX() {
        return (this.f_96543_ - this.book.width()) / 2;
    }

    private int getBaseY() {
        return (this.f_96544_ - this.book.height()) / 2;
    }

    private boolean bookOpened() {
        return this.currentPage >= 0 && this.currentPage < this.pageSize;
    }

    @Nullable
    private BookComponentDefinition getCurrentComponent(boolean left) {
        if (this.getCurrentComponentIndex(left) == -1) {
            return null;
        }
        return this.getComponents().get(this.getCurrentComponentIndex(left));
    }

    private int getCurrentComponentIndex(boolean left) {
        int pages = 0;
        for (int i = 0; i < this.getComponents().size(); ++i) {
            BookComponentDefinition definition = this.getComponents().get(i);
            if ((pages += definition.component().getPageCount(pages, this.f_96547_)) < this.currentPage + (left ? 1 : 2)) continue;
            return i;
        }
        return -1;
    }

    private BookAccess createBookAccess(final boolean left) {
        return new BookAccess(){

            @Override
            public int getRelativePage() {
                int pages = 0;
                for (int i = 0; i < this.getComponents().size(); ++i) {
                    int defCount;
                    BookComponentDefinition definition = this.getComponents().get(i);
                    if ((pages += (defCount = definition.component().getPageCount(pages, BookScreen.this.f_96547_))) < BookScreen.this.currentPage + (left ? 1 : 2)) continue;
                    return BookScreen.this.currentPage + (left ? 0 : 1) - (pages - defCount);
                }
                return 0;
            }

            @Override
            public boolean isLeftPage() {
                return left;
            }

            @Override
            public void setPage(int page) {
                BookScreen.this.setPage(page);
            }

            @Override
            public List<BookComponentDefinition> getComponents() {
                return BookScreen.this.getComponents();
            }
        };
    }

    private void setPage(int page) {
        this.currentPage = page - page % 2;
    }

    private void updateVisibility() {
        boolean visible;
        this.leftButton.f_93624_ = visible = this.bookOpened();
        this.rightButton.f_93624_ = visible;
    }

    private List<BookComponentDefinition> getComponents() {
        return this.book.components();
    }
}

