/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.entity.navigator.node;

import bagu_chan.bagus_lib.entity.ISmartJump;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SmartNodeEvaluator
extends WalkNodeEvaluator {
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();

    public void m_6802_() {
        this.collisionCache.clear();
        super.m_6802_();
    }

    @Nullable
    protected Node m_164725_(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, BlockPathTypes pathType) {
        Node node = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        double d0 = this.m_142213_((BlockPos)blockpos$mutableblockpos.m_122178_(x, y, z));
        if (d0 - nodeFloorLevel > this.m_255203_()) {
            return null;
        }
        BlockPathTypes pathtype = this.m_77567_(this.f_77313_, x, y, z);
        float f = this.f_77313_.m_21439_(pathtype);
        if (f >= 0.0f) {
            node = this.m_230619_(x, y, z, pathtype, f);
        }
        if (SmartNodeEvaluator.m_230625_(pathType) && node != null && node.f_77281_ >= 0.0f && !this.m_77624_(node)) {
            node = null;
        }
        if (!(pathtype == BlockPathTypes.WALKABLE || this.m_141974_() && pathtype == BlockPathTypes.WATER)) {
            if ((node == null || node.f_77281_ < 0.0f) && verticalDeltaLimit > 0 && (pathtype != BlockPathTypes.FENCE || this.m_255100_()) && pathtype != BlockPathTypes.UNPASSABLE_RAIL && pathtype != BlockPathTypes.TRAPDOOR && pathtype != BlockPathTypes.POWDER_SNOW) {
                for (int height = 0; height < Mth.m_14107_((double)this.m_255203_()); ++height) {
                    if (node != null) continue;
                    node = this.tryJumpOn(x, y + height, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType, blockpos$mutableblockpos);
                }
            } else if (!this.m_141974_() && pathtype == BlockPathTypes.WATER && !this.m_77361_()) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathtype == BlockPathTypes.OPEN) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (SmartNodeEvaluator.m_230625_(pathtype) && node == null) {
                node = this.getClosedNode(x, y, z, pathtype);
            }
            return node;
        }
        return node;
    }

    private Node m_230619_(int x, int y, int z, BlockPathTypes pathType, float malus) {
        Node node = this.m_5676_(x, y, z);
        node.f_77282_ = pathType;
        node.f_77281_ = Math.max(node.f_77281_, malus);
        return node;
    }

    private Node m_230627_(int x, int y, int z) {
        Node node = this.m_5676_(x, y, z);
        node.f_77282_ = BlockPathTypes.BLOCKED;
        node.f_77281_ = -1.0f;
        return node;
    }

    private Node getClosedNode(int x, int y, int z, BlockPathTypes pathType) {
        Node node = this.m_5676_(x, y, z);
        node.f_77279_ = true;
        node.f_77282_ = pathType;
        node.f_77281_ = pathType.m_77124_();
        return node;
    }

    @Nullable
    private Node tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, BlockPathTypes pathType, BlockPos.MutableBlockPos pos) {
        Node node = this.m_164725_(x, y + 1, z, verticalDeltaLimit - 1, nodeFloorLevel, direction, pathType);
        if (node == null) {
            return null;
        }
        if (this.f_77313_.m_20205_() >= 1.0f) {
            return node;
        }
        if (node.f_77282_ != BlockPathTypes.OPEN && node.f_77282_ != BlockPathTypes.WALKABLE) {
            return node;
        }
        double d0 = (double)(x - direction.m_122429_()) + 0.5;
        double d1 = (double)(z - direction.m_122431_()) + 0.5;
        double d2 = (double)this.f_77313_.m_20205_() / 2.0;
        AABB aabb = new AABB(d0 - d2, this.m_142213_((BlockPos)pos.m_122169_(d0, (double)(y + 1), d1)) + 0.001, d1 - d2, d0 + d2, (double)this.f_77313_.m_20206_() + this.m_142213_((BlockPos)pos.m_122169_((double)node.f_77271_, (double)node.f_77272_, (double)node.f_77273_)) - 0.002, d1 + d2);
        return this.m_77634_(aabb) ? null : node;
    }

    @Nullable
    private Node tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable Node node) {
        --y;
        while (y > this.f_77313_.m_9236_().m_141937_()) {
            BlockPathTypes pathtype = this.m_77567_(this.f_77313_, x, y, z);
            if (pathtype != BlockPathTypes.WATER) {
                return node;
            }
            node = this.m_230619_(x, y, z, pathtype, this.f_77313_.m_21439_(pathtype));
            --y;
        }
        return node;
    }

    private Node tryFindFirstGroundNodeBelow(int x, int y, int z) {
        for (int i = y - 1; i >= this.f_77313_.m_9236_().m_141937_(); --i) {
            if (y - i > this.f_77313_.m_6056_()) {
                return this.m_230627_(x, i, z);
            }
            BlockPathTypes pathtype = this.m_77567_(this.f_77313_, x, i, z);
            float f = this.f_77313_.m_21439_(pathtype);
            if (pathtype == BlockPathTypes.OPEN) continue;
            if (f >= 0.0f) {
                return this.m_230619_(x, i, z, pathtype, f);
            }
            return this.m_230627_(x, i, z);
        }
        return this.m_230627_(x, y, z);
    }

    private boolean m_77634_(AABB boundingBox) {
        return this.collisionCache.computeIfAbsent((Object)boundingBox, p_330163_ -> !this.f_77312_.m_45756_((Entity)this.f_77313_, boundingBox));
    }

    private double m_255203_() {
        Mob mob = this.f_77313_;
        if (mob instanceof ISmartJump) {
            ISmartJump smartJump = (ISmartJump)mob;
            return Math.max((double)smartJump.getSuppportJump(), (double)this.f_77313_.m_274421_());
        }
        return Math.max(1.125, (double)this.f_77313_.m_274421_());
    }

    private static boolean m_230625_(BlockPathTypes pathType) {
        return pathType == BlockPathTypes.FENCE || pathType == BlockPathTypes.DOOR_WOOD_CLOSED || pathType == BlockPathTypes.DOOR_IRON_CLOSED;
    }

    private boolean m_77624_(Node p_77625_) {
        AABB aabb = this.f_77313_.m_20191_();
        Vec3 vec3 = new Vec3((double)p_77625_.f_77271_ - this.f_77313_.m_20185_() + aabb.m_82362_() / 2.0, (double)p_77625_.f_77272_ - this.f_77313_.m_20186_() + aabb.m_82376_() / 2.0, (double)p_77625_.f_77273_ - this.f_77313_.m_20189_() + aabb.m_82385_() / 2.0);
        int i = Mth.m_14165_((double)(vec3.m_82553_() / aabb.m_82309_()));
        vec3 = vec3.m_82490_((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.m_77634_(aabb = aabb.m_82383_(vec3))) continue;
            return false;
        }
        return true;
    }
}

