/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.UnbakedBlockStateModel;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.MissingItemModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.dynamicresources.FabricDynamicModelHandler;
import org.jetbrains.annotations.NotNull;

public class DynamicModelProvider {
    private final LoadingCache<ResourceLocation, Optional<BlockStateModelLoader.LoadedModels>> loadedStateDefinitions = this.makeLoadingCache(this::loadBlockStateDefinition);
    private final LoadingCache<ResourceLocation, Optional<UnbakedModel>> loadedBlockModels = this.makeLoadingCache(this::loadBlockModel);
    private final LoadingCache<ModelResourceLocation, Optional<BakedModel>> loadedBakedModels = this.makeLoadingCache(this::loadBakedModel);
    private final LoadingCache<ResourceLocation, Optional<ClientItem>> loadedClientItemProperties = this.makeLoadingCache(this::loadClientItemProperties);
    private final LoadingCache<ResourceLocation, Optional<ItemModel>> loadedItemModels = this.makeLoadingCache(this::loadItemModel);
    private final LoadingCache<ResourceLocation, Optional<BakedModel>> loadedStandaloneModels = this.makeLoadingCache(this::loadStandaloneModel);
    private final BakedModel missingModel;
    private final ItemModel missingItemModel;
    private final UnbakedModel unbakedMissingModel;
    private final Function<ResourceLocation, StateDefinition<Block, BlockState>> stateMapper;
    private final ResourceManager resourceManager;
    private final ModelBakery.TextureGetter textureGetter;
    private final DynamicResolver resolver;
    private final EntityModelSet entityModelSet;
    private final ItemModelGenerator itemModelGenerator;
    private final Map<ModelResourceLocation, BakedModel> mrlModelOverrides = new ConcurrentHashMap<ModelResourceLocation, BakedModel>();
    private final Map<ResourceLocation, ItemModel> itemStackModelOverrides = new ConcurrentHashMap<ResourceLocation, ItemModel>();
    private final Map<ResourceLocation, BakedModel> standaloneModelOverrides = new ConcurrentHashMap<ResourceLocation, BakedModel>();
    private final Map<ModelResourceLocation, UnbakedBlockStateModel> unbakedBlockStateModelOverrides = new ConcurrentHashMap<ModelResourceLocation, UnbakedBlockStateModel>();
    private final List<DynamicModelPlugin> pluginList = new ArrayList<DynamicModelPlugin>();
    private static final boolean DEBUG_DYNAMIC_MODEL_LOADING = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    private static final Supplier<Set<ModelResourceLocation>> TOP_LEVEL_LOCATIONS_SUPPLIER = Suppliers.memoizeWithExpiration(() -> {
        HashSet set = new HashSet();
        BuiltInRegistries.BLOCK.entrySet().forEach(entry -> {
            ResourceLocation location = ((ResourceKey)entry.getKey()).location();
            for (BlockState state : ((Block)entry.getValue()).getStateDefinition().getPossibleStates()) {
                set.add(BlockModelShaper.stateToModelLocation((ResourceLocation)location, (BlockState)state));
            }
        });
        return Collections.unmodifiableSet(set);
    }, (long)2L, (TimeUnit)TimeUnit.MINUTES);
    public static WeakReference<DynamicModelProvider> currentReloadingModelProvider = new WeakReference<Object>(null);

    public DynamicModelProvider(ResourceManager resourceManager, EntityModelSet entityModelSet, final Map<ResourceLocation, AtlasSet.StitchResult> atlasMap) {
        this.unbakedMissingModel = MissingBlockModel.missingModel();
        this.entityModelSet = entityModelSet;
        final TextureAtlasSprite missing = atlasMap.get(TextureAtlas.LOCATION_BLOCKS).missing();
        this.textureGetter = new ModelBakery.TextureGetter(){

            public TextureAtlasSprite get(ModelDebugName modelDebugName, Material material) {
                AtlasSet.StitchResult atlas = (AtlasSet.StitchResult)atlasMap.get(material.atlasLocation());
                TextureAtlasSprite sprite = atlas.getSprite(material.texture());
                if (sprite != null) {
                    return sprite;
                }
                ModernFix.LOGGER.warn("Unable to find sprite '{}' referenced by model '{}'", (Object)material.texture(), modelDebugName.get());
                return missing;
            }

            public TextureAtlasSprite reportMissingReference(ModelDebugName modelDebugName, String string) {
                return missing;
            }
        };
        this.stateMapper = BlockStateModelLoader.definitionLocationToBlockMapper();
        this.resourceManager = resourceManager;
        this.resolver = new DynamicResolver();
        this.itemModelGenerator = new ItemModelGenerator();
        this.missingModel = this.bakeMissingModel();
        this.missingItemModel = new MissingItemModel(this.missingModel);
        try {
            Class.forName("net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin");
            this.pluginList.add(new FabricDynamicModelHandler(this, this.resourceManager));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BakedModel getMissingBakedModel() {
        return this.missingModel;
    }

    public ItemModel getMissingItemModel() {
        return this.missingItemModel;
    }

    public Map<ModelResourceLocation, BakedModel> getTopLevelEmulatedRegistry() {
        return new EmulatedRegistry<ModelResourceLocation, BakedModel>(ModelResourceLocation.class, this.loadedBakedModels, TOP_LEVEL_LOCATIONS_SUPPLIER, this.mrlModelOverrides);
    }

    public Map<ResourceLocation, BakedModel> getStandaloneEmulatedRegistry() {
        return new EmulatedRegistry<ResourceLocation, BakedModel>(ResourceLocation.class, this.loadedStandaloneModels, Set::of, this.standaloneModelOverrides);
    }

    public Map<ResourceLocation, ItemModel> getItemModelEmulatedRegistry() {
        return new EmulatedRegistry<ResourceLocation, ItemModel>(ResourceLocation.class, this.loadedItemModels, () -> ((DefaultedRegistry)BuiltInRegistries.ITEM).keySet(), this.itemStackModelOverrides);
    }

    public Map<ResourceLocation, ClientItem.Properties> getItemPropertiesEmulatedRegistry() {
        return Maps.transformValues(new EmulatedRegistry<ResourceLocation, ClientItem>(ResourceLocation.class, this.loadedClientItemProperties, () -> ((DefaultedRegistry)BuiltInRegistries.ITEM).keySet(), Map.of()), ClientItem::properties);
    }

    private <K, V> LoadingCache<K, Optional<V>> makeLoadingCache(final Function<K, Optional<V>> loadingFunction) {
        return CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build(new CacheLoader<K, Optional<V>>(this){

            public Optional<V> load(K key) {
                return (Optional)loadingFunction.apply(key);
            }
        });
    }

    private Optional<BlockStateModelLoader.LoadedModels> loadBlockStateDefinition(ResourceLocation location) {
        StateDefinition<Block, BlockState> stateDefinition = this.stateMapper.apply(location);
        if (stateDefinition == null) {
            return Optional.empty();
        }
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading blockstate definition '{}'", (Object)location);
        }
        List resources = this.resourceManager.getResourceStack(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("blockstates/" + location.getPath() + ".json")));
        ArrayList<BlockStateModelLoader.LoadedBlockModelDefinition> loadedDefinitions = new ArrayList<BlockStateModelLoader.LoadedBlockModelDefinition>(resources.size());
        for (Resource resource : resources) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject jsonObject = GsonHelper.parse((Reader)reader);
                    BlockModelDefinition blockModelDefinition = BlockModelDefinition.fromJsonElement((JsonElement)jsonObject);
                    loadedDefinitions.add(new BlockStateModelLoader.LoadedBlockModelDefinition(resource.sourcePackId(), blockModelDefinition));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                ModernFix.LOGGER.error("Failed to load blockstate definition {} from pack '{}'", (Object)location, (Object)resource.sourcePackId(), (Object)e);
            }
        }
        HashMap<ModelResourceLocation, BlockStateModelLoader.LoadedModel> loadedModels = new HashMap<ModelResourceLocation, BlockStateModelLoader.LoadedModel>(BlockStateModelLoader.loadBlockStateDefinitionStack((ResourceLocation)location, stateDefinition, loadedDefinitions, (UnbakedModel)this.unbakedMissingModel).models());
        if (!this.pluginList.isEmpty()) {
            loadedModels.replaceAll((mrl, oldModel) -> {
                UnbakedBlockStateModel ubm = oldModel.model();
                for (DynamicModelPlugin plugin : this.pluginList) {
                    ubm = plugin.modifyBlockModelOnLoad(ubm, (ModelResourceLocation)mrl, oldModel.state());
                }
                if (ubm == oldModel.model()) {
                    return oldModel;
                }
                return new BlockStateModelLoader.LoadedModel(oldModel.state(), ubm);
            });
        }
        return Optional.of(new BlockStateModelLoader.LoadedModels(loadedModels));
    }

    private BakedModel bakeMissingModel() {
        this.resolver.clearResolver();
        this.unbakedMissingModel.resolveDependencies((ResolvableModel.Resolver)this.resolver);
        DynamicBaker modelBaker = new DynamicBaker(() -> "missing");
        return UnbakedModel.bakeWithTopModelValues((UnbakedModel)this.unbakedMissingModel, (ModelBaker)modelBaker, (ModelState)BlockModelRotation.X0_Y0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BakedModel bakeModel(UnbakedModel model, ResourceLocation location) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Baking model '{}'", (Object)location);
        }
        DynamicModelProvider dynamicModelProvider = this;
        synchronized (dynamicModelProvider) {
            this.resolver.clearResolver();
            model.resolveDependencies((ResolvableModel.Resolver)this.resolver);
            DynamicBaker modelBaker = new DynamicBaker(() -> ((ResourceLocation)location).toString());
            for (DynamicModelPlugin plugin : this.pluginList) {
                model = plugin.modifyModelBeforeBake(model, location, (ModelState)BlockModelRotation.X0_Y0, modelBaker);
            }
            BakedModel bakedModel = UnbakedModel.bakeWithTopModelValues((UnbakedModel)model, (ModelBaker)modelBaker, (ModelState)BlockModelRotation.X0_Y0);
            for (DynamicModelPlugin plugin : this.pluginList) {
                bakedModel = plugin.modifyModelAfterBake(bakedModel, model, location, (ModelState)BlockModelRotation.X0_Y0, modelBaker);
            }
            return bakedModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BakedModel bakeModel(UnbakedBlockStateModel model, ModelResourceLocation mrl) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Baking model '{}'", (Object)mrl);
        }
        DynamicModelProvider dynamicModelProvider = this;
        synchronized (dynamicModelProvider) {
            this.resolver.clearResolver();
            model.resolveDependencies((ResolvableModel.Resolver)this.resolver);
            DynamicBaker modelBaker = new DynamicBaker(() -> ((ModelResourceLocation)mrl).toString());
            for (DynamicModelPlugin plugin : this.pluginList) {
                model = plugin.modifyBlockModelBeforeBake(model, mrl, modelBaker);
            }
            BakedModel bakedModel = model.bake((ModelBaker)modelBaker);
            for (DynamicModelPlugin plugin : this.pluginList) {
                bakedModel = plugin.modifyBlockModelAfterBake(bakedModel, model, mrl, modelBaker);
            }
            return bakedModel;
        }
    }

    private Optional<BakedModel> loadBakedModel(ModelResourceLocation location) {
        BakedModel override = this.mrlModelOverrides.get(location);
        if (override != null) {
            return Optional.of(override);
        }
        if (location.variant().equals("standalone") || location.variant().equals("fabric_resource")) {
            return this.loadStandaloneModel(location.id());
        }
        Optional<UnbakedBlockStateModel> unbakedModelOpt = Optional.ofNullable(this.unbakedBlockStateModelOverrides.get(location));
        if (unbakedModelOpt.isEmpty()) {
            Optional optLoadedModels = (Optional)this.loadedStateDefinitions.getUnchecked((Object)location.id());
            unbakedModelOpt = optLoadedModels.map(loadedModels -> {
                BlockStateModelLoader.LoadedModel loadedModel = (BlockStateModelLoader.LoadedModel)loadedModels.models().get(location);
                if (loadedModel != null) {
                    return loadedModel.model();
                }
                return null;
            });
        }
        return unbakedModelOpt.map(unbakedModel -> this.bakeModel((UnbakedBlockStateModel)unbakedModel, location));
    }

    private Optional<BakedModel> loadStandaloneModel(ResourceLocation location) {
        BakedModel override = this.standaloneModelOverrides.get(location);
        if (override != null) {
            return Optional.of(override);
        }
        return ((Optional)this.loadedBlockModels.getUnchecked((Object)location)).map(unbakedModel -> this.bakeModel((UnbakedModel)unbakedModel, location));
    }

    private Optional<UnbakedModel> loadBlockModelDefault(ResourceLocation location) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading block model '{}'", (Object)location);
        }
        if (location.equals((Object)ItemModelGenerator.GENERATED_ITEM_MODEL_ID)) {
            return Optional.of(this.itemModelGenerator);
        }
        if (location.equals((Object)MissingBlockModel.LOCATION)) {
            return Optional.of(this.unbakedMissingModel);
        }
        Optional resource = this.resourceManager.getResource(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("models/" + location.getPath() + ".json")));
        if (resource.isPresent()) {
            Optional<BlockModel> optional;
            block12: {
                BufferedReader reader = ((Resource)resource.get()).openAsReader();
                try {
                    BlockModel blockModel = BlockModel.fromStream((Reader)reader);
                    optional = Optional.of(blockModel);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ModernFix.LOGGER.error("Failed to load block model {} from '{}'", (Object)location, (Object)((Resource)resource.get()).sourcePackId(), (Object)e);
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }
        ModernFix.LOGGER.warn("Model '{}' does not exist in any resource packs", (Object)location);
        return Optional.empty();
    }

    private Optional<UnbakedModel> loadBlockModel(ResourceLocation location) {
        Optional<UnbakedModel> value = this.loadBlockModelDefault(location);
        for (DynamicModelPlugin plugin : this.pluginList) {
            value = plugin.modifyModelOnLoad(value, location);
        }
        return value;
    }

    private Optional<ClientItem> loadClientItemProperties(ResourceLocation location) {
        Optional resource;
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading client item '{}'", (Object)location);
        }
        if ((resource = this.resourceManager.getResource(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("items/" + location.getPath() + ".json")))).isPresent()) {
            Optional<ClientItem> optional;
            block10: {
                BufferedReader reader = ((Resource)resource.get()).openAsReader();
                try {
                    ClientItem clientItem = (ClientItem)ClientItem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow();
                    optional = Optional.of(clientItem);
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ModernFix.LOGGER.error("Failed to load client item {} from '{}'", (Object)location, (Object)((Resource)resource.get()).sourcePackId(), (Object)e);
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }
        ModernFix.LOGGER.warn("Client item '{}' does not exist in any resource packs", (Object)location);
        return Optional.empty();
    }

    private Optional<ItemModel> loadItemModel(ResourceLocation location) {
        ItemModel override;
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading item model '{}'", (Object)location);
        }
        if ((override = this.itemStackModelOverrides.get(location)) != null) {
            return Optional.of(override);
        }
        return ((Optional)this.loadedClientItemProperties.getUnchecked((Object)location)).map(clientItem -> {
            ItemModel.BakingContext bakingContext = new ItemModel.BakingContext((ModelBaker)new DynamicBaker(() -> ((ResourceLocation)location).toString()), this.entityModelSet, this.missingItemModel);
            return clientItem.model().bake(bakingContext);
        });
    }

    public BakedModel getModel(ModelResourceLocation location) {
        return ((Optional)this.loadedBakedModels.getUnchecked((Object)location)).orElse(this.missingModel);
    }

    public ClientItem.Properties getClientItemProperties(ResourceLocation location) {
        return ((Optional)this.loadedClientItemProperties.getUnchecked((Object)location)).map(ClientItem::properties).orElse(ClientItem.Properties.DEFAULT);
    }

    public ItemModel getItemModel(ResourceLocation location) {
        return ((Optional)this.loadedItemModels.getUnchecked((Object)location)).orElse(this.missingItemModel);
    }

    public BakedModel getStandaloneModel(ResourceLocation location) {
        return ((Optional)this.loadedStandaloneModels.getUnchecked((Object)location)).orElse(this.missingModel);
    }

    public void addUnbakedBlockStateOverride(ModelResourceLocation location, UnbakedBlockStateModel model) {
        this.unbakedBlockStateModelOverrides.put(location, model);
    }

    private class DynamicResolver
    implements ResolvableModel.Resolver {
        private final Set<ResourceLocation> stack = new ObjectOpenHashSet(4);
        private final Set<ResourceLocation> resolvedModels = new ObjectOpenHashSet();

        private DynamicResolver() {
        }

        public UnbakedModel resolve(ResourceLocation resourceLocation) {
            if (this.stack.contains(resourceLocation)) {
                ModernFix.LOGGER.warn("Detected model loading loop: {}->{}", (Object)this.stacktraceToString(), (Object)resourceLocation);
                return DynamicModelProvider.this.unbakedMissingModel;
            }
            UnbakedModel unbakedModel = ((Optional)DynamicModelProvider.this.loadedBlockModels.getUnchecked((Object)resourceLocation)).orElse(DynamicModelProvider.this.unbakedMissingModel);
            if (this.resolvedModels.add(resourceLocation)) {
                this.stack.add(resourceLocation);
                unbakedModel.resolveDependencies((ResolvableModel.Resolver)this);
                this.stack.remove(resourceLocation);
            }
            return unbakedModel;
        }

        private String stacktraceToString() {
            return this.stack.stream().map(ResourceLocation::toString).collect(Collectors.joining("->"));
        }

        public void clearResolver() {
            this.stack.clear();
            this.resolvedModels.clear();
        }
    }

    private static class EmulatedRegistry<K, V>
    implements Map<K, V> {
        private final LoadingCache<K, Optional<V>> realCache;
        private final Supplier<Set<K>> keys;
        private final Map<K, V> overrides;
        private final Class<K> keyClass;

        public EmulatedRegistry(Class<K> keyClass, LoadingCache<K, Optional<V>> realCache, Supplier<Set<K>> keys, Map<K, V> overrides) {
            this.keyClass = keyClass;
            this.realCache = realCache;
            this.keys = keys;
            this.overrides = overrides;
        }

        @Override
        public V get(Object key) {
            if (this.keyClass.isAssignableFrom(key.getClass())) {
                return ((Optional)this.realCache.getUnchecked(key)).orElse(null);
            }
            return null;
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            if (this.keyClass.isAssignableFrom(key.getClass())) {
                return ((Optional)this.realCache.getUnchecked(key)).orElse(defaultValue);
            }
            return defaultValue;
        }

        @Override
        public V put(K key, V value) {
            V oldValue = ((Optional)this.realCache.getUnchecked(key)).orElse(null);
            this.overrides.put(key, value);
            this.realCache.invalidate(key);
            return oldValue;
        }

        @Override
        public V remove(Object key) {
            this.overrides.remove(key);
            this.realCache.invalidate(key);
            return null;
        }

        @Override
        public void putAll(@NotNull Map<? extends K, ? extends V> m) {
            m.forEach(this::put);
        }

        @Override
        public void clear() {
            this.overrides.clear();
            this.realCache.invalidateAll();
        }

        @Override
        @NotNull
        public Set<K> keySet() {
            return this.keys.get();
        }

        @Override
        @NotNull
        public Collection<V> values() {
            return Collections.emptyList();
        }

        @Override
        public int size() {
            return this.keys.get().size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.keys.get().contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return Iterators.transform(keys.get().iterator(), key -> new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return this.get(key);
                        }

                        @Override
                        public V setValue(V value) {
                            return this.put(key, value);
                        }
                    });
                }

                @Override
                public int size() {
                    return keys.get().size();
                }
            };
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            for (K location : this.keys.get()) {
                V existing;
                V replacement;
                boolean needsReplacement;
                try {
                    needsReplacement = function.apply(location, null) != null;
                }
                catch (Throwable e) {
                    needsReplacement = true;
                }
                if (!needsReplacement || (replacement = function.apply(location, existing = this.get(location))) == existing) continue;
                this.put(location, replacement);
            }
        }
    }

    private class DynamicBaker
    implements ModelBaker {
        private final ModelDebugName modelDebugName;

        private DynamicBaker(ModelDebugName modelDebugName) {
            this.modelDebugName = modelDebugName;
        }

        public BakedModel bake(ResourceLocation location, ModelState transform) {
            return ((Optional)DynamicModelProvider.this.loadedBlockModels.getUnchecked((Object)location)).map(unbakedModel -> {
                DynamicModelProvider.this.resolver.clearResolver();
                unbakedModel.resolveDependencies((ResolvableModel.Resolver)DynamicModelProvider.this.resolver);
                return UnbakedModel.bakeWithTopModelValues((UnbakedModel)unbakedModel, (ModelBaker)this, (ModelState)transform);
            }).orElse(DynamicModelProvider.this.missingModel);
        }

        public SpriteGetter sprites() {
            return DynamicModelProvider.this.textureGetter.bind(this.modelDebugName);
        }

        public ModelDebugName rootName() {
            return this.modelDebugName;
        }
    }

    public static interface DynamicModelPlugin {
        public Optional<UnbakedModel> modifyModelOnLoad(Optional<UnbakedModel> var1, ResourceLocation var2);

        public UnbakedBlockStateModel modifyBlockModelOnLoad(UnbakedBlockStateModel var1, ModelResourceLocation var2, BlockState var3);

        public UnbakedModel modifyModelBeforeBake(UnbakedModel var1, ResourceLocation var2, ModelState var3, ModelBaker var4);

        public BakedModel modifyModelAfterBake(BakedModel var1, UnbakedModel var2, ResourceLocation var3, ModelState var4, ModelBaker var5);

        public UnbakedBlockStateModel modifyBlockModelBeforeBake(UnbakedBlockStateModel var1, ModelResourceLocation var2, ModelBaker var3);

        public BakedModel modifyBlockModelAfterBake(BakedModel var1, UnbakedBlockStateModel var2, ModelResourceLocation var3, ModelBaker var4);
    }

    public static interface ModelManagerExtension {
        public DynamicModelProvider mfix$getModelProvider();
    }
}

