/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.UnbakedBlockStateModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.dynamicresources.DynamicModelProvider;

public class FabricDynamicModelHandler
implements DynamicModelProvider.DynamicModelPlugin {
    private static final ResourceLocation[] MODEL_MODIFIER_PHASES = new ResourceLocation[]{ModelModifier.OVERRIDE_PHASE, ModelModifier.DEFAULT_PHASE, ModelModifier.WRAP_PHASE, ModelModifier.WRAP_LAST_PHASE};
    private final Event<ModelModifier.OnLoad> onLoadModifiers = EventFactory.createWithPhases(ModelModifier.OnLoad.class, modifiers -> (model, context) -> {
        for (ModelModifier.OnLoad modifier : modifiers) {
            try {
                model = modifier.modifyModelOnLoad(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify unbaked model on load", (Throwable)exception);
            }
        }
        return model;
    }, (ResourceLocation[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.OnLoadBlock> onLoadBlockModifiers = EventFactory.createWithPhases(ModelModifier.OnLoadBlock.class, modifiers -> (model, context) -> {
        for (ModelModifier.OnLoadBlock modifier : modifiers) {
            try {
                model = modifier.modifyModelOnLoad(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify unbaked block model on load", (Throwable)exception);
            }
        }
        return model;
    }, (ResourceLocation[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.BeforeBakeBlock> beforeBakeBlockModifiers = EventFactory.createWithPhases(ModelModifier.BeforeBakeBlock.class, modifiers -> (model, context) -> {
        for (ModelModifier.BeforeBakeBlock modifier : modifiers) {
            try {
                model = modifier.modifyModelBeforeBake(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify unbaked block model before bake", (Throwable)exception);
            }
        }
        return model;
    }, (ResourceLocation[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.AfterBakeBlock> afterBakeBlockModifiers = EventFactory.createWithPhases(ModelModifier.AfterBakeBlock.class, modifiers -> (model, context) -> {
        for (ModelModifier.AfterBakeBlock modifier : modifiers) {
            try {
                model = modifier.modifyModelAfterBake(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify baked block model after bake", (Throwable)exception);
            }
        }
        return model;
    }, (ResourceLocation[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.BeforeBake> beforeBakeModifiers = EventFactory.createWithPhases(ModelModifier.BeforeBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.BeforeBake modifier : modifiers) {
            try {
                model = modifier.modifyModelBeforeBake(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify unbaked model before bake", (Throwable)exception);
            }
        }
        return model;
    }, (ResourceLocation[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.AfterBake> afterBakeModifiers = EventFactory.createWithPhases(ModelModifier.AfterBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.AfterBake modifier : modifiers) {
            try {
                model = modifier.modifyModelAfterBake(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify baked model after bake", (Throwable)exception);
            }
        }
        return model;
    }, (ResourceLocation[])MODEL_MODIFIER_PHASES);

    private <T> PreparablePluginData<T> makeDataRecord(ResourceManager manager, PreparableModelLoadingPlugin.Holder<T> holder) {
        return new PreparablePluginData<T>(holder.loader().load(manager, (Executor)ModernFix.resourceReloadExecutor()), holder);
    }

    public FabricDynamicModelHandler(DynamicModelProvider provider, ResourceManager manager) {
        ArrayList pluginList = new ArrayList(ModelLoadingPlugin.getAll());
        ArrayList preparablePluginData = new ArrayList();
        for (PreparableModelLoadingPlugin.Holder holder : PreparableModelLoadingPlugin.getAll()) {
            preparablePluginData.add(this.makeDataRecord(manager, holder));
        }
        CompletableFuture.allOf((CompletableFuture[])preparablePluginData.stream().map(PreparablePluginData::data).toArray(CompletableFuture[]::new)).join();
        PluginContext context = new PluginContext(provider);
        for (ModelLoadingPlugin modelLoadingPlugin : pluginList) {
            modelLoadingPlugin.initialize((ModelLoadingPlugin.Context)context);
        }
        for (PreparablePluginData preparablePluginData2 : preparablePluginData) {
            preparablePluginData2.initialize(context);
        }
        context.fireResolvers();
    }

    @Override
    public Optional<UnbakedModel> modifyModelOnLoad(Optional<UnbakedModel> model, ResourceLocation id) {
        return Optional.ofNullable(((ModelModifier.OnLoad)this.onLoadModifiers.invoker()).modifyModelOnLoad((UnbakedModel)model.orElse(null), () -> id));
    }

    @Override
    public UnbakedBlockStateModel modifyBlockModelOnLoad(UnbakedBlockStateModel model, final ModelResourceLocation id, final BlockState state) {
        return ((ModelModifier.OnLoadBlock)this.onLoadBlockModifiers.invoker()).modifyModelOnLoad(model, new ModelModifier.OnLoadBlock.Context(){

            public ModelResourceLocation id() {
                return id;
            }

            public BlockState state() {
                return state;
            }
        });
    }

    @Override
    public UnbakedModel modifyModelBeforeBake(UnbakedModel model, final ResourceLocation id, final ModelState state, final ModelBaker baker) {
        return ((ModelModifier.BeforeBake)this.beforeBakeModifiers.invoker()).modifyModelBeforeBake(model, new ModelModifier.BeforeBake.Context(){

            public ResourceLocation id() {
                return id;
            }

            public ModelState settings() {
                return state;
            }

            public ModelBaker baker() {
                return baker;
            }
        });
    }

    @Override
    public BakedModel modifyModelAfterBake(BakedModel bakedModel, final UnbakedModel model, final ResourceLocation id, final ModelState state, final ModelBaker baker) {
        return ((ModelModifier.AfterBake)this.afterBakeModifiers.invoker()).modifyModelAfterBake(bakedModel, new ModelModifier.AfterBake.Context(){

            public ResourceLocation id() {
                return id;
            }

            public UnbakedModel sourceModel() {
                return model;
            }

            public ModelState settings() {
                return state;
            }

            public ModelBaker baker() {
                return baker;
            }
        });
    }

    @Override
    public UnbakedBlockStateModel modifyBlockModelBeforeBake(UnbakedBlockStateModel model, final ModelResourceLocation id, final ModelBaker baker) {
        return ((ModelModifier.BeforeBakeBlock)this.beforeBakeBlockModifiers.invoker()).modifyModelBeforeBake(model, new ModelModifier.BeforeBakeBlock.Context(){

            public ModelResourceLocation id() {
                return id;
            }

            public ModelBaker baker() {
                return baker;
            }
        });
    }

    @Override
    public BakedModel modifyBlockModelAfterBake(BakedModel bakedModel, final UnbakedBlockStateModel model, final ModelResourceLocation id, final ModelBaker baker) {
        return ((ModelModifier.AfterBakeBlock)this.afterBakeBlockModifiers.invoker()).modifyModelAfterBake(bakedModel, new ModelModifier.AfterBakeBlock.Context(){

            public ModelResourceLocation id() {
                return id;
            }

            public UnbakedBlockStateModel sourceModel() {
                return model;
            }

            public ModelBaker baker() {
                return baker;
            }
        });
    }

    record PreparablePluginData<T>(CompletableFuture<T> data, PreparableModelLoadingPlugin.Holder<T> plugin) {
        void initialize(ModelLoadingPlugin.Context context) {
            this.plugin.plugin().initialize(this.data.join(), context);
        }
    }

    private class PluginContext
    implements ModelLoadingPlugin.Context {
        private final DynamicModelProvider provider;
        private final Map<Block, BlockStateResolver> resolvers = new HashMap<Block, BlockStateResolver>();

        private PluginContext(DynamicModelProvider provider) {
            this.provider = provider;
        }

        public void addModels(ResourceLocation ... ids) {
        }

        public void addModels(Collection<? extends ResourceLocation> ids) {
        }

        public void registerBlockStateResolver(Block block, BlockStateResolver resolver) {
            this.resolvers.put(block, resolver);
        }

        public void fireResolvers() {
            this.resolvers.forEach((block, resolver) -> resolver.resolveBlockStates(new BlockStateResolver.Context(){
                final /* synthetic */ Block val$block;
                {
                    this.val$block = block;
                }

                public Block block() {
                    return this.val$block;
                }

                public void setModel(BlockState state, UnbakedBlockStateModel model) {
                    PluginContext.this.provider.addUnbakedBlockStateOverride(BlockModelShaper.stateToModelLocation((BlockState)state), model);
                }
            }));
        }

        public Event<ModelModifier.OnLoad> modifyModelOnLoad() {
            return FabricDynamicModelHandler.this.onLoadModifiers;
        }

        public Event<ModelModifier.OnLoadBlock> modifyBlockModelOnLoad() {
            return FabricDynamicModelHandler.this.onLoadBlockModifiers;
        }

        public Event<ModelModifier.BeforeBake> modifyModelBeforeBake() {
            return FabricDynamicModelHandler.this.beforeBakeModifiers;
        }

        public Event<ModelModifier.AfterBake> modifyModelAfterBake() {
            return FabricDynamicModelHandler.this.afterBakeModifiers;
        }

        public Event<ModelModifier.BeforeBakeBlock> modifyBlockModelBeforeBake() {
            return FabricDynamicModelHandler.this.beforeBakeBlockModifiers;
        }

        public Event<ModelModifier.AfterBakeBlock> modifyBlockModelAfterBake() {
            return FabricDynamicModelHandler.this.afterBakeBlockModifiers;
        }
    }
}

