/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class ModelBakeryHelpers {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    private static <T extends Comparable<T>, V extends T> BlockState setPropertyGeneric(BlockState state, Property<T> prop, Object o) {
        return (BlockState)state.setValue(prop, (Comparable)o);
    }

    private static <T extends Comparable<T>> T getValueHelper(Property<T> property, String value) {
        return (T)((Comparable)property.getValue(value).orElse(null));
    }

    public static ImmutableList<BlockState> getBlockStatesForMRL(StateDefinition<Block, BlockState> stateDefinition, ModelResourceLocation location) {
        if (Objects.equals(location.getVariant(), "inventory")) {
            return ImmutableList.of();
        }
        HashSet<Property> fixedProperties = new HashSet<Property>();
        BlockState fixedState = (BlockState)stateDefinition.any();
        for (String s : COMMA_SPLITTER.split((CharSequence)location.getVariant())) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            Property property = stateDefinition.getProperty(s1);
            if (property != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Object value = ModelBakeryHelpers.getValueHelper(property, s2);
                if (value == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + String.valueOf(property.getPossibleValues()));
                }
                fixedState = ModelBakeryHelpers.setPropertyGeneric(fixedState, property, value);
                fixedProperties.add(property);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        if (fixedProperties.size() == stateDefinition.getProperties().size()) {
            return ImmutableList.of((Object)fixedState);
        }
        ArrayList anyProperties = new ArrayList(stateDefinition.getProperties());
        anyProperties.removeAll(fixedProperties);
        ArrayList<BlockState> finalList = new ArrayList<BlockState>();
        finalList.add(fixedState);
        for (Property property : anyProperties) {
            ArrayList<BlockState> newPermutations = new ArrayList<BlockState>();
            for (BlockState state : finalList) {
                for (Comparable value : property.getPossibleValues()) {
                    newPermutations.add(ModelBakeryHelpers.setPropertyGeneric(state, property, value));
                }
            }
            finalList = newPermutations;
        }
        return ImmutableList.copyOf(finalList);
    }
}

