/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_6416;
import net.minecraft.server.MinecraftServer;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.packet.EntityIDSyncPacket;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.searchtree.JEIBackedSearchTree;
import org.embeddedt.modernfix.searchtree.REIBackedSearchTree;
import org.embeddedt.modernfix.searchtree.SearchTreeProviderRegistry;
import org.embeddedt.modernfix.util.ClassInfoManager;
import org.embeddedt.modernfix.world.IntegratedWatchdog;

public class ModernFixClient {
    public static ModernFixClient INSTANCE;
    public static long worldLoadStartTime;
    private static int numRenderTicks;
    public static float gameStartTimeSeconds;
    public static boolean recipesUpdated;
    public static boolean tagsUpdated;
    public String brandingString = null;
    public static List<ModernFixClientIntegration> CLIENT_INTEGRATIONS;
    public static final Set<class_2945> allEntityDatas;
    private static final Field entriesArrayField;

    public ModernFixClient() {
        INSTANCE = this;
        class_6416.method_37415();
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.branding.F3Screen")) {
            this.brandingString = ModernFix.NAME + " " + ModernFixPlatformHooks.INSTANCE.getVersionString();
        }
        SearchTreeProviderRegistry.register(JEIBackedSearchTree.PROVIDER);
        SearchTreeProviderRegistry.register(REIBackedSearchTree.PROVIDER);
        for (String className : ModernFixPlatformHooks.INSTANCE.getCustomModOptions().get((Object)"client_entrypoint")) {
            try {
                CLIENT_INTEGRATIONS.add((ModernFixClientIntegration)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                ModernFix.LOGGER.error("Could not instantiate integration {}", (Object)className, (Object)e);
            }
        }
        if (ModernFixMixinPlugin.instance.isOptionEnabled("perf.dynamic_resources.FireIntegrationHook")) {
            for (ModernFixClientIntegration integration : CLIENT_INTEGRATIONS) {
                integration.onDynamicResourcesStatusChange(true);
            }
        }
    }

    public void resetWorldLoadStateMachine() {
        numRenderTicks = 0;
        worldLoadStartTime = -1L;
        recipesUpdated = false;
        tagsUpdated = false;
    }

    public void onGameLaunchFinish() {
        if (gameStartTimeSeconds >= 0.0f) {
            return;
        }
        gameStartTimeSeconds = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.measure_time.GameLoad")) {
            ModernFix.LOGGER.warn("Game took " + gameStartTimeSeconds + " seconds to start");
        }
        ModernFixPlatformHooks.INSTANCE.onLaunchComplete();
        ClassInfoManager.clear();
    }

    public void onRecipesUpdated() {
        recipesUpdated = true;
    }

    public void onTagsUpdated() {
        tagsUpdated = true;
    }

    public void onRenderTickEnd() {
        if (recipesUpdated && tagsUpdated && worldLoadStartTime != -1L && class_310.method_1551().field_1724 != null && numRenderTicks++ >= 10) {
            float timeSpentLoading = (float)(System.nanoTime() - worldLoadStartTime) / 1.0E9f;
            if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.measure_time.WorldLoad")) {
                ModernFix.LOGGER.warn("Time from main menu to in-game was " + timeSpentLoading + " seconds");
                ModernFix.LOGGER.warn("Total time to load game and open world was " + (timeSpentLoading + gameStartTimeSeconds) + " seconds");
            }
            this.resetWorldLoadStateMachine();
        }
    }

    private static boolean compareAndSwitchIds(Class<? extends class_1297> eClass, String fieldName, class_2940<?> accessor, int newId) {
        if (accessor.field_13306 != newId) {
            ModernFix.LOGGER.warn("Corrected ID mismatch on {} field {}. Client had {} but server wants {}.", eClass, (Object)fieldName, (Object)accessor.field_13306, (Object)newId);
            accessor.field_13306 = newId;
            return true;
        }
        ModernFix.LOGGER.debug("{} {} ID fine: {}", eClass, (Object)fieldName, (Object)newId);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleEntityIDSync(EntityIDSyncPacket packet) {
        Map<Class<? extends class_1297>, List<Pair<String, Integer>>> info = packet.getFieldInfo();
        boolean fixNeeded = false;
        for (Map.Entry<Class<? extends class_1297>, List<Pair<String, Integer>>> entry : info.entrySet()) {
            Class<? extends class_1297> eClass = entry.getKey();
            for (Pair<String, Integer> field : entry.getValue()) {
                String fieldName = (String)field.getFirst();
                int newId = (Integer)field.getSecond();
                try {
                    Field f = eClass.getDeclaredField(fieldName);
                    f.setAccessible(true);
                    class_2940 accessor = (class_2940)f.get(null);
                    if (!ModernFixClient.compareAndSwitchIds(eClass, fieldName, accessor, newId)) continue;
                    fixNeeded = true;
                }
                catch (NoSuchFieldException e) {
                    ModernFix.LOGGER.warn("Couldn't find field on {}: {}", eClass, (Object)fieldName);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        }
        Set<class_2945> set = allEntityDatas;
        synchronized (set) {
            if (fixNeeded) {
                ArrayList<class_2945> dataEntries = new ArrayList<class_2945>(allEntityDatas);
                for (class_2945 manager : dataEntries) {
                    Int2ObjectOpenHashMap fixedMap = new Int2ObjectOpenHashMap();
                    ArrayList items = new ArrayList(manager.field_13331.values());
                    for (class_2945.class_2946 item : items) {
                        fixedMap.put(item.method_12797().field_13306, (Object)item);
                    }
                    manager.field_13335.writeLock().lock();
                    try {
                        manager.field_13331.replaceAll((id, parameter) -> (class_2945.class_2946)fixedMap.get(id.intValue()));
                        if (entriesArrayField == null) continue;
                        try {
                            class_2945.class_2946[] dataArray = new class_2945.class_2946[items.size()];
                            for (int i = 0; i < dataArray.length; ++i) {
                                dataArray[i] = (class_2945.class_2946)fixedMap.get(i);
                            }
                            entriesArrayField.set(manager, dataArray);
                        }
                        catch (ReflectiveOperationException e) {
                            ModernFix.LOGGER.error((Object)e);
                        }
                    }
                    finally {
                        manager.field_13335.writeLock().unlock();
                    }
                }
            }
            allEntityDatas.clear();
        }
    }

    public void onServerStarted(MinecraftServer server) {
        if (!ModernFixMixinPlugin.instance.isOptionEnabled("feature.integrated_server_watchdog.IntegratedWatchdog")) {
            return;
        }
        IntegratedWatchdog watchdog = new IntegratedWatchdog(server);
        watchdog.start();
    }

    static {
        Field field;
        worldLoadStartTime = -1L;
        gameStartTimeSeconds = -1.0f;
        tagsUpdated = false;
        CLIENT_INTEGRATIONS = new CopyOnWriteArrayList<ModernFixClientIntegration>();
        allEntityDatas = Collections.newSetFromMap(new WeakHashMap());
        try {
            field = class_2945.class.getDeclaredField("entriesArray");
            field.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            field = null;
        }
        entriesArrayField = field;
    }
}

