/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.dfood.shape.FoodShapeHandle;
import org.dfood.tag.ModTags;
import org.jetbrains.annotations.Nullable;

public class foodBlock
extends class_2248 {
    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    public static final class_2758 NUMBER_OF_FOOD = class_2758.method_11867((String)"number_of_food", (int)0, (int)12);
    private static final FoodShapeHandle foodShapeHandle = new FoodShapeHandle();
    public final int MAX_FOOD;
    @Nullable
    public CROPS crop;

    public foodBlock(class_4970.class_2251 settings, int max_food) {
        super(settings);
        this.MAX_FOOD = max_food;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)NUMBER_OF_FOOD, (Comparable)Integer.valueOf(0)));
    }

    public foodBlock(class_4970.class_2251 settings, int max_food, @Nullable CROPS crop) {
        this(settings, max_food);
        this.crop = crop;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return foodShapeHandle.getShape(state);
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042())).method_11657((class_2769)NUMBER_OF_FOOD, (Comparable)Integer.valueOf(1));
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = player.method_6058();
        class_1799 handStack = player.method_5998(hand);
        int currentCount = (Integer)state.method_11654((class_2769)NUMBER_OF_FOOD);
        class_2586 blockEntity = world.method_8321(pos);
        boolean isSameItem = this.isSame(handStack, blockEntity);
        if (world.field_9236) {
            if (isSameItem && currentCount < this.MAX_FOOD) {
                this.playSound(this.field_23162.method_10598(), world, pos, player);
            } else if (!isSameItem && currentCount > 0) {
                this.playSound(this.field_23162.method_10595(), world, pos, player);
            }
            return class_1269.field_5812;
        }
        if (isSameItem) {
            if (currentCount < this.MAX_FOOD) {
                class_2680 newState = (class_2680)state.method_11657((class_2769)NUMBER_OF_FOOD, (Comparable)Integer.valueOf(currentCount + 1));
                world.method_8652(pos, newState, 3);
                this.playSound(this.field_23162.method_10598(), world, pos, player);
                if (!player.method_68878()) {
                    handStack.method_7934(1);
                    player.method_6122(hand, handStack);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (currentCount > 0) {
            class_1799 foodItem;
            int newCount = currentCount - 1;
            class_2680 newState = (class_2680)state.method_11657((class_2769)NUMBER_OF_FOOD, (Comparable)Integer.valueOf(newCount));
            if (newCount > 0) {
                world.method_8652(pos, newState, 3);
            } else {
                world.method_22352(pos, false);
            }
            this.playSound(this.field_23162.method_10595(), world, pos, player);
            if (!player.method_68878() && !player.method_7270(foodItem = this.createStack(1, blockEntity))) {
                player.method_7328(foodItem, false);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean isSame(class_1799 stack, class_2586 blockEntity) {
        return stack.method_7909() == this.method_8389();
    }

    public class_1799 createStack(int count, @Nullable class_2586 blockEntity) {
        if (count <= 0 || count > this.MAX_FOOD) {
            throw new IllegalArgumentException("Count must be between 1 and " + this.MAX_FOOD);
        }
        return new class_1799((class_1935)this.method_8389(), count);
    }

    public void playSound(class_3414 event, class_1937 world, class_2338 pos, class_1657 player) {
        world.method_8396((class_1297)player, pos, this.field_23162.method_10598(), class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.1f + 0.9f);
    }

    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        return !state.method_26184(world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 downPos = pos.method_10074();
        return !world.method_8320(downPos).method_26164(ModTags.FOOD_PLACE);
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        int foodCount = (Integer)state.method_11654((class_2769)NUMBER_OF_FOOD);
        if (foodCount <= 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new class_1799((class_1935)this.method_8389(), foodCount));
    }

    public class_1792 method_8389() {
        if (this.crop == CROPS.POTATO) {
            return class_1802.field_8567;
        }
        if (this.crop == CROPS.CARROT) {
            return class_1802.field_8179;
        }
        return super.method_8389();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
        builder.method_11667(new class_2769[]{NUMBER_OF_FOOD});
    }

    public static enum CROPS {
        POTATO,
        CARROT;

    }
}

