/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.BlockScriptedDoorWrapper;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.blocks.BlockScripted;
import noppes.npcs.blocks.BlockScriptedDoor;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.IEntityPersistentData;
import noppes.npcs.mixin.EntityIMixin;
import noppes.npcs.shared.common.util.LRUHashMap;

public class BlockWrapper
implements IBlock {
    private static final Map<String, BlockWrapper> blockCache = new LRUHashMap<String, BlockWrapper>(400);
    protected final IWorld level;
    protected final Block block;
    protected final BlockPos pos;
    protected final BlockPosWrapper bPos;
    protected BlockEntity tile;
    protected TileNpcEntity storage;
    private final IData tempdata = new IData(){

        @Override
        public void remove(String key) {
            if (BlockWrapper.this.storage == null) {
                return;
            }
            BlockWrapper.this.storage.tempData.remove(key);
        }

        @Override
        public void put(String key, Object value) {
            if (BlockWrapper.this.storage == null) {
                return;
            }
            BlockWrapper.this.storage.tempData.put(key, value);
        }

        @Override
        public boolean has(String key) {
            if (BlockWrapper.this.storage == null) {
                return false;
            }
            return BlockWrapper.this.storage.tempData.containsKey(key);
        }

        @Override
        public Object get(String key) {
            if (BlockWrapper.this.storage == null) {
                return null;
            }
            return BlockWrapper.this.storage.tempData.get(key);
        }

        @Override
        public void clear() {
            if (BlockWrapper.this.storage == null) {
                return;
            }
            BlockWrapper.this.storage.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return BlockWrapper.this.storage.tempData.keySet().toArray(new String[BlockWrapper.this.storage.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            CompoundTag compound = this.getNBT();
            if (compound == null) {
                return;
            }
            if (value instanceof Number) {
                compound.putDouble(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.putString(key, (String)value);
            }
        }

        @Override
        public Object get(String key) {
            CompoundTag compound = this.getNBT();
            if (compound == null) {
                return null;
            }
            if (!compound.contains(key)) {
                return null;
            }
            Tag base = compound.get(key);
            if (base instanceof NumericTag) {
                return ((NumericTag)base).getAsDouble();
            }
            return base.getAsString();
        }

        @Override
        public void remove(String key) {
            CompoundTag compound = this.getNBT();
            if (compound == null) {
                return;
            }
            compound.remove(key);
        }

        @Override
        public boolean has(String key) {
            CompoundTag compound = this.getNBT();
            if (compound == null) {
                return false;
            }
            return compound.contains(key);
        }

        @Override
        public void clear() {
            if (BlockWrapper.this.tile == null) {
                return;
            }
            ((IEntityPersistentData)BlockWrapper.this.tile).getPersistentData().put("CustomNPCsData", (Tag)new CompoundTag());
        }

        private CompoundTag getNBT() {
            if (BlockWrapper.this.tile == null) {
                return null;
            }
            CompoundTag compound = ((IEntityPersistentData)BlockWrapper.this.tile).getPersistentData().getCompound("CustomNPCsData");
            if (compound.isEmpty() && !((IEntityPersistentData)BlockWrapper.this.tile).getPersistentData().contains("CustomNPCsData")) {
                ((IEntityPersistentData)BlockWrapper.this.tile).getPersistentData().put("CustomNPCsData", (Tag)compound);
            }
            return compound;
        }

        @Override
        public String[] getKeys() {
            CompoundTag compound = this.getNBT();
            if (compound == null) {
                return new String[0];
            }
            return compound.getAllKeys().toArray(new String[compound.getAllKeys().size()]);
        }
    };

    protected BlockWrapper(Level level, Block block, BlockPos pos) {
        this.level = NpcAPI.Instance().getIWorld((ServerLevel)level);
        this.block = block;
        this.pos = pos;
        this.bPos = new BlockPosWrapper(pos);
        this.setTile(level.getBlockEntity(pos));
    }

    @Override
    public int getX() {
        return this.pos.getX();
    }

    @Override
    public int getY() {
        return this.pos.getY();
    }

    @Override
    public int getZ() {
        return this.pos.getZ();
    }

    @Override
    public IPos getPos() {
        return this.bPos;
    }

    @Override
    public Object getProperty(String name) {
        BlockState state = this.getMCBlockState();
        for (Property p : state.getProperties()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return state.getValue(p);
        }
        throw new CustomNPCsException("Unknown property: " + name, new Object[0]);
    }

    @Override
    public void setProperty(String name, Object val) {
        if (!(val instanceof Comparable)) {
            throw new CustomNPCsException("Not a valid property value: " + String.valueOf(val), new Object[0]);
        }
        BlockState state = this.getMCBlockState();
        for (Property p : state.getProperties()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            this.setPropertyValue(state, p, (Comparable)val);
            return;
        }
        throw new CustomNPCsException("Unknown property: " + name, new Object[0]);
    }

    private <T extends Comparable<T>> void setPropertyValue(BlockState state, Property<T> p, Comparable<?> c) {
        this.level.getMCLevel().setBlock(this.pos, (BlockState)state.setValue(p, (Comparable)p.getValueClass().cast(c)), 3);
    }

    @Override
    public String[] getProperties() {
        Collection props = this.getMCBlockState().getProperties();
        ArrayList<String> list = new ArrayList<String>();
        for (Property prop : props) {
            list.add(prop.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void remove() {
        this.level.getMCLevel().removeBlock(this.pos, false);
    }

    @Override
    public boolean isRemoved() {
        BlockState state = this.level.getMCLevel().getBlockState(this.pos);
        if (state == null) {
            return true;
        }
        return state.getBlock() != this.block;
    }

    @Override
    public boolean isAir() {
        return this.level.getMCLevel().getBlockState(this.pos).isAir();
    }

    @Override
    public BlockWrapper setBlock(String name) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)name));
        if (block == null) {
            return this;
        }
        this.level.getMCLevel().setBlock(this.pos, block.defaultBlockState(), 2);
        return new BlockWrapper((Level)this.level.getMCLevel(), block, this.pos);
    }

    @Override
    public BlockWrapper setBlock(IBlock block) {
        this.level.getMCLevel().setBlock(this.pos, block.getMCBlock().defaultBlockState(), 2);
        return new BlockWrapper((Level)this.level.getMCLevel(), block.getMCBlock(), this.pos);
    }

    @Override
    public boolean isContainer() {
        if (this.tile == null || !(this.tile instanceof Container)) {
            return false;
        }
        return ((Container)this.tile).getContainerSize() > 0;
    }

    @Override
    public IContainer getContainer() {
        if (!this.isContainer()) {
            throw new CustomNPCsException("This block is not a container", new Object[0]);
        }
        return NpcAPI.Instance().getIContainer((Container)this.tile);
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public String getName() {
        return BuiltInRegistries.BLOCK.getKey((Object)this.block).toString();
    }

    @Override
    public String getDisplayName() {
        if (this.tile == null || !(this.tile instanceof Nameable)) {
            return this.getName();
        }
        return ((Nameable)this.tile).getDisplayName().getString();
    }

    @Override
    public IWorld getWorld() {
        return this.level;
    }

    @Override
    public Block getMCBlock() {
        return this.block;
    }

    @Deprecated
    public static IBlock createNew(Level level, BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        String key = state.toString() + pos.toString();
        BlockWrapper b = blockCache.get(key);
        if (b != null) {
            b.setTile(level.getBlockEntity(pos));
            return b;
        }
        b = block instanceof BlockScripted ? new BlockScriptedWrapper(level, block, pos) : (block instanceof BlockScriptedDoor ? new BlockScriptedDoorWrapper(level, block, pos) : new BlockWrapper(level, block, pos));
        blockCache.put(key, b);
        return b;
    }

    public static void clearCache() {
        blockCache.clear();
    }

    @Override
    public boolean hasTileEntity() {
        return this.tile != null;
    }

    protected void setTile(BlockEntity tile) {
        this.tile = tile;
        if (tile instanceof TileNpcEntity) {
            this.storage = (TileNpcEntity)tile;
        }
    }

    @Override
    public INbt getBlockEntityNBT() {
        CompoundTag compound = this.tile.saveWithoutMetadata((HolderLookup.Provider)this.tile.getLevel().registryAccess());
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public void setTileEntityNBT(INbt nbt) {
        this.tile.loadWithComponents(nbt.getMCNBT(), (HolderLookup.Provider)this.tile.getLevel().registryAccess());
        this.tile.setChanged();
        BlockState state = this.level.getMCLevel().getBlockState(this.pos);
        this.level.getMCLevel().sendBlockUpdated(this.pos, state, state, 3);
    }

    @Override
    public BlockEntity getMCTileEntity() {
        return this.tile;
    }

    @Override
    public BlockState getMCBlockState() {
        return this.level.getMCLevel().getBlockState(this.pos);
    }

    @Override
    public void blockEvent(int type, int data) {
        this.level.getMCLevel().blockEvent(this.pos, this.getMCBlock(), type, data);
    }

    @Override
    public void interact(int side) {
        FakePlayer player = EntityNPCInterface.GenericPlayer;
        ServerLevel w = this.level.getMCLevel();
        ((EntityIMixin)player).setLevel((Level)w);
        player.setPos((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ());
        this.getMCBlockState().useWithoutItem((Level)w, (Player)EntityNPCInterface.CommandPlayer, new BlockHitResult(Vec3.ZERO, Direction.from3DDataValue((int)side), this.pos, true));
    }
}

