/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.NpcDamageSource;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IRayTrace;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityItem;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.RayTraceWrapper;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.data.IEntityPersistentData;
import noppes.npcs.mixin.EntityIMixin;

public class EntityWrapper<T extends Entity>
implements IEntity {
    protected T entity;
    private Map<String, Object> tempData = new HashMap<String, Object>();
    private IWorld levelWrapper;
    private final IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            EntityWrapper.this.tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return EntityWrapper.this.tempData.get(key);
        }

        @Override
        public void remove(String key) {
            EntityWrapper.this.tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return EntityWrapper.this.tempData.containsKey(key);
        }

        @Override
        public void clear() {
            EntityWrapper.this.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return EntityWrapper.this.tempData.keySet().toArray(new String[EntityWrapper.this.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            CompoundTag compound = this.getStoredCompound();
            if (value instanceof Number) {
                compound.putDouble(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.putString(key, (String)value);
            }
            this.saveStoredCompound(compound);
        }

        @Override
        public Object get(String key) {
            CompoundTag compound = this.getStoredCompound();
            if (!compound.contains(key)) {
                return null;
            }
            Tag base = compound.get(key);
            if (base instanceof NumericTag) {
                return ((NumericTag)base).getAsDouble();
            }
            return base.getAsString();
        }

        @Override
        public void remove(String key) {
            CompoundTag compound = this.getStoredCompound();
            compound.remove(key);
            this.saveStoredCompound(compound);
        }

        @Override
        public boolean has(String key) {
            return this.getStoredCompound().contains(key);
        }

        @Override
        public void clear() {
            ((IEntityPersistentData)EntityWrapper.this.entity).getPersistentData().remove("CNPCStoredData");
        }

        private CompoundTag getStoredCompound() {
            CompoundTag compound = ((IEntityPersistentData)EntityWrapper.this.entity).getPersistentData().getCompound("CNPCStoredData");
            if (compound == null) {
                compound = new CompoundTag();
                ((IEntityPersistentData)EntityWrapper.this.entity).getPersistentData().put("CNPCStoredData", (Tag)compound);
            }
            return compound;
        }

        private void saveStoredCompound(CompoundTag compound) {
            ((IEntityPersistentData)EntityWrapper.this.entity).getPersistentData().put("CNPCStoredData", (Tag)compound);
        }

        @Override
        public String[] getKeys() {
            CompoundTag compound = this.getStoredCompound();
            return compound.getAllKeys().toArray(new String[compound.getAllKeys().size()]);
        }
    };

    public EntityWrapper(T entity) {
        this.entity = entity;
        this.levelWrapper = NpcAPI.Instance().getIWorld((ServerLevel)entity.level());
    }

    @Override
    public double getX() {
        return this.entity.getX();
    }

    @Override
    public void setX(double x) {
        this.entity.setPos(x, this.entity.getY(), this.entity.getZ());
    }

    @Override
    public double getY() {
        return this.entity.getY();
    }

    @Override
    public void setY(double y) {
        this.entity.setPos(this.entity.getX(), y, this.entity.getZ());
    }

    @Override
    public double getZ() {
        return this.entity.getZ();
    }

    @Override
    public void setZ(double z) {
        this.entity.setPos(this.entity.getX(), this.entity.getY(), z);
    }

    @Override
    public int getBlockX() {
        return Mth.floor((double)this.entity.getX());
    }

    @Override
    public int getBlockY() {
        return Mth.floor((double)this.entity.getY());
    }

    @Override
    public int getBlockZ() {
        return Mth.floor((double)this.entity.getZ());
    }

    @Override
    public String getEntityName() {
        String s = this.entity.getType().getDescriptionId();
        return Language.getInstance().getOrDefault(s);
    }

    @Override
    public String getName() {
        return this.entity.getName().getString();
    }

    @Override
    public void setName(String name) {
        this.entity.setCustomName((Component)Component.literal((String)name));
    }

    @Override
    public boolean hasCustomName() {
        return this.entity.hasCustomName();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.entity.setPos(x, y, z);
    }

    @Override
    public IWorld getWorld() {
        if (this.entity.level() != this.levelWrapper.getMCLevel()) {
            this.levelWrapper = NpcAPI.Instance().getIWorld((ServerLevel)this.entity.level());
        }
        return this.levelWrapper;
    }

    @Override
    public boolean isAlive() {
        return this.entity.isAlive();
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public long getAge() {
        return ((Entity)this.entity).tickCount;
    }

    @Override
    public void damage(float amount) {
        if (this.getType() == 1 && (((IPlayer)((Object)this)).getGamemode() == 1 || ((IPlayer)((Object)this)).getGamemode() == 3)) {
            return;
        }
        this.entity.hurt(this.entity.damageSources().genericKill(), amount);
    }

    @Override
    public void damage(float damage, IEntity source) {
        if (source.getMCEntity() instanceof Player) {
            this.entity.hurt(this.entity.damageSources().playerAttack((Player)source.getMCEntity()), damage);
        } else {
            Holder.Reference damageTypeHolder = this.entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(NpcDamageSource.NPC);
            this.entity.hurt(new DamageSource((Holder)damageTypeHolder, source.getMCEntity()), damage);
        }
    }

    @Override
    public void despawn() {
        this.entity.discard();
    }

    @Override
    public void spawn() {
        if (this.levelWrapper.getMCLevel().getEntity(this.entity.getUUID()) != null) {
            throw new CustomNPCsException("Entity is already spawned", new Object[0]);
        }
        ((EntityIMixin)this.entity).removal(null);
        this.levelWrapper.getMCLevel().addFreshEntity(this.entity);
    }

    @Override
    public void kill() {
        this.entity.kill();
    }

    @Override
    public boolean inWater() {
        return this.entity.isInWater();
    }

    @Override
    public boolean inLava() {
        return this.entity.isInLava();
    }

    @Override
    public boolean inFire() {
        return this.entity.level().getBlockStates(this.entity.getBoundingBox()).anyMatch(state -> state.is(BlockTags.FIRE));
    }

    @Override
    public boolean isBurning() {
        return this.entity.isOnFire();
    }

    @Override
    public void setBurning(int ticks) {
        this.entity.setRemainingFireTicks(ticks);
    }

    @Override
    public void extinguish() {
        this.entity.clearFire();
    }

    @Override
    public String getTypeName() {
        return this.entity.getEncodeId();
    }

    @Override
    public IEntityItem dropItem(IItemStack item) {
        return (IEntityItem)NpcAPI.Instance().getIEntity((Entity)this.entity.spawnAtLocation(item.getMCItemStack(), 0.0f));
    }

    @Override
    public IEntity[] getRiders() {
        List list = this.entity.getPassengers();
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public IRayTrace rayTraceBlock(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        Vec3 vec3d = this.entity.getEyePosition(1.0f);
        Vec3 vec3d1 = this.entity.getViewVector(1.0f);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * distance, vec3d1.y * distance, vec3d1.z * distance);
        BlockHitResult result = this.entity.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, stopOnLiquid ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, this.entity));
        if (result.getType() == HitResult.Type.MISS) {
            return null;
        }
        BlockHitResult br = result;
        return new RayTraceWrapper(NpcAPI.Instance().getIBlock(this.entity.level(), br.getBlockPos()), br.getDirection().get3DDataValue());
    }

    @Override
    public IEntity[] rayTraceEntities(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        Vec3 vec3d = this.entity.getEyePosition(1.0f);
        Vec3 vec3d1 = this.entity.getViewVector(1.0f);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * distance, vec3d1.y * distance, vec3d1.z * distance);
        BlockHitResult result = this.entity.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, stopOnLiquid ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, this.entity));
        if (result.getType() != HitResult.Type.MISS) {
            vec3d2 = result.getLocation();
        }
        return this.findEntityOnPath(distance, vec3d, vec3d2);
    }

    private IEntity[] findEntityOnPath(double distance, Vec3 vec3d, Vec3 vec3d1) {
        List list = this.entity.level().getEntities(this.entity, this.entity.getBoundingBox().inflate(distance));
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        for (Entity entity1 : list) {
            AABB axisalignedbb;
            Optional optional;
            if (entity1 == this.entity || !(optional = (axisalignedbb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius())).clip(vec3d, vec3d1)).isPresent()) continue;
            result.add(NpcAPI.Instance().getIEntity(entity1));
        }
        result.sort((o1, o2) -> {
            double d2;
            double d1 = this.entity.distanceToSqr(o1.getMCEntity());
            if (d1 == (d2 = this.entity.distanceToSqr(o2.getMCEntity()))) {
                return 0;
            }
            return d1 > d2 ? 1 : -1;
        });
        return result.toArray(new IEntity[result.size()]);
    }

    @Override
    public IEntity[] getAllRiders() {
        ImmutableList list = ImmutableList.copyOf((Iterable)this.entity.getIndirectPassengers());
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public void addRider(IEntity entity) {
        if (entity != null) {
            entity.getMCEntity().startRiding(this.entity, true);
        }
    }

    @Override
    public void clearRiders() {
        this.entity.ejectPassengers();
    }

    @Override
    public IEntity getMount() {
        return NpcAPI.Instance().getIEntity(this.entity.getVehicle());
    }

    @Override
    public void setMount(IEntity entity) {
        if (entity == null) {
            this.entity.stopRiding();
        } else {
            this.entity.startRiding(entity.getMCEntity(), true);
        }
    }

    @Override
    public void setRotation(float rotation) {
        this.entity.setYRot(rotation);
    }

    @Override
    public float getRotation() {
        return this.entity.getYRot();
    }

    @Override
    public void setPitch(float rotation) {
        this.entity.setXRot(rotation);
    }

    @Override
    public float getPitch() {
        return this.entity.getXRot();
    }

    @Override
    public void knockback(int power, float direction) {
        float v = direction * (float)Math.PI / 180.0f;
        this.entity.push((double)(-Mth.sin((float)v) * (float)power), 0.1 + (double)((float)power * 0.04f), (double)(Mth.cos((float)v) * (float)power));
        this.entity.setDeltaMovement(this.entity.getDeltaMovement().multiply(0.6, 1.0, 0.6));
        ((Entity)this.entity).hurtMarked = true;
    }

    @Override
    public boolean isSneaking() {
        return this.entity.isCrouching();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.isSprinting();
    }

    @Override
    public T getMCEntity() {
        return this.entity;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean typeOf(int type) {
        return type == this.getType();
    }

    @Override
    public String getUUID() {
        return this.entity.getUUID().toString();
    }

    @Override
    public String generateNewUUID() {
        UUID id = UUID.randomUUID();
        this.entity.setUUID(id);
        return id.toString();
    }

    @Override
    public INbt getNbt() {
        return NpcAPI.Instance().getINbt(((IEntityPersistentData)this.entity).getPersistentData());
    }

    @Override
    public void storeAsClone(int tab, String name) {
        CompoundTag compound = new CompoundTag();
        if (!this.entity.saveAsPassenger(compound)) {
            throw new CustomNPCsException("Cannot store dead entities", new Object[0]);
        }
        ServerCloneController.Instance.addClone(compound, name, tab);
    }

    @Override
    public INbt getEntityNbt() {
        CompoundTag compound = new CompoundTag();
        this.entity.saveWithoutId(compound);
        ResourceLocation resourcelocation = EntityType.getKey((EntityType)this.entity.getType());
        if (this.getType() == 1) {
            resourcelocation = ResourceLocation.tryParse((String)"player");
        }
        if (resourcelocation != null) {
            compound.putString("id", resourcelocation.toString());
        }
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public void setEntityNbt(INbt nbt) {
        this.entity.load(nbt.getMCNBT());
    }

    @Override
    public void playAnimation(int type) {
        this.levelWrapper.getMCLevel().getChunkSource().broadcastAndSend(this.entity, (Packet)new ClientboundAnimatePacket(this.entity, type));
    }

    @Override
    public float getHeight() {
        return this.entity.getBbHeight();
    }

    @Override
    public float getEyeHeight() {
        return this.entity.getEyeHeight();
    }

    @Override
    public float getWidth() {
        return this.entity.getBbWidth();
    }

    @Override
    public IPos getPos() {
        return new BlockPosWrapper(this.entity.blockPosition());
    }

    @Override
    public void setPos(IPos pos) {
        this.entity.setPos((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
    }

    @Override
    public String[] getTags() {
        return this.entity.getTags().toArray(new String[this.entity.getTags().size()]);
    }

    @Override
    public void addTag(String tag) {
        this.entity.addTag(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.entity.getTags().contains(tag);
    }

    @Override
    public void removeTag(String tag) {
        this.entity.removeTag(tag);
    }

    @Override
    public double getMotionX() {
        return this.entity.getDeltaMovement().x;
    }

    @Override
    public double getMotionY() {
        return this.entity.getDeltaMovement().y;
    }

    @Override
    public double getMotionZ() {
        return this.entity.getDeltaMovement().z;
    }

    @Override
    public void setMotionX(double motion) {
        Vec3 mo = this.entity.getDeltaMovement();
        if (mo.x == motion) {
            return;
        }
        this.entity.setDeltaMovement(motion, mo.y, mo.z);
        ((Entity)this.entity).hurtMarked = true;
    }

    @Override
    public void setMotionY(double motion) {
        Vec3 mo = this.entity.getDeltaMovement();
        if (mo.y == motion) {
            return;
        }
        this.entity.setDeltaMovement(mo.x, motion, mo.z);
        ((Entity)this.entity).hurtMarked = true;
    }

    @Override
    public void setMotionZ(double motion) {
        Vec3 mo = this.entity.getDeltaMovement();
        if (mo.z == motion) {
            return;
        }
        this.entity.setDeltaMovement(mo.x, mo.y, motion);
        ((Entity)this.entity).hurtMarked = true;
    }
}

