/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IScoreboardTeam;

public class ScoreboardTeamWrapper
implements IScoreboardTeam {
    private PlayerTeam team;
    private Scoreboard board;

    protected ScoreboardTeamWrapper(PlayerTeam team, Scoreboard board) {
        this.team = team;
        this.board = board;
    }

    @Override
    public String getName() {
        return this.team.getName();
    }

    @Override
    public String getDisplayName() {
        return this.team.getDisplayName().getString();
    }

    @Override
    public void setDisplayName(String name) {
        if (name.length() <= 0 || name.length() > 32) {
            throw new CustomNPCsException("Score team display name must be between 1-32 characters: %s", name);
        }
        this.team.setDisplayName((Component)Component.translatable((String)name));
    }

    @Override
    public void addPlayer(String player) {
        this.board.addPlayerToTeam(player, this.team);
    }

    @Override
    public void removePlayer(String player) {
        this.board.removePlayerFromTeam(player, this.team);
    }

    @Override
    public String[] getPlayers() {
        ArrayList list = new ArrayList(this.team.getPlayers());
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void clearPlayers() {
        ArrayList list = new ArrayList(this.team.getPlayers());
        for (String player : list) {
            this.board.removePlayerFromTeam(player, this.team);
        }
    }

    @Override
    public boolean getFriendlyFire() {
        return this.team.isAllowFriendlyFire();
    }

    @Override
    public void setFriendlyFire(boolean bo) {
        this.team.setAllowFriendlyFire(bo);
    }

    @Override
    public void setColor(String color) {
        ChatFormatting enumchatformatting = ChatFormatting.getByName((String)color);
        if (enumchatformatting == null || enumchatformatting.isFormat()) {
            throw new CustomNPCsException("Not a proper color name: %s", color);
        }
        this.team.setPlayerPrefix((Component)Component.literal((String)enumchatformatting.toString()));
        this.team.setPlayerSuffix((Component)Component.literal((String)ChatFormatting.RESET.toString()));
    }

    @Override
    public String getColor() {
        Component prefix = this.team.getPlayerPrefix();
        if (prefix == null || prefix.getString().isEmpty()) {
            return null;
        }
        for (ChatFormatting format : ChatFormatting.values()) {
            if (!prefix.getString().equals(format.toString()) || format == ChatFormatting.RESET) continue;
            return format.getName();
        }
        return null;
    }

    @Override
    public void setSeeInvisibleTeamPlayers(boolean bo) {
        this.team.setSeeFriendlyInvisibles(bo);
    }

    @Override
    public boolean getSeeInvisibleTeamPlayers() {
        return this.team.canSeeFriendlyInvisibles();
    }

    @Override
    public boolean hasPlayer(String player) {
        return this.board.getPlayersTeam(player) != null;
    }
}

