/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.client.gui.player.tabs.InventoryTabFactions;
import noppes.npcs.client.gui.player.tabs.InventoryTabQuests;
import noppes.npcs.client.gui.player.tabs.InventoryTabVanilla;
import noppes.npcs.client.renderer.MarkRenderer;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketPlayerSoundPlays;
import noppes.npcs.schematics.SchematicWrapper;
import noppes.npcs.shared.common.util.LogWriter;

public class ClientEventHandler {
    private VertexBuffer cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRenderTick(PoseStack matrixStack, BlockPos rpos, BlockEntity te) {
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        LocalPlayer player = Minecraft.getInstance().player;
        if (rpos == null || rpos == BlockPos.ZERO || rpos.distSqr((Vec3i)player.blockPosition()) > 1000000.0) {
            return;
        }
        TileBuilder tile = (TileBuilder)te;
        SchematicWrapper schem = tile.getSchematic();
        if (schem == null) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(1.0f, (float)tile.yOffest, 1.0f);
        if (!TileBuilder.Compiled) {
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            try {
                for (int i = 0; i < schem.size && i < 25000; ++i) {
                    BlockState state = schem.schema.getBlockState(i);
                    if (state.getRenderShape() == RenderShape.INVISIBLE || state.getRenderShape() != RenderShape.MODEL) continue;
                    int posX = i % schem.schema.getWidth();
                    int posZ = (i - posX) / schem.schema.getWidth() % schem.schema.getLength();
                    int posY = ((i - posX) / schem.schema.getWidth() - posZ) / schem.schema.getLength();
                    BlockPos pos = schem.rotatePos(posX, posY, posZ, tile.rotation);
                    matrixStack.pushPose();
                    matrixStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                    state = schem.rotationState(state, tile.rotation);
                    try {
                        BakedModel ibakedmodel = dispatcher.getBlockModel(state);
                        BufferBuilder builder = (BufferBuilder)buffer.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)state, (boolean)false));
                        dispatcher.getModelRenderer().renderModel(matrixStack.last(), (VertexConsumer)builder, state, ibakedmodel, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        matrixStack.popPose();
                    }
                }
            }
            catch (Exception e) {
                LogWriter.error("Error preview builder block", e);
            }
        }
        if (tile.rotation % 2 == 0) {
            ClientEventHandler.drawSelectionBox(matrixStack, (MultiBufferSource)buffer, new BlockPos((int)schem.schema.getWidth(), (int)schem.schema.getHeight(), (int)schem.schema.getLength()));
        } else {
            ClientEventHandler.drawSelectionBox(matrixStack, (MultiBufferSource)buffer, new BlockPos((int)schem.schema.getLength(), (int)schem.schema.getHeight(), (int)schem.schema.getWidth()));
        }
        matrixStack.popPose();
    }

    public static void post(LivingEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        MarkData data = MarkData.get(entity);
        LocalPlayer player = Minecraft.getInstance().player;
        for (MarkData.Mark m : data.marks) {
            if (m.getType() == 0 || !m.availability.isAvailable((Player)player)) continue;
            MarkRenderer.render(entity, poseStack, buffer, packedLight, m);
            break;
        }
    }

    @SubscribeEvent
    public void playSound(PlaySoundEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.level == null || mc.getConnection() == null || event == null || event.getSound() == null) {
            return;
        }
        SoundInstance sound = event.getSound();
        Packets.sendServer(new SPacketPlayerSoundPlays(sound.getLocation().toString(), sound.getSource().getName(), sound.isLooping()));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void guiPostInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen screen2 = (InventoryScreen)screen;
            if (CustomNpcs.InventoryGuiEnabled) {
                event.addListener((GuiEventListener)new InventoryTabVanilla().init((Screen)screen2));
                event.addListener((GuiEventListener)new InventoryTabFactions().init((Screen)screen2));
                event.addListener((GuiEventListener)new InventoryTabQuests().init((Screen)screen2));
            }
        }
    }

    public static void drawSelectionBox(PoseStack matrixStack, MultiBufferSource buffer, BlockPos pos) {
        matrixStack.pushPose();
        AABB bb = new AABB(BlockPos.ZERO.getCenter(), pos.getCenter());
        matrixStack.translate(0.001f, 0.001f, 0.001f);
        LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (AABB)bb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        matrixStack.popPose();
    }
}

