/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import noppes.npcs.client.layer.LayerInterface;

public class LayerNpcCloak
extends LayerInterface {
    public LayerNpcCloak(LivingEntityRenderer render) {
        super(render);
    }

    @Override
    public void render(PoseStack mStack, MultiBufferSource typeBuffer, int lightmapUV, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
        if (this.npc.textureCloakLocation == null) {
            if (this.npc.display.getCapeTexture() == null || this.npc.display.getCapeTexture().isEmpty() || !(this.base instanceof PlayerModel)) {
                return;
            }
            this.npc.textureCloakLocation = ResourceLocation.tryParse((String)this.npc.display.getCapeTexture());
        }
        mStack.pushPose();
        mStack.translate(0.0, 0.0, 0.125);
        double d0 = Mth.lerp((double)partialTicks, (double)this.npc.prevChasingPosX, (double)this.npc.chasingPosX) - Mth.lerp((double)partialTicks, (double)this.npc.xo, (double)this.npc.getX());
        double d1 = Mth.lerp((double)partialTicks, (double)this.npc.prevChasingPosY, (double)this.npc.chasingPosY) - Mth.lerp((double)partialTicks, (double)this.npc.yo, (double)this.npc.getY());
        double d2 = Mth.lerp((double)partialTicks, (double)this.npc.prevChasingPosZ, (double)this.npc.chasingPosZ) - Mth.lerp((double)partialTicks, (double)this.npc.zo, (double)this.npc.getZ());
        float f = this.npc.yBodyRotO + (this.npc.yBodyRot - this.npc.yBodyRotO);
        double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
        float f1 = (float)d1 * 10.0f;
        f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
        float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
        f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
        float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        f1 += Mth.sin((float)(Mth.lerp((float)partialTicks, (float)this.npc.walkDistO, (float)this.npc.walkDist) * 6.0f)) * 32.0f * partialTicks;
        if (this.npc.isCrouching()) {
            f1 += 25.0f;
        }
        mStack.mulPose(Axis.XP.rotationDegrees(6.0f + f2 / 2.0f + f1));
        mStack.mulPose(Axis.ZP.rotationDegrees(f3 / 2.0f));
        mStack.mulPose(Axis.YP.rotationDegrees(180.0f - f3 / 2.0f));
        VertexConsumer ivertexbuilder = typeBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.npc.textureCloakLocation));
        ((PlayerModel)this.base).renderCloak(mStack, ivertexbuilder, lightmapUV, OverlayTexture.NO_OVERLAY);
        mStack.popPose();
    }

    @Override
    public void rotate(PoseStack matrixStack, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

