/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.animation;

import java.util.HashMap;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import noppes.npcs.ModelData;
import noppes.npcs.client.model.animation.AniAim;
import noppes.npcs.client.model.animation.AniBlank;
import noppes.npcs.client.model.animation.AniBow;
import noppes.npcs.client.model.animation.AniCrawling;
import noppes.npcs.client.model.animation.AniDancing;
import noppes.npcs.client.model.animation.AniHug;
import noppes.npcs.client.model.animation.AniNo;
import noppes.npcs.client.model.animation.AniPoint;
import noppes.npcs.client.model.animation.AniWaving;
import noppes.npcs.client.model.animation.AniYes;
import noppes.npcs.client.model.animation.AnimationBase;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityNPCInterface;

public class AnimationHandler {
    private static final HashMap<Integer, AnimationBase> ANIMATIONS = new HashMap();

    public static void animateBipedPre(ModelData data, HumanoidModel bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityNPCInterface npc = (EntityNPCInterface)livingEntity;
        bipedModel.body.z = 0.0f;
        bipedModel.body.y = 0.0f;
        bipedModel.body.x = 0.0f;
        bipedModel.body.zRot = 0.0f;
        bipedModel.body.yRot = 0.0f;
        bipedModel.body.xRot = 0.0f;
        bipedModel.head.xRot = 0.0f;
        bipedModel.hat.xRot = 0.0f;
        bipedModel.head.zRot = 0.0f;
        bipedModel.hat.zRot = 0.0f;
        bipedModel.head.x = 0.0f;
        bipedModel.hat.x = 0.0f;
        bipedModel.head.y = 0.0f;
        bipedModel.hat.y = 0.0f;
        bipedModel.head.z = 0.0f;
        bipedModel.hat.z = 0.0f;
        bipedModel.leftLeg.xRot = 0.0f;
        bipedModel.leftLeg.yRot = 0.0f;
        bipedModel.leftLeg.zRot = 0.0f;
        bipedModel.rightLeg.xRot = 0.0f;
        bipedModel.rightLeg.yRot = 0.0f;
        bipedModel.rightLeg.zRot = 0.0f;
        bipedModel.leftArm.x = 0.0f;
        bipedModel.leftArm.y = 2.0f;
        bipedModel.leftArm.z = 0.0f;
        bipedModel.rightArm.x = 0.0f;
        bipedModel.rightArm.y = 2.0f;
        bipedModel.rightArm.z = 0.0f;
        AnimationBase animation = AnimationHandler.getAnimationFor(npc.currentAnimation);
        if (animation != null) {
            animation.animatePre(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, (Entity)livingEntity, bipedModel, npc.animationStart);
        }
    }

    public static void animateBipedPost(ModelData data, HumanoidModel bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AnimationBase animation;
        EntityNPCInterface npc = (EntityNPCInterface)livingEntity;
        if (livingEntity.isSleeping() && bipedModel.head.xRot < 0.0f) {
            bipedModel.head.xRot = 90.0f;
            bipedModel.hat.xRot = 90.0f;
        }
        if ((animation = AnimationHandler.getAnimationFor(npc.currentAnimation)) != null) {
            animation.animatePost(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, (Entity)livingEntity, bipedModel, npc.animationStart);
        }
        if (bipedModel.crouching) {
            bipedModel.body.xRot = 0.5f / data.getPartConfig((EnumParts)EnumParts.BODY).scaleY;
        }
        if (bipedModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)bipedModel;
            playerModel.leftPants.copyFrom(playerModel.leftLeg);
            playerModel.rightPants.copyFrom(playerModel.rightLeg);
            playerModel.leftSleeve.copyFrom(playerModel.leftArm);
            playerModel.rightSleeve.copyFrom(playerModel.rightArm);
            playerModel.jacket.copyFrom(playerModel.body);
        }
        bipedModel.hat.copyFrom(bipedModel.head);
    }

    public static void addAnimation(int enumAnimation, AnimationBase animationBase) {
        ANIMATIONS.put(enumAnimation, animationBase);
    }

    public static HashMap<Integer, AnimationBase> getAllAnimations() {
        return ANIMATIONS;
    }

    public static AnimationBase getAnimationFor(int animation) {
        return ANIMATIONS.get(animation);
    }

    static {
        AnimationHandler.addAnimation(0, new AniBlank());
        AnimationHandler.addAnimation(2, new AniBlank());
        AnimationHandler.addAnimation(7, new AniCrawling());
        AnimationHandler.addAnimation(3, new AniHug());
        AnimationHandler.addAnimation(5, new AniDancing());
        AnimationHandler.addAnimation(10, new AniWaving());
        AnimationHandler.addAnimation(11, new AniBow());
        AnimationHandler.addAnimation(13, new AniYes());
        AnimationHandler.addAnimation(12, new AniNo());
        AnimationHandler.addAnimation(8, new AniPoint());
        AnimationHandler.addAnimation(14, new AniBlank());
        AnimationHandler.addAnimation(6, new AniAim());
        AnimationHandler.addAnimation(9, new AnimationBase(){

            @Override
            public void animatePre(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
            }

            @Override
            public void animatePost(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
                model.head.xRot = 0.7f;
                model.hat.xRot = 0.7f;
            }
        });
        AnimationHandler.addAnimation(1, new AnimationBase(){

            @Override
            public void animatePre(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
                model.riding = true;
            }

            @Override
            public void animatePost(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
                model.riding = false;
            }
        });
        AnimationHandler.addAnimation(4, new AnimationBase(){

            @Override
            public void animatePre(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
                model.crouching = true;
            }

            @Override
            public void animatePost(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
                model.crouching = false;
            }
        });
    }
}

