/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.overlay;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.api.overlay.IRenderItemOverlay;
import noppes.npcs.client.overlay.IOverlayRenderComponent;

public class OverlayRenderItemComponent
implements IOverlayRenderComponent {
    private final int x;
    private final int y;
    private final int id;
    private final ItemStack item;

    public OverlayRenderItemComponent(IRenderItemOverlay item) {
        this.x = item.getPosX();
        this.y = item.getPosY();
        this.id = item.getId();
        this.item = item.getItem().getMCItemStack();
    }

    @Override
    public void render(GuiGraphics graphics, int linkSide) {
        graphics.pose().pushPose();
        graphics.pose().translate((double)this.x, (double)this.y, (double)this.id);
        graphics.pose().scale(1.2f, 1.2f, 1.0f);
        int width = (int)((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() / 1.2f);
        int height = (int)((float)Minecraft.getInstance().getWindow().getGuiScaledHeight() / 1.2f);
        this.renderItemOverlay(graphics, linkSide, this.item, this.x, this.y, width, height);
        graphics.pose().popPose();
    }

    public void renderItemOverlay(GuiGraphics graphics, int linkSide, ItemStack item, int x, int y, int width, int height) {
        int offsetX = width / 2 * ((linkSide - 1) % 3);
        int offsetY = height / 2 * ((linkSide - 1) / 3);
        graphics.renderItem(item, x + offsetX, y + offsetY);
        graphics.renderItemDecorations(Minecraft.getInstance().font, item, x + offsetX, y + offsetY);
    }
}

