/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import noppes.npcs.entity.EntityProjectile;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderProjectile<T extends EntityProjectile>
extends EntityRenderer<T> {
    public boolean renderWithColor = true;
    private static final ResourceLocation field_110780_a = ResourceLocation.tryParse((String)"textures/entity/projectiles/arrow.png");
    private static final ResourceLocation field_110798_h = ResourceLocation.tryParse((String)"textures/misc/enchanted_item_glint.png");
    private boolean crash = false;
    private boolean crash2 = false;

    public RenderProjectile(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(T projectile, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        Minecraft mc = Minecraft.getInstance();
        matrixStack.pushPose();
        float scale = (float)((EntityProjectile)((Object)projectile)).getSize() / 10.0f;
        ItemStack item = ((EntityProjectile)((Object)projectile)).getItemDisplay();
        matrixStack.scale(scale, scale, scale);
        if (((EntityProjectile)((Object)projectile)).isArrow()) {
            matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((EntityProjectile)((Object)projectile)).yRotO, (float)projectile.getYRot()) - 90.0f));
            matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((EntityProjectile)((Object)projectile)).xRotO, (float)projectile.getXRot())));
            float f9 = (float)((EntityProjectile)((Object)projectile)).arrowShake - partialTicks;
            if (f9 > 0.0f) {
                float f10 = -Mth.sin((float)(f9 * 3.0f)) * f9;
                matrixStack.mulPose(Axis.ZP.rotationDegrees(f10));
            }
            matrixStack.mulPose(Axis.XP.rotationDegrees(45.0f));
            matrixStack.scale(0.05625f, 0.05625f, 0.05625f);
            matrixStack.translate(-4.0, 0.0, 0.0);
            VertexConsumer ivertexbuilder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(projectile)));
            PoseStack.Pose matrixstack$entry = matrixStack.last();
            Matrix4f matrix4f = matrixstack$entry.pose();
            Matrix3f matrix3f = matrixstack$entry.normal();
            this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, packedLight);
            this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, packedLight);
            this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, packedLight);
            this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, packedLight);
            this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, packedLight);
            this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, packedLight);
            this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, packedLight);
            this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, packedLight);
            for (int j = 0; j < 4; ++j) {
                matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, packedLight);
                this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, packedLight);
                this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, packedLight);
                this.drawVertex(matrixstack$entry, matrix4f, matrix3f, ivertexbuilder, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, packedLight);
            }
        } else if (((EntityProjectile)((Object)projectile)).is3D()) {
            matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((EntityProjectile)((Object)projectile)).yRotO, (float)projectile.getYRot()) - 180.0f));
            matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)((EntityProjectile)((Object)projectile)).xRotO, (float)projectile.getXRot())));
            matrixStack.translate(0.0f, -0.125f, 0.25f);
            if (item.getItem() instanceof BlockItem && Block.byItem((Item)item.getItem()).defaultBlockState().getRenderShape() == RenderShape.ENTITYBLOCK_ANIMATED) {
                matrixStack.translate(0.0f, 0.1875f, -0.3125f);
                matrixStack.mulPose(Axis.XP.rotationDegrees(20.0f));
                matrixStack.mulPose(Axis.YP.rotationDegrees(45.0f));
                float f8 = 0.375f;
                matrixStack.scale(-f8, -f8, f8);
            }
            if (!this.crash) {
                try {
                    mc.getItemRenderer().renderStatic(item, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, packedLight, OverlayTexture.NO_OVERLAY, matrixStack, buffer, null, 0);
                }
                catch (Throwable e) {
                    this.crash = true;
                }
            } else if (!this.crash2) {
                try {
                    mc.getItemRenderer().renderStatic(item, ItemDisplayContext.NONE, packedLight, OverlayTexture.NO_OVERLAY, matrixStack, buffer, null, 0);
                }
                catch (Throwable ee) {
                    this.crash2 = true;
                }
            } else {
                mc.getItemRenderer().renderStatic(new ItemStack((ItemLike)Blocks.DIRT), ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, matrixStack, buffer, null, 0);
            }
        } else {
            matrixStack.scale(0.5f, 0.5f, 0.5f);
            matrixStack.mulPose(this.entityRenderDispatcher.camera.rotation());
            matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            mc.getItemRenderer().renderStatic(item, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, matrixStack, buffer, null, 0);
        }
        if (!((EntityProjectile)((Object)projectile)).is3D() || ((EntityProjectile)((Object)projectile)).glows()) {
            // empty if block
        }
        matrixStack.popPose();
    }

    protected ResourceLocation func_110779_a(EntityProjectile projectile) {
        return projectile.isArrow() ? field_110780_a : TextureAtlas.LOCATION_BLOCKS;
    }

    public ResourceLocation getTextureLocation(T par1Entity) {
        return ((EntityProjectile)((Object)par1Entity)).isArrow() ? field_110780_a : TextureAtlas.LOCATION_BLOCKS;
    }

    public void drawVertex(PoseStack.Pose pose, Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, int offsetX, int offsetY, int offsetZ, float textureX, float textureY, int p_229039_9_, int p_229039_10_, int p_229039_11_, int packedLightIn) {
        vertexBuilder.addVertex(matrix, (float)offsetX, (float)offsetY, (float)offsetZ).setColor(255, 255, 255, 255).setUv(textureX, textureY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(pose, (float)p_229039_9_, (float)p_229039_11_, (float)p_229039_10_);
    }
}

