/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import noppes.npcs.entity.EntityNPCInterface;

public class CmdSlay {
    static Map<String, Class<?>> slayMap = new LinkedHashMap();

    private static Map<String, Class<?>> getSlay(Level level) {
        if (!slayMap.isEmpty()) {
            return slayMap;
        }
        slayMap.put("all", LivingEntity.class);
        slayMap.put("mobs", Monster.class);
        slayMap.put("animals", Animal.class);
        slayMap.put("items", ItemEntity.class);
        slayMap.put("xporbs", ExperienceOrb.class);
        slayMap.put("npcs", EntityNPCInterface.class);
        for (EntityType ent : BuiltInRegistries.ENTITY_TYPE) {
            if (ent.getCategory() == MobCategory.MISC) continue;
            String name = ent.getDescriptionId();
            try {
                Entity e = ent.create(level);
                e.remove(Entity.RemovalReason.DISCARDED);
                Class<?> cls = e.getClass();
                if (EntityNPCInterface.class.isAssignableFrom(cls) || !LivingEntity.class.isAssignableFrom(cls)) continue;
                slayMap.put(name.toLowerCase(Locale.ROOT), cls);
            }
            catch (Throwable throwable) {}
        }
        slayMap.remove("monster");
        slayMap.remove("mob");
        return slayMap;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"slay").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"range", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            ArrayList toDelete = new ArrayList();
            boolean deleteNPCs = false;
            String delete = StringArgumentType.getString((CommandContext)context, (String)"type");
            Class<?> cls = CmdSlay.getSlay((Level)((CommandSourceStack)context.getSource()).getLevel()).get(delete);
            if (cls != null) {
                toDelete.add(cls);
            }
            if (delete.equals("mobs")) {
                toDelete.add(Ghast.class);
                toDelete.add(EnderDragon.class);
            }
            if (delete.equals("npcs")) {
                deleteNPCs = true;
            }
            int count = 0;
            int range = IntegerArgumentType.getInteger((CommandContext)context, (String)"range");
            AABB box = new AABB(((CommandSourceStack)context.getSource()).getPosition(), ((CommandSourceStack)context.getSource()).getPosition().add(1.0, 1.0, 1.0)).inflate((double)range, (double)range, (double)range);
            List list = ((CommandSourceStack)context.getSource()).getLevel().getEntitiesOfClass(LivingEntity.class, box);
            for (Entity entity : list) {
                if (entity instanceof Player || entity instanceof TamableAnimal && ((TamableAnimal)entity).isTame() || entity instanceof EntityNPCInterface && !deleteNPCs || !CmdSlay.delete(entity, toDelete)) continue;
                ++count;
            }
            if (toDelete.contains(ExperienceOrb.class)) {
                list = ((CommandSourceStack)context.getSource()).getLevel().getEntitiesOfClass(ExperienceOrb.class, box);
                for (Entity entity : list) {
                    entity.setRemoved(Entity.RemovalReason.DISCARDED);
                    ++count;
                }
            }
            if (toDelete.contains(ItemEntity.class)) {
                list = ((CommandSourceStack)context.getSource()).getLevel().getEntitiesOfClass(ItemEntity.class, box);
                for (Entity entity : list) {
                    entity.setRemoved(Entity.RemovalReason.DISCARDED);
                    ++count;
                }
            }
            int finalCount = count;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)(finalCount + " entities deleted")), false);
            return 1;
        })));
        return command;
    }

    private static boolean delete(Entity entity, ArrayList<Class<?>> toDelete) {
        for (Class<?> delete : toDelete) {
            if (delete == Animal.class && entity instanceof Horse || !delete.isAssignableFrom(entity.getClass())) continue;
            entity.setRemoved(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }
}

