/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.containers;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.CustomContainer;
import noppes.npcs.containers.ContainerNpcInterface;
import noppes.npcs.containers.SlotValid;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerMailData;

public class ContainerMail
extends ContainerNpcInterface {
    public static PlayerMail staticmail = new PlayerMail();
    public PlayerMail mail = staticmail;
    public final boolean canEdit;
    public final boolean canSend;

    public ContainerMail(int containerId, Inventory playerInventory, boolean canEdit, boolean canSend) {
        super(CustomContainer.container_mail, containerId, playerInventory);
        int j;
        int k;
        staticmail = new PlayerMail();
        this.canEdit = canEdit;
        this.canSend = canSend;
        playerInventory.startOpen(this.player);
        for (k = 0; k < 4; ++k) {
            this.addSlot(new SlotValid(this.mail, k, 179 + k * 24, 138, canEdit));
        }
        for (j = 0; j < 3; ++j) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 28 + k * 18, 175 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 28 + j * 18, 230));
        }
    }

    @Override
    public ItemStack quickMoveStack(Player par1Player, int limbSwingAmount) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(limbSwingAmount);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (limbSwingAmount < 4) {
                if (!this.moveItemStackTo(itemstack1, 4, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.canEdit || !this.moveItemStackTo(itemstack1, 0, 4, false)) {
                return null;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        if (!this.canEdit && !player.level().isClientSide) {
            PlayerMailData data = PlayerData.get((Player)player).mailData;
            for (PlayerMail mail : data.playermail) {
                if (mail.time != this.mail.time || !mail.sender.equals(this.mail.sender)) continue;
                mail.readNBT(this.mail.writeNBT());
                break;
            }
        }
    }
}

