/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import noppes.npcs.NBTTags;
import noppes.npcs.NpcMiscInventory;

public class Bank {
    public int id = -1;
    public String name = "";
    public HashMap<Integer, Integer> slotTypes = new HashMap();
    public int startSlots = 1;
    public int maxSlots = 6;
    public NpcMiscInventory currencyInventory = new NpcMiscInventory(6);
    public NpcMiscInventory upgradeInventory = new NpcMiscInventory(6);

    public Bank() {
        for (int i = 0; i < 6; ++i) {
            this.slotTypes.put(i, 0);
        }
    }

    public void addAdditionalSaveData(HolderLookup.Provider lookupProvider, CompoundTag nbttagcompound) {
        nbttagcompound.putInt("BankID", this.id);
        nbttagcompound.put("BankCurrency", (Tag)this.currencyInventory.getToNBT(lookupProvider));
        nbttagcompound.put("BankUpgrade", (Tag)this.upgradeInventory.getToNBT(lookupProvider));
        nbttagcompound.putString("Username", this.name);
        nbttagcompound.putInt("MaxSlots", this.maxSlots);
        nbttagcompound.putInt("StartSlots", this.startSlots);
        nbttagcompound.put("BankTypes", (Tag)NBTTags.nbtIntegerIntegerMap(this.slotTypes));
    }

    public void readAdditionalSaveData(HolderLookup.Provider lookupProvider, CompoundTag nbttagcompound) {
        this.id = nbttagcompound.getInt("BankID");
        this.name = nbttagcompound.getString("Username");
        this.startSlots = nbttagcompound.getInt("StartSlots");
        this.maxSlots = nbttagcompound.getInt("MaxSlots");
        this.slotTypes = NBTTags.getIntegerIntegerMap(nbttagcompound.getList("BankTypes", 10));
        this.currencyInventory.setFromNBT(lookupProvider, nbttagcompound.getCompound("BankCurrency"));
        this.upgradeInventory.setFromNBT(lookupProvider, nbttagcompound.getCompound("BankUpgrade"));
    }

    public boolean isUpgraded(int slot) {
        return this.slotTypes.get(slot) != null && this.slotTypes.get(slot) == 2;
    }

    public boolean canBeUpgraded(int slot) {
        if (this.upgradeInventory.getItem(slot) == null || this.upgradeInventory.getItem(slot).isEmpty()) {
            return false;
        }
        return this.slotTypes.get(slot) == null || this.slotTypes.get(slot) == 0;
    }

    public int getMaxSlots() {
        for (int i = 0; i < this.maxSlots; ++i) {
            if (this.currencyInventory.getItem(i) != null && !this.currencyInventory.getItem(i).isEmpty() || i <= this.startSlots - 1) continue;
            return i;
        }
        return this.maxSlots;
    }
}

