/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockData {
    public BlockPos pos;
    public BlockState state;
    public CompoundTag tile;
    private ItemStack stack;

    public BlockData(BlockPos pos, BlockState state, CompoundTag tile) {
        this.pos = pos;
        this.state = state;
        this.tile = tile;
    }

    public CompoundTag getNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putInt("BuildX", this.pos.getX());
        compound.putInt("BuildY", this.pos.getY());
        compound.putInt("BuildZ", this.pos.getZ());
        compound.putString("Block", BuiltInRegistries.BLOCK.getKey((Object)this.state.getBlock()).toString());
        if (this.tile != null) {
            compound.put("Tile", (Tag)this.tile);
        }
        return compound;
    }

    public static BlockData getData(CompoundTag compound) {
        BlockPos pos = new BlockPos(compound.getInt("BuildX"), compound.getInt("BuildY"), compound.getInt("BuildZ"));
        Block b = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)compound.getString("Block")));
        if (b == null) {
            return null;
        }
        CompoundTag tile = null;
        if (compound.contains("Tile")) {
            tile = compound.getCompound("Tile");
        }
        return new BlockData(pos, b.defaultBlockState(), tile);
    }

    public ItemStack getStack() {
        if (this.stack == null) {
            this.stack = new ItemStack((ItemLike)this.state.getBlock(), 1);
        }
        return this.stack;
    }
}

