/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import noppes.npcs.api.entity.data.IMark;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.entity.data.IEntityPersistentData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketMarkData;

public class MarkData {
    private static final String NBTKEY = "cnpcmarkdata";
    private LivingEntity entity;
    public List<Mark> marks = new ArrayList<Mark>();
    private static Map<Integer, MarkData> dataMap = new HashMap<Integer, MarkData>();

    public void setNBT(CompoundTag compound) {
        ArrayList<Mark> marks = new ArrayList<Mark>();
        ListTag list = compound.getList("marks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag c = list.getCompound(i);
            Mark m = new Mark();
            m.type = c.getInt("type");
            m.color = c.getInt("color");
            m.availability.load((HolderLookup.Provider)this.entity.registryAccess(), c.getCompound("availability"));
            marks.add(m);
        }
        this.marks = marks;
    }

    public CompoundTag getNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        for (Mark m : this.marks) {
            CompoundTag c = new CompoundTag();
            c.putInt("type", m.type);
            c.putInt("color", m.color);
            c.put("availability", (Tag)m.availability.save((HolderLookup.Provider)this.entity.registryAccess(), new CompoundTag()));
            list.add((Object)c);
        }
        compound.put("marks", (Tag)list);
        return compound;
    }

    public void save() {
        ((IEntityPersistentData)this.entity).getPersistentData().put(NBTKEY, (Tag)this.getNBT());
    }

    public IMark addMark(int type) {
        Mark m = new Mark();
        m.type = type;
        this.marks.add(m);
        if (!this.entity.level().isClientSide) {
            this.syncClients();
        }
        return m;
    }

    public IMark addMark(int type, int color) {
        Mark m = new Mark();
        m.type = type;
        m.color = color;
        this.marks.add(m);
        if (!this.entity.level().isClientSide) {
            this.syncClients();
        }
        return m;
    }

    public static MarkData get(LivingEntity entity) {
        MarkData data = dataMap.computeIfAbsent(entity.getId(), i -> new MarkData());
        if (data.entity == null) {
            data.entity = entity;
            data.setNBT(((IEntityPersistentData)entity).getPersistentData().getCompound(NBTKEY));
        }
        return data;
    }

    public void syncClients() {
        Packets.sendAll(new PacketMarkData(this.entity.getId(), this.getNBT()));
    }

    public class Mark
    implements IMark {
        public int type = 0;
        public Availability availability = new Availability();
        public int color = 16772433;

        @Override
        public IAvailability getAvailability() {
            return this.availability;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public void setColor(int color) {
            this.color = color;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public void setType(int type) {
            this.type = type;
        }

        @Override
        public void update() {
            MarkData.this.syncClients();
        }
    }
}

