/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.data.PlayerBankData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerItemGiverData;
import noppes.npcs.controllers.data.PlayerMailData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.controllers.data.PlayerSkinData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.shared.common.util.LogWriter;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.NBTJsonUtil;

public class PlayerData {
    private static Map<Integer, PlayerData> dataMap = new HashMap<Integer, PlayerData>();
    public BlockPos scriptBlockPos = BlockPos.ZERO;
    public PlayerDialogData dialogData = new PlayerDialogData();
    public PlayerBankData bankData = new PlayerBankData();
    public PlayerQuestData questData = new PlayerQuestData();
    public PlayerTransportData transportData = new PlayerTransportData();
    public PlayerFactionData factionData = new PlayerFactionData();
    public PlayerItemGiverData itemgiverData = new PlayerItemGiverData();
    public PlayerMailData mailData = new PlayerMailData();
    public PlayerSkinData skinData = new PlayerSkinData();
    public PlayerScriptData scriptData;
    public CompoundTag scriptStoreddata = new CompoundTag();
    public DataTimers timers = new DataTimers(this);
    public EntityNPCInterface editingNpc;
    public CompoundTag cloned;
    public Player player;
    public String playername = "";
    public String uuid = "";
    private EntityNPCInterface activeCompanion = null;
    public int companionID = 0;
    public int playerLevel = 0;
    public boolean updateClient = false;
    public int dialogId = -1;
    public ItemStack prevHeldItem = ItemStack.EMPTY;
    public Entity mounted;
    public UUID iAmStealingYourDatas = UUID.randomUUID();
    private static final ResourceLocation key = new ResourceLocation("customnpcs", "playerdata");

    public void setNBT(HolderLookup.Provider provider, CompoundTag data) {
        this.dialogData.loadNBTData(data);
        this.bankData.loadNBTData(provider, data);
        this.questData.loadNBTData(data);
        this.transportData.loadNBTData(data);
        this.factionData.loadNBTData(data);
        this.itemgiverData.loadNBTData(data);
        this.mailData.loadNBTData(data);
        this.skinData.loadNBTData(data);
        this.timers.load(data);
        if (this.player != null) {
            this.playername = this.player.getName().getString();
            this.uuid = this.player.getUUID().toString();
        } else {
            this.playername = data.getString("PlayerName");
            this.uuid = data.getString("UUID");
        }
        this.companionID = data.getInt("PlayerCompanionId");
        if (data.contains("PlayerCompanion") && !this.hasCompanion() && this.player != null) {
            EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, this.player.level());
            npc.readAdditionalSaveData(data.getCompound("PlayerCompanion"));
            npc.setPos(this.player.getX(), this.player.getY(), this.player.getZ());
            if (npc.role.getType() == 6) {
                ((RoleCompanion)npc.role).setSitting(false);
                this.player.level().addFreshEntity((Entity)npc);
                this.setCompanion(npc);
            }
        }
        this.scriptStoreddata = data.getCompound("ScriptStoreddata");
    }

    public CompoundTag getSyncNBT() {
        CompoundTag compound = new CompoundTag();
        this.dialogData.saveNBTData(compound);
        this.questData.saveNBTData(compound);
        this.factionData.saveNBTData(compound);
        return compound;
    }

    public CompoundTag getNBT() {
        CompoundTag nbt;
        if (this.player != null) {
            this.playername = this.player.getName().getString();
            this.uuid = this.player.getUUID().toString();
        }
        CompoundTag compound = new CompoundTag();
        this.dialogData.saveNBTData(compound);
        if (this.player != null) {
            this.bankData.saveNBTData((HolderLookup.Provider)this.player.registryAccess(), compound);
        }
        this.bankData.saveNBTData((HolderLookup.Provider)this.player.registryAccess(), compound);
        this.questData.saveNBTData(compound);
        this.transportData.saveNBTData(compound);
        this.factionData.saveNBTData(compound);
        this.itemgiverData.saveNBTData(compound);
        this.mailData.saveNBTData(compound);
        this.skinData.saveNBTData(compound);
        this.timers.save(compound);
        compound.putString("PlayerName", this.playername);
        compound.putString("UUID", this.uuid);
        compound.putInt("PlayerCompanionId", this.companionID);
        compound.put("ScriptStoreddata", (Tag)this.scriptStoreddata);
        if (this.hasCompanion() && this.activeCompanion.saveAsPassenger(nbt = new CompoundTag())) {
            compound.put("PlayerCompanion", (Tag)nbt);
        }
        return compound;
    }

    public boolean hasCompanion() {
        return this.activeCompanion != null && !this.activeCompanion.isRemoved();
    }

    public void setCompanion(EntityNPCInterface npc) {
        if (npc != null && npc.role.getType() != 6) {
            return;
        }
        ++this.companionID;
        this.activeCompanion = npc;
        if (npc != null) {
            ((RoleCompanion)npc.role).companionID = this.companionID;
        }
        this.save(false);
    }

    public void updateCompanion(Level level) {
        if (!this.hasCompanion() || level == this.activeCompanion.level()) {
            return;
        }
        RoleCompanion role = (RoleCompanion)this.activeCompanion.role;
        role.owner = this.player;
        if (!role.isFollowing()) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        this.activeCompanion.saveAsPassenger(nbt);
        this.activeCompanion.discard();
        EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, level);
        npc.readAdditionalSaveData(nbt);
        npc.setPos(this.player.getX(), this.player.getY(), this.player.getZ());
        this.setCompanion(npc);
        ((RoleCompanion)npc.role).setSitting(false);
        level.addFreshEntity((Entity)npc);
    }

    public synchronized void save(boolean update) {
        CompoundTag compound = this.getNBT();
        String filename = this.uuid + ".json";
        CustomNPCsScheduler.runTack(() -> {
            try {
                File saveDir = CustomNpcs.getLevelSaveDirectory("playerdata");
                File file = new File(saveDir, filename + "_new");
                File file1 = new File(saveDir, filename);
                NBTJsonUtil.SaveFile(file, compound);
                if (file1.exists()) {
                    file1.delete();
                }
                file.renameTo(file1);
            }
            catch (Exception e) {
                LogWriter.except(e);
            }
        });
        if (update) {
            this.updateClient = true;
        }
    }

    public static CompoundTag loadPlayerData(String player) {
        File saveDir = CustomNpcs.getLevelSaveDirectory("playerdata");
        Object filename = player;
        if (((String)filename).isEmpty()) {
            filename = "noplayername";
        }
        filename = (String)filename + ".json";
        File file = null;
        try {
            file = new File(saveDir, (String)filename);
            if (file.exists()) {
                return NBTJsonUtil.LoadFile(file);
            }
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
        }
        return new CompoundTag();
    }

    public static PlayerData get(Player player) {
        if (player.level().isClientSide) {
            return CustomNpcs.proxy.getPlayerData(player);
        }
        PlayerData data = dataMap.computeIfAbsent(player.getId(), i -> new PlayerData());
        if (data.player == null) {
            data.player = player;
            data.playerLevel = player.experienceLevel;
            data.scriptData = new PlayerScriptData(player);
            CompoundTag compound = PlayerData.loadPlayerData(player.getUUID().toString());
            data.setNBT((HolderLookup.Provider)player.registryAccess(), compound);
        }
        return data;
    }
}

