/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.IPlayerMail;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Quest;

public class PlayerMail
implements IPlayerMail,
Container {
    public String subject = "";
    public String sender = "";
    public CompoundTag message = new CompoundTag();
    public long time = 0L;
    public boolean beenRead = false;
    public int questId = -1;
    public NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    public long timePast;

    public void readNBT(CompoundTag compound) {
        this.subject = compound.getString("Subject");
        this.sender = compound.getString("Sender");
        this.time = compound.getLong("Time");
        this.beenRead = compound.getBoolean("BeenRead");
        this.message = compound.getCompound("Message");
        this.timePast = compound.getLong("TimePast");
        if (compound.contains("MailQuest")) {
            this.questId = compound.getInt("MailQuest");
        }
        this.items.clear();
        ListTag nbttaglist = compound.getList("MailItems", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag nbttagcompound1 = nbttaglist.getCompound(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j < 0 || j >= this.items.size()) continue;
            this.items.set(j, (Object)ItemStack.parseOptional((HolderLookup.Provider)NBTTags.getProvider(), (CompoundTag)nbttagcompound1));
        }
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putString("Subject", this.subject);
        compound.putString("Sender", this.sender);
        compound.putLong("Time", this.time);
        compound.putBoolean("BeenRead", this.beenRead);
        compound.put("Message", (Tag)this.message);
        compound.putLong("TimePast", System.currentTimeMillis() - this.time);
        compound.putInt("MailQuest", this.questId);
        if (this.hasQuest()) {
            compound.putString("MailQuestTitle", this.getQuest().title);
        }
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.putByte("Slot", (byte)i);
            nbttagcompound1 = (CompoundTag)((ItemStack)this.items.get(i)).save(NBTTags.getProvider(), (Tag)nbttagcompound1);
            nbttaglist.add((Object)nbttagcompound1);
        }
        compound.put("MailItems", (Tag)nbttaglist);
        return compound;
    }

    public boolean isValid() {
        return !this.subject.isEmpty() && !this.message.isEmpty() && !this.sender.isEmpty();
    }

    public boolean hasQuest() {
        return this.getQuest() != null;
    }

    @Override
    public Quest getQuest() {
        return QuestController.instance != null ? QuestController.instance.quests.get(this.questId) : null;
    }

    public int getContainerSize() {
        return 4;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public ItemStack getItem(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int var1) {
        return (ItemStack)this.items.set(var1, (Object)ItemStack.EMPTY);
    }

    public void setItem(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void setChanged() {
    }

    public boolean stillValid(Player var1) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int var1, ItemStack var2) {
        return true;
    }

    public PlayerMail copy() {
        PlayerMail mail = new PlayerMail();
        mail.readNBT(this.writeNBT());
        return mail;
    }

    public boolean isEmpty() {
        for (int slot = 0; slot < this.getContainerSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getSender() {
        return this.sender;
    }

    @Override
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String[] getText() {
        ArrayList<String> list = new ArrayList<String>();
        ListTag pages = this.message.getList("pages", 8);
        for (int i = 0; i < pages.size(); ++i) {
            list.add(pages.getString(i));
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void setText(String[] pages) {
        ListTag list = new ListTag();
        if (pages != null && pages.length > 0) {
            for (String page : pages) {
                list.add((Object)StringTag.valueOf((String)page));
            }
        }
        this.message.put("pages", (Tag)list);
    }

    @Override
    public void setQuest(int id) {
        this.questId = id;
    }

    @Override
    public IContainer getContainer() {
        return NpcAPI.Instance().getIContainer(this);
    }

    public void clearContent() {
    }
}

