/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.handler.data.IRecipe;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.data.Availability;

public class RecipeCarpentry
extends ShapedRecipe
implements IRecipe {
    public Availability availability = new Availability();
    public boolean isGlobal = false;
    public boolean ignoreDamage = false;
    public boolean ignoreNBT = false;
    public boolean savesRecipe = true;
    public String name;

    public RecipeCarpentry(int width, int height, NonNullList<Ingredient> recipe, ItemStack result) {
        super("customnpcs", CraftingBookCategory.MISC, new ShapedRecipePattern(width, height, recipe, Optional.empty()), result);
    }

    public RecipeCarpentry(String name) {
        super("customnpcs", CraftingBookCategory.MISC, new ShapedRecipePattern(0, 0, NonNullList.create(), Optional.empty()), ItemStack.EMPTY);
        this.name = name;
    }

    public static RecipeCarpentry load(CompoundTag compound, HolderLookup.Provider provider) {
        RecipeCarpentry recipe = new RecipeCarpentry(compound.getInt("Width"), compound.getInt("Height"), NBTTags.getIngredientList(provider, compound.getList("Materials", 10)), ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("Item")));
        recipe.availability.load(provider, compound.getCompound("Availability"));
        recipe.ignoreDamage = compound.getBoolean("IgnoreDamage");
        recipe.ignoreNBT = compound.getBoolean("IgnoreNBT");
        recipe.isGlobal = compound.getBoolean("Global");
        return recipe;
    }

    public CompoundTag writeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("Width", this.getWidth());
        compound.putInt("Height", this.getHeight());
        if (this.getResult() != null && !this.getResult().isEmpty()) {
            compound.put("Item", this.getResult().save(provider, (Tag)new CompoundTag()));
        }
        compound.put("Materials", (Tag)NBTTags.nbtIngredientList(provider, (NonNullList<Ingredient>)this.getIngredients()));
        compound.put("Availability", (Tag)this.availability.save(provider, new CompoundTag()));
        compound.putString("Name", this.name);
        compound.putBoolean("Global", this.isGlobal);
        compound.putBoolean("IgnoreDamage", this.ignoreDamage);
        compound.putBoolean("IgnoreNBT", this.ignoreNBT);
        return compound;
    }

    public static RecipeCarpentry createRecipe(RecipeCarpentry recipe, ItemStack par1ItemStack, Object ... limbSwingAmountArrayOfObj) {
        int var9;
        Object var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (limbSwingAmountArrayOfObj[var4] instanceof String[]) {
            String[] var7;
            String[] var8 = var7 = (String[])limbSwingAmountArrayOfObj[var4++];
            var9 = var7.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                String var11 = var8[var10];
                ++var6;
                var5 = var11.length();
                var3 = (String)var3 + var11;
            }
        } else {
            while (limbSwingAmountArrayOfObj[var4] instanceof String) {
                String var13 = (String)limbSwingAmountArrayOfObj[var4++];
                ++var6;
                var5 = var13.length();
                var3 = (String)var3 + var13;
            }
        }
        HashMap<Character, ItemStack> var14 = new HashMap<Character, ItemStack>();
        while (var4 < limbSwingAmountArrayOfObj.length) {
            Character var16 = (Character)limbSwingAmountArrayOfObj[var4];
            ItemStack var17 = ItemStack.EMPTY;
            if (limbSwingAmountArrayOfObj[var4 + 1] instanceof Item) {
                var17 = new ItemStack((ItemLike)((Item)limbSwingAmountArrayOfObj[var4 + 1]));
            } else if (limbSwingAmountArrayOfObj[var4 + 1] instanceof Block) {
                var17 = new ItemStack((ItemLike)((Block)limbSwingAmountArrayOfObj[var4 + 1]), 1);
            } else if (limbSwingAmountArrayOfObj[var4 + 1] instanceof ItemStack) {
                var17 = (ItemStack)limbSwingAmountArrayOfObj[var4 + 1];
            }
            var14.put(var16, var17);
            var4 += 2;
        }
        NonNullList ingredients = NonNullList.create();
        for (var9 = 0; var9 < var5 * var6; ++var9) {
            char var18 = ((String)var3).charAt(var9);
            if (var14.containsKey(Character.valueOf(var18))) {
                ingredients.add(var9, (Object)Ingredient.of((ItemStack[])new ItemStack[]{((ItemStack)var14.get(Character.valueOf(var18))).copy()}));
                continue;
            }
            ingredients.add(var9, (Object)Ingredient.EMPTY);
        }
        RecipeCarpentry newrecipe = new RecipeCarpentry(var5, var6, (NonNullList<Ingredient>)ingredients, par1ItemStack);
        newrecipe.copy(recipe);
        if (var5 == 4 || var6 == 4) {
            newrecipe.isGlobal = false;
        }
        return newrecipe;
    }

    public boolean matches(CraftingInput inventoryCrafting, Level world) {
        for (int i = 0; i <= 4 - this.getWidth(); ++i) {
            for (int j = 0; j <= 4 - this.getHeight(); ++j) {
                if (this.checkMatch(inventoryCrafting, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inventoryCrafting, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        if (this.getResult().isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.getResult().copy();
    }

    private boolean checkMatch(CraftingInput inventoryCrafting, int limbSwingAmount, int par3, boolean par4) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ItemStack var10;
                int var7 = i - limbSwingAmount;
                int var8 = j - par3;
                Ingredient ingredient = Ingredient.EMPTY;
                if (var7 >= 0 && var8 >= 0 && var7 < this.getWidth() && var8 < this.getHeight()) {
                    ingredient = par4 ? (Ingredient)this.getIngredients().get(this.getWidth() - var7 - 1 + var8 * this.getWidth()) : (Ingredient)this.getIngredients().get(var7 + var8 * this.getWidth());
                }
                if (!(var10 = ItemStack.EMPTY).isEmpty() || ingredient.getItems().length == 0) {
                    return false;
                }
                ItemStack var9 = ingredient.getItems()[0];
                if (var10.isEmpty() && var9.isEmpty() || NoppesUtilPlayer.compareItems(var9, var10, this.ignoreDamage, this.ignoreNBT)) continue;
                return false;
            }
        }
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventoryCrafting) {
        NonNullList list = NonNullList.withSize((int)inventoryCrafting.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.getItem(i);
            if (itemstack.getItem().hasCraftingRemainingItem()) {
                list.set(i, (Object)new ItemStack((ItemLike)itemstack.getItem().getCraftingRemainingItem()));
                continue;
            }
            list.set(i, (Object)ItemStack.EMPTY);
        }
        return list;
    }

    public boolean isSpecial() {
        return false;
    }

    public void copy(RecipeCarpentry recipe) {
        this.availability = recipe.availability;
        this.isGlobal = recipe.isGlobal;
        this.ignoreDamage = recipe.ignoreDamage;
        this.ignoreNBT = recipe.ignoreNBT;
    }

    public ItemStack getCraftingItem(int i) {
        if (i >= this.getIngredients().size()) {
            return ItemStack.EMPTY;
        }
        Ingredient ingredients = (Ingredient)this.getIngredients().get(i);
        if (ingredients.getItems().length == 0) {
            return ItemStack.EMPTY;
        }
        return ingredients.getItems()[0];
    }

    public boolean isValid() {
        if (this.getIngredients().size() == 0 || this.getResult().isEmpty()) {
            return false;
        }
        for (Ingredient ingredient : this.getIngredients()) {
            if (ingredient.getItems().length <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getResult() {
        return this.getResult();
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    public void setIsGlobal(boolean bo) {
        this.isGlobal = bo;
    }

    @Override
    public boolean getIgnoreNBT() {
        return this.ignoreNBT;
    }

    @Override
    public void setIgnoreNBT(boolean bo) {
        this.ignoreNBT = bo;
    }

    @Override
    public boolean getIgnoreDamage() {
        return this.ignoreDamage;
    }

    @Override
    public void setIgnoreDamage(boolean bo) {
        this.ignoreDamage = bo;
    }

    @Override
    public void save() {
        RecipeController.instance.saveRecipe(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public int getWidth() {
        return this.getWidth();
    }

    @Override
    public int getHeight() {
        return this.getHeight();
    }

    @Override
    public ItemStack[] getRecipe() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Ingredient ingredient : this.getIngredients()) {
            if (ingredient.getItems().length <= 0) continue;
            list.add(ingredient.getItems()[0]);
        }
        return list.toArray(new ItemStack[list.size()]);
    }

    @Override
    public void saves(boolean bo) {
        this.savesRecipe = bo;
    }

    @Override
    public boolean saves() {
        return this.savesRecipe;
    }
}

