/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import noppes.npcs.CustomEntities;
import noppes.npcs.EventHooks;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.ParticleType;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.api.entity.IProjectile;
import noppes.npcs.api.event.ProjectileEvent;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataRanged;

public class EntityProjectile
extends ThrowableProjectile {
    private static final EntityDataAccessor<Boolean> Gravity = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> Arrow = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> Is3d = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> Glows = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> Rotating = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> Sticks = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ItemStack> ItemStackThrown = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> Velocity = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> Size = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> Particle = SynchedEntityData.defineId(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private BlockPos tilePos = BlockPos.ZERO;
    private BlockState inBlock;
    protected boolean inGround = false;
    public int throwableShake = 0;
    public int arrowShake = 0;
    public boolean canBePickedUp = false;
    public boolean destroyedOnEntityHit = true;
    private Entity thrower;
    private EntityNPCInterface npc;
    private String throwerName = null;
    private int ticksInGround;
    public int ticksInAir = 0;
    private double accelerationX;
    private double accelerationY;
    private double accelerationZ;
    public float damage = 5.0f;
    public int punch = 0;
    public boolean accelerate = false;
    public boolean explosiveDamage = true;
    public int explosiveRadius = 0;
    public int effect = 0;
    public int duration = 5;
    public int amplify = 0;
    public int accuracy = 60;
    public IProjectileCallback callback;
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();

    public EntityProjectile(EntityType type, Level par1Level) {
        super(type, par1Level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ItemStackThrown, (Object)ItemStack.EMPTY);
        builder.define(Velocity, (Object)10);
        builder.define(Size, (Object)10);
        builder.define(Particle, (Object)0);
        builder.define(Gravity, (Object)false);
        builder.define(Glows, (Object)false);
        builder.define(Arrow, (Object)false);
        builder.define(Is3d, (Object)false);
        builder.define(Rotating, (Object)false);
        builder.define(Sticks, (Object)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double par1) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public EntityProjectile(Level level, LivingEntity limbSwingAmountEntityLiving, ItemStack item, boolean isNPC) {
        super(CustomEntities.entityProjectile, level);
        this.thrower = limbSwingAmountEntityLiving;
        if (this.thrower != null) {
            this.throwerName = this.thrower.getUUID().toString();
        }
        this.setThrownItem(item);
        this.entityData.set(Arrow, (Object)(this.getItem() == Items.ARROW ? 1 : 0));
        this.moveTo(limbSwingAmountEntityLiving.getX(), limbSwingAmountEntityLiving.getY() + (double)limbSwingAmountEntityLiving.getEyeHeight(), limbSwingAmountEntityLiving.getZ(), limbSwingAmountEntityLiving.getYRot(), limbSwingAmountEntityLiving.getXRot());
        double posX = this.getX() - (double)(Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.1f);
        double posY = this.getY() - (double)0.1f;
        double posZ = this.getZ() - (double)(Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * 0.1f);
        this.setPos(posX, posY, posZ);
        if (isNPC) {
            this.npc = (EntityNPCInterface)this.thrower;
            this.getStatProperties(this.npc.stats.ranged);
            this.refreshDimensions();
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> para) {
        if (Size.equals(para)) {
            this.refreshDimensions();
        }
    }

    public void setThrownItem(ItemStack item) {
        this.entityData.set(ItemStackThrown, (Object)item);
    }

    public int getSize() {
        return (Integer)this.entityData.get(Size);
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)((float)this.getSize() / 10.0f), (float)((float)this.getSize() / 10.0f));
    }

    public void shoot(double par1, double par3, double par5, float par7, float par8) {
        double f2 = Math.sqrt(par1 * par1 + par3 * par3 + par5 * par5);
        double f3 = Math.sqrt(par1 * par1 + par5 * par5);
        float yaw = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        float pitch = this.hasGravity() ? par7 : (float)(Math.atan2(par3, f3) * 180.0 / Math.PI);
        this.yRotO = yaw;
        this.xRotO = pitch;
        this.setYRot(yaw);
        this.setXRot(pitch);
        Vec3 m = new Vec3((double)(Mth.sin((float)(yaw / 180.0f * (float)Math.PI)) * Mth.cos((float)(pitch / 180.0f * (float)Math.PI))), (double)Mth.sin((float)((pitch + 1.0f) / 180.0f * (float)Math.PI)), (double)(Mth.cos((float)(yaw / 180.0f * (float)Math.PI)) * Mth.cos((float)(pitch / 180.0f * (float)Math.PI)))).add(this.random.nextGaussian() * 0.0075 * (double)par8, this.random.nextGaussian() * 0.0075 * (double)par8, this.random.nextGaussian() * 0.0075 * (double)par8).scale((double)this.getSpeed());
        this.setDeltaMovement(m);
        this.accelerationX = par1 / f2 * 0.1;
        this.accelerationY = par3 / f2 * 0.1;
        this.accelerationZ = par5 / f2 * 0.1;
        this.ticksInGround = 0;
    }

    public float getAngleForXYZ(double varX, double varY, double varZ, float horiDist, boolean arc) {
        float g = (float)this.getGravity();
        float var1 = this.getSpeed() * this.getSpeed();
        float var2 = g * horiDist;
        float var3 = (float)((double)(g * horiDist * horiDist) + 2.0 * varY * (double)var1);
        float var4 = var1 * var1 - g * var3;
        if (var4 < 0.0f) {
            return 30.0f;
        }
        float var6 = arc ? var1 + Mth.sqrt((float)var4) : var1 - Mth.sqrt((float)var4);
        float var7 = (float)(Math.atan2(var6, var2) * 180.0 / Math.PI);
        return var7;
    }

    public void shoot(float speed) {
        double varX = -Mth.sin((float)(this.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(this.getXRot() / 180.0f * (float)Math.PI));
        double varZ = Mth.cos((float)(this.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(this.getXRot() / 180.0f * (float)Math.PI));
        double varY = -Mth.sin((float)(this.getXRot() / 180.0f * (float)Math.PI));
        this.shoot(varX, varY, varZ, -this.getXRot(), speed);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void lerpTo(double par1, double par3, double par5, float par7, float par8, int par9) {
        if (this.level().isClientSide && this.inGround) {
            return;
        }
        this.setPos(par1, par3, par5);
        this.setRot(par7, par8);
    }

    public void tick() {
        AABB axisalignedbb;
        VoxelShape shape;
        super.baseTick();
        if (++this.tickCount % 10 == 0) {
            EventHooks.onProjectileTick(this);
        }
        Vec3 motion = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double f = motion.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)motion.y, (double)f) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        if (this.effect != 666 || !this.inGround) {
            // empty if block
        }
        BlockState state = this.level().getBlockState(this.tilePos);
        if ((this.isArrow() || this.sticksToWalls()) && this.tilePos != BlockPos.ZERO && !(shape = state.getShape((BlockGetter)this.level(), this.tilePos)).isEmpty() && (axisalignedbb = shape.bounds()) != null && axisalignedbb.contains(this.position())) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            if (state == this.inBlock) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            } else {
                this.inGround = false;
                this.setDeltaMovement(this.getDeltaMovement().multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            ++this.ticksInAir;
            if (this.ticksInAir == 1200) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            Vec3 pos = this.position();
            Vec3 nextpos = pos.add(motion);
            HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHit);
            if (hitresult != null && hitresult.getType() != HitResult.Type.MISS) {
                this.entityData.set(Rotating, (Object)false);
                this.onHit(hitresult);
            }
            motion = this.getDeltaMovement();
            double f1 = motion.horizontalDistance();
            this.setXRot(EntityProjectile.lerpRotation((float)this.xRotO, (float)((float)(Mth.atan2((double)motion.y, (double)f1) * 57.2957763671875))));
            this.setYRot(EntityProjectile.lerpRotation((float)this.yRotO, (float)((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875))));
            if (this.isRotating()) {
                int spin = this.isBlock() ? 10 : 20;
                this.setXRot(this.getXRot() - (float)spin * this.getSpeed());
            }
            float f2 = this.getMotionFactor();
            float f3 = (float)this.getGravity();
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, nextpos.x - motion.x * 0.25, nextpos.y - motion.y * 0.25, nextpos.z - motion.z * 0.25, motion.x, motion.y, motion.z);
                }
                f2 = 0.6f;
            }
            motion = motion.scale((double)f2);
            if (this.hasGravity()) {
                motion = motion.subtract(0.0, (double)f3, 0.0);
            }
            if (this.accelerate) {
                motion = motion.add(this.accelerationX, this.accelerationY, this.accelerationZ);
            }
            if (this.level().isClientSide && (Integer)this.entityData.get(Particle) > 0) {
                this.level().addParticle(ParticleType.getMCType((Integer)this.entityData.get(Particle)), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
            this.setDeltaMovement(motion);
            this.setPos(nextpos.x, nextpos.y, nextpos.z);
            this.checkInsideBlocks();
        }
    }

    protected boolean canHit(Entity entity) {
        if (!super.canHitEntity(entity) || entity == this.thrower || this.npc != null && (entity == this.npc || this.npc.isAlliedTo(entity))) {
            return false;
        }
        if (entity instanceof Player) {
            Player entityplayer = (Player)entity;
            if (entityplayer.getAbilities().invulnerable || this.thrower instanceof Player && !((Player)this.thrower).canHarmPlayer(entityplayer)) {
                return false;
            }
        }
        return true;
    }

    public boolean isBlock() {
        ItemStack item = this.getItemDisplay();
        if (item.isEmpty()) {
            return false;
        }
        return item.getItem() instanceof BlockItem;
    }

    private Item getItem() {
        ItemStack item = this.getItemDisplay();
        if (item.isEmpty()) {
            return Items.AIR;
        }
        return item.getItem();
    }

    protected float getMotionFactor() {
        return this.accelerate ? 0.95f : 1.0f;
    }

    protected void onHit(HitResult movingobjectposition) {
        block31: {
            block29: {
                block30: {
                    Vec3 m;
                    double f3;
                    if (!this.level().isClientSide) {
                        ProjectileEvent.ImpactEvent event;
                        BlockPos pos = BlockPos.ZERO;
                        Entity e = null;
                        if (movingobjectposition.getType() == HitResult.Type.ENTITY) {
                            e = ((EntityHitResult)movingobjectposition).getEntity();
                            pos = e.blockPosition();
                            event = new ProjectileEvent.ImpactEvent((IProjectile)NpcAPI.Instance().getIEntity((Entity)this), 0, e);
                        } else {
                            pos = ((BlockHitResult)movingobjectposition).getBlockPos();
                            BlockState state = this.level().getBlockState(pos);
                            event = new ProjectileEvent.ImpactEvent((IProjectile)NpcAPI.Instance().getIEntity((Entity)this), 1, NpcAPI.Instance().getIBlock(this.level(), pos));
                        }
                        if (pos == BlockPos.ZERO) {
                            pos = new BlockPos((int)movingobjectposition.getLocation().x, (int)movingobjectposition.getLocation().y, (int)movingobjectposition.getLocation().z);
                        }
                        if (this.callback != null && this.callback.onImpact(this, pos, e)) {
                            return;
                        }
                        EventHooks.onProjectileImpact(this, event);
                    }
                    if (movingobjectposition.getType() != HitResult.Type.ENTITY) break block29;
                    Entity e = ((EntityHitResult)movingobjectposition).getEntity();
                    float damage = this.damage;
                    if (damage == 0.0f) {
                        damage = 0.001f;
                    }
                    if (!e.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), damage)) break block30;
                    if (e instanceof LivingEntity) {
                        LivingEntity entityliving = (LivingEntity)e;
                        if (!this.level().isClientSide && (this.isArrow() || this.sticksToWalls())) {
                            entityliving.setArrowCount(entityliving.getArrowCount() + 1);
                        }
                        if (this.destroyedOnEntityHit && !(e instanceof EnderMan)) {
                            this.remove(Entity.RemovalReason.DISCARDED);
                        }
                        if (this.effect != 0) {
                            if (this.effect != 666) {
                                entityliving.addEffect(new MobEffectInstance((Holder)PotionEffectType.getHolder(this.effect).get(), this.duration * 20, this.amplify));
                            } else {
                                entityliving.setRemainingFireTicks(this.duration * 20);
                            }
                        }
                    }
                    if (this.isBlock()) {
                        this.level().levelEvent((Player)null, 2001, e.blockPosition(), Block.getId((BlockState)((BlockItem)this.getItem()).getBlock().defaultBlockState()));
                    } else if (!this.isArrow() && !this.sticksToWalls()) {
                        for (int i = 0; i < 8; ++i) {
                            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemDisplay()), this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.15, this.random.nextGaussian() * 0.2, this.random.nextGaussian() * 0.15);
                        }
                    }
                    if (this.punch > 0 && (f3 = (m = this.getDeltaMovement()).horizontalDistance()) > 0.0) {
                        e.push(m.x() * (double)this.punch * 0.6 / f3, 0.1, m.z() * (double)this.punch * 0.6 / f3);
                    }
                    break block31;
                }
                if (!this.hasGravity() || !this.isArrow() && !this.sticksToWalls()) break block31;
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.1));
                this.setYRot(this.getYRot() + 180.0f);
                this.yRotO += 180.0f;
                this.ticksInAir = 0;
                break block31;
            }
            if (this.isArrow() || this.sticksToWalls()) {
                this.tilePos = ((BlockHitResult)movingobjectposition).getBlockPos();
                this.inBlock = this.level().getBlockState(this.tilePos);
                Vec3 m = movingobjectposition.getLocation().subtract(this.position());
                this.setDeltaMovement(m);
                Vec3 vector3d1 = m.normalize().scale((double)0.05f);
                this.setPosRaw(this.getX() - vector3d1.x, this.getY() - vector3d1.y, this.getZ() - vector3d1.z);
                this.inGround = true;
                this.arrowShake = 7;
                if (!this.hasGravity()) {
                    this.entityData.set(Gravity, (Object)true);
                }
                if (this.inBlock != null) {
                    this.inBlock.entityInside(this.level(), this.tilePos, (Entity)this);
                }
            } else if (this.isBlock()) {
                this.level().levelEvent((Player)null, 2001, this.blockPosition(), Block.getId((BlockState)((BlockItem)this.getItem()).getBlock().defaultBlockState()));
            } else {
                for (int i = 0; i < 8; ++i) {
                    this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemDisplay()), this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.15, this.random.nextGaussian() * 0.2, this.random.nextGaussian() * 0.15);
                }
            }
        }
        if (this.explosiveRadius > 0) {
            boolean terraindamage = this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && this.explosiveDamage;
            this.level().explode((Entity)(this.getOwner() == null ? this : this.getOwner()), this.getX(), this.getY(), this.getZ(), (float)this.explosiveRadius, this.effect == 666, terraindamage ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
            if (this.effect != 0) {
                AABB axisalignedbb = this.getBoundingBox().inflate((double)(this.explosiveRadius * 2), (double)(this.explosiveRadius * 2), (double)(this.explosiveRadius * 2));
                List list1 = this.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
                MobEffect p = PotionEffectType.getMCType(this.effect);
                for (LivingEntity entity : list1) {
                    if (this.effect != 666) {
                        entity.addEffect(new MobEffectInstance(Holder.direct((Object)p), this.duration * 20, this.amplify));
                        continue;
                    }
                    entity.setRemainingFireTicks(this.duration * 20);
                }
                this.level().levelEvent((Player)null, 2002, this.blockPosition(), this.getPotionColor(this.effect));
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (!(this.level().isClientSide || this.isArrow() || this.sticksToWalls())) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private void blockParticles() {
    }

    public void addAdditionalSaveData(CompoundTag par1CompoundTag) {
        par1CompoundTag.putShort("xTile", (short)this.tilePos.getX());
        par1CompoundTag.putShort("yTile", (short)this.tilePos.getY());
        par1CompoundTag.putShort("zTile", (short)this.tilePos.getZ());
        if (this.inBlock != null) {
            par1CompoundTag.put("inBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.inBlock));
        }
        par1CompoundTag.putByte("shake", (byte)this.throwableShake);
        par1CompoundTag.putBoolean("inGround", this.inGround);
        par1CompoundTag.putBoolean("isArrow", this.isArrow());
        Vec3 m = this.getDeltaMovement();
        par1CompoundTag.put("direction", (Tag)this.newDoubleList(new double[]{m.x, m.y, m.z}));
        par1CompoundTag.putBoolean("canBePickedUp", this.canBePickedUp);
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof Player) {
            this.throwerName = this.thrower.getUUID().toString();
        }
        par1CompoundTag.putString("ownerName", this.throwerName == null ? "" : this.throwerName);
        par1CompoundTag.put("Item", this.getItemDisplay().save((HolderLookup.Provider)this.registryAccess()));
        par1CompoundTag.putFloat("damagev2", this.damage);
        par1CompoundTag.putInt("punch", this.punch);
        par1CompoundTag.putInt("size", ((Integer)this.entityData.get(Size)).intValue());
        par1CompoundTag.putInt("velocity", ((Integer)this.entityData.get(Velocity)).intValue());
        par1CompoundTag.putInt("explosiveRadius", this.explosiveRadius);
        par1CompoundTag.putInt("effectDuration", this.duration);
        par1CompoundTag.putBoolean("gravity", this.hasGravity());
        par1CompoundTag.putBoolean("accelerate", this.accelerate);
        par1CompoundTag.putBoolean("glows", ((Boolean)this.entityData.get(Glows)).booleanValue());
        par1CompoundTag.putInt("PotionEffect", this.effect);
        par1CompoundTag.putInt("trailenum", ((Integer)this.entityData.get(Particle)).intValue());
        par1CompoundTag.putBoolean("Render3D", ((Boolean)this.entityData.get(Is3d)).booleanValue());
        par1CompoundTag.putBoolean("Spins", ((Boolean)this.entityData.get(Rotating)).booleanValue());
        par1CompoundTag.putBoolean("Sticks", ((Boolean)this.entityData.get(Sticks)).booleanValue());
        par1CompoundTag.putInt("accuracy", this.accuracy);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.tilePos = new BlockPos((int)compound.getShort("xTile"), (int)compound.getShort("yTile"), (int)compound.getShort("zTile"));
        if (compound.contains("inBlockState", 10)) {
            this.inBlock = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("inBlockState"));
        }
        this.throwableShake = compound.getByte("shake") & 0xFF;
        this.inGround = compound.getByte("inGround") == 1;
        this.entityData.set(Arrow, (Object)compound.getBoolean("isArrow"));
        this.throwerName = compound.getString("ownerName");
        this.canBePickedUp = compound.getBoolean("canBePickedUp");
        this.damage = compound.getFloat("damagev2");
        this.punch = compound.getInt("punch");
        this.explosiveRadius = compound.getInt("explosiveRadius");
        this.duration = compound.getInt("effectDuration");
        this.accelerate = compound.getBoolean("accelerate");
        this.effect = compound.getInt("PotionEffect");
        this.accuracy = compound.getInt("accuracy");
        this.entityData.set(Particle, (Object)compound.getInt("trailenum"));
        this.entityData.set(Size, (Object)compound.getInt("size"));
        this.entityData.set(Glows, (Object)compound.getBoolean("glows"));
        this.entityData.set(Velocity, (Object)compound.getInt("velocity"));
        this.entityData.set(Gravity, (Object)compound.getBoolean("gravity"));
        this.entityData.set(Is3d, (Object)compound.getBoolean("Render3D"));
        this.entityData.set(Rotating, (Object)compound.getBoolean("Spins"));
        this.entityData.set(Sticks, (Object)compound.getBoolean("Sticks"));
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
        if (compound.contains("direction")) {
            ListTag nbttaglist = compound.getList("direction", 6);
            this.setDeltaMovement(new Vec3(nbttaglist.getDouble(0), nbttaglist.getDouble(1), nbttaglist.getDouble(2)));
        }
        CompoundTag var2 = compound.getCompound("Item");
        ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)var2);
        if (item.isEmpty()) {
            this.discard();
        } else {
            this.entityData.set(ItemStackThrown, (Object)item);
        }
    }

    public Entity getOwner() {
        if (this.throwerName == null || this.throwerName.isEmpty()) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(this.throwerName);
            if (this.thrower == null && uuid != null) {
                this.thrower = this.level().getPlayerByUUID(uuid);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.thrower;
    }

    private int getPotionColor(int p) {
        switch (p) {
            case 19: {
                return 32660;
            }
            case 17: {
                return 32660;
            }
            case 18: {
                return 32696;
            }
            case 2: {
                return 32698;
            }
            case 9: {
                return 32732;
            }
            case 15: {
                return 15;
            }
            case 20: {
                return 32732;
            }
        }
        return 0;
    }

    public void getStatProperties(DataRanged stats) {
        this.damage = stats.getStrength();
        this.punch = stats.getKnockback();
        this.accelerate = stats.getAccelerate();
        this.explosiveRadius = stats.getExplodeSize();
        this.effect = stats.getEffectType();
        this.duration = stats.getEffectTime();
        this.amplify = stats.getEffectStrength();
        this.setParticleEffect(stats.getParticle());
        this.entityData.set(Size, (Object)stats.getSize());
        this.entityData.set(Glows, (Object)stats.getGlows());
        this.setSpeed(stats.getSpeed());
        this.setHasGravity(stats.getHasGravity());
        this.setIs3D(stats.getRender3D());
        this.setRotating(stats.getSpins());
        this.setStickInWall(stats.getSticks());
    }

    public void setParticleEffect(int type) {
        this.entityData.set(Particle, (Object)type);
    }

    public void setHasGravity(boolean bo) {
        this.entityData.set(Gravity, (Object)bo);
    }

    public void setIs3D(boolean bo) {
        this.entityData.set(Is3d, (Object)bo);
    }

    public void setStickInWall(boolean bo) {
        this.entityData.set(Sticks, (Object)bo);
    }

    public ItemStack getItemDisplay() {
        return (ItemStack)this.entityData.get(ItemStackThrown);
    }

    public float getLightLevelDependentMagicValue() {
        return (Boolean)this.entityData.get(Glows) != false ? 1.0f : super.getLightLevelDependentMagicValue();
    }

    public boolean hasGravity() {
        return (Boolean)this.entityData.get(Gravity);
    }

    public void setSpeed(int speed) {
        this.entityData.set(Velocity, (Object)speed);
    }

    public float getSpeed() {
        return (float)((Integer)this.entityData.get(Velocity)).intValue() / 10.0f;
    }

    public boolean isArrow() {
        return (Boolean)this.entityData.get(Arrow);
    }

    public void setRotating(boolean bo) {
        this.entityData.set(Rotating, (Object)bo);
    }

    public boolean isRotating() {
        return (Boolean)this.entityData.get(Rotating);
    }

    public boolean glows() {
        return (Boolean)this.entityData.get(Glows);
    }

    public boolean is3D() {
        return (Boolean)this.entityData.get(Is3d) != false || this.isBlock();
    }

    public boolean sticksToWalls() {
        return this.is3D() && (Boolean)this.entityData.get(Sticks) != false;
    }

    public void playerTouch(Player par1Player) {
        if (this.level().isClientSide || !this.canBePickedUp || !this.inGround || this.arrowShake > 0) {
            return;
        }
        if (par1Player.getInventory().add(this.getItemDisplay())) {
            this.inGround = false;
            this.playSound(SoundEvents.ITEM_PICKUP, 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            par1Player.take((Entity)this, 1);
            this.discard();
        }
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public Component getDisplayName() {
        if (!this.getItemDisplay().isEmpty()) {
            return this.getItemDisplay().getDisplayName();
        }
        return super.getDisplayName();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, serverEntity, entity == null ? 0 : entity.getId());
    }

    public static interface IProjectileCallback {
        public boolean onImpact(EntityProjectile var1, BlockPos var2, Entity var3);
    }
}

