/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.entity.data.IEntityPersistentData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityPersistentData
implements IEntityPersistentData {
    @Shadow
    private Level level;
    @Unique
    private CompoundTag CNPC_tag;

    @Override
    @Unique
    public CompoundTag getPersistentData() {
        if (this.CNPC_tag == null) {
            this.CNPC_tag = new CompoundTag();
        }
        return this.CNPC_tag;
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="TAIL")})
    public void save(CompoundTag compound, CallbackInfoReturnable<CompoundTag> cir) {
        if (this.CNPC_tag != null) {
            MarkData.get((LivingEntity)this).save();
            compound.put("CNPC_persistantData", (Tag)this.CNPC_tag);
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void read(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("CNPC_persistantData")) {
            this.CNPC_tag = compound.getCompound("CNPC_persistantData");
            MarkData.get((LivingEntity)this);
        }
    }
}

