/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import noppes.npcs.client.controllers.ClientSkinController;
import noppes.npcs.controllers.data.PlayerSkinData;
import noppes.npcs.shared.common.PacketBasic;

public class PacketSyncSkin
extends PacketBasic {
    private final String name;
    private final PlayerSkinData skinData;

    public PacketSyncSkin(String name, PlayerSkinData skinData) {
        this.name = name;
        this.skinData = skinData;
    }

    public static void encode(PacketSyncSkin msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.name);
        CompoundTag tag = new CompoundTag();
        msg.skinData.saveNBTData(tag);
        buf.writeNbt((Tag)tag);
    }

    public static PacketSyncSkin decode(FriendlyByteBuf buf) {
        String name = buf.readUtf();
        CompoundTag tag = buf.readNbt();
        PlayerSkinData skinData = new PlayerSkinData();
        skinData.loadNBTData(tag);
        return new PacketSyncSkin(name, skinData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handle() {
        ClientSkinController.addSkinForPlayer(this.name, this.skinData);
    }
}

