/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketQuestOpen
extends PacketServerBasic {
    private EnumGuiType gui;
    private CompoundTag data;

    public SPacketQuestOpen(EnumGuiType gui, CompoundTag data) {
        this.gui = gui;
        this.data = data;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return true;
    }

    @Override
    public PermissionNode<Boolean> getPermission() {
        return CustomNpcsPermissions.GLOBAL_DIALOG;
    }

    public static void encode(SPacketQuestOpen msg, FriendlyByteBuf buf) {
        buf.writeEnum((Enum)msg.gui);
        buf.writeNbt((Tag)msg.data);
    }

    public static SPacketQuestOpen decode(FriendlyByteBuf buf) {
        return new SPacketQuestOpen((EnumGuiType)buf.readEnum(EnumGuiType.class), buf.readNbt());
    }

    @Override
    protected void handle() {
        Quest quest = new Quest(null);
        quest.readNBT((HolderLookup.Provider)this.player.registryAccess(), this.data);
        NoppesUtilServer.setEditingQuest((Player)this.player, quest);
        NoppesUtilServer.openContainerGui(this.player, this.gui, buf -> buf.writeBlockPos(BlockPos.ZERO));
    }
}

