/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketToolMounter
extends PacketServerBasic {
    private int type;
    private String name = "";
    private int tab = -1;
    private CompoundTag compound = new CompoundTag();

    private SPacketToolMounter(int type, String name, int tab, CompoundTag compound) {
        this.type = type;
        this.name = name;
        this.tab = tab;
        this.compound = compound;
    }

    public SPacketToolMounter(int type, String name, int tab) {
        this.type = type;
        this.name = name;
        this.tab = tab;
    }

    public SPacketToolMounter(int type, CompoundTag compound) {
        this.type = type;
        this.compound = compound;
    }

    public SPacketToolMounter() {
        this.type = 3;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.getItem() == CustomItems.mount;
    }

    @Override
    public PermissionNode<Boolean> getPermission() {
        return CustomNpcsPermissions.TOOL_MOUNTER;
    }

    public static void encode(SPacketToolMounter msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.type);
        buf.writeUtf(msg.name);
        buf.writeInt(msg.tab);
        buf.writeNbt((Tag)msg.compound);
    }

    public static SPacketToolMounter decode(FriendlyByteBuf buf) {
        return new SPacketToolMounter(buf.readInt(), buf.readUtf(Short.MAX_VALUE), buf.readInt(), buf.readNbt());
    }

    @Override
    protected void handle() {
        PlayerData data = PlayerData.get((Player)this.player);
        if (data.mounted == null) {
            return;
        }
        if (this.type == 0) {
            Entity entity = (Entity)EntityType.create((CompoundTag)this.compound, (Level)this.player.level()).get();
            entity.setPos(data.mounted.getX(), data.mounted.getY(), data.mounted.getZ());
            this.player.level().addFreshEntity(entity);
            entity.startRiding(data.mounted, true);
        } else if (this.type == 1) {
            Entity entity = (Entity)EntityType.create((CompoundTag)ServerCloneController.Instance.getCloneData(this.player.createCommandSourceStack(), this.name, this.tab), (Level)this.player.level()).get();
            entity.setPos(data.mounted.getX(), data.mounted.getY(), data.mounted.getZ());
            this.player.level().addFreshEntity(entity);
            entity.startRiding(data.mounted, true);
        } else if (this.type == 2) {
            ResourceLocation loc = EntityUtil.getAllEntities(this.player.level(), false).get(this.name);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(loc);
            Entity entity = type.create(this.player.level());
            if (entity == null) {
                return;
            }
            entity.setPos(data.mounted.getX(), data.mounted.getY(), data.mounted.getZ());
            this.player.level().addFreshEntity(entity);
            entity.startRiding(data.mounted, true);
        } else {
            this.player.startRiding(data.mounted, true);
        }
    }
}

