/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiCustomScrollNop;
import noppes.npcs.shared.client.gui.components.GuiLabel;
import noppes.npcs.shared.client.gui.components.GuiMenuSideButton;
import noppes.npcs.shared.client.gui.components.GuiMenuTopButton;
import noppes.npcs.shared.client.gui.components.GuiSliderNop;
import noppes.npcs.shared.client.gui.components.GuiTextFieldNop;
import noppes.npcs.shared.client.gui.components.GuiWrapper;
import noppes.npcs.shared.client.gui.listeners.IGui;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;

public class GuiBasic
extends Screen
implements IGuiInterface {
    public LocalPlayer player;
    public boolean drawDefaultBackground = true;
    public String title;
    public ResourceLocation background = null;
    public boolean closeOnEsc = true;
    public int guiLeft;
    public int guiTop;
    public int imageWidth;
    public int imageHeight;
    public float bgScale = 1.0f;
    public GuiWrapper wrapper = new GuiWrapper(this);

    public GuiBasic() {
        super((Component)Component.empty());
        this.player = Minecraft.getInstance().player;
        this.minecraft = Minecraft.getInstance();
        this.title = "";
        this.imageWidth = 200;
        this.imageHeight = 222;
        this.minecraft = Minecraft.getInstance();
        this.font = this.minecraft.font;
    }

    public void setBackground(String texture) {
        this.background = new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    public void init() {
        super.init();
        this.setFocused(null);
        this.guiLeft = (this.width - this.imageWidth) / 2;
        this.guiTop = (this.height - this.imageHeight) / 2;
        this.renderables.clear();
        this.children().clear();
        this.wrapper.init(this.minecraft, this.width, this.height);
    }

    @Override
    public GuiWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void initGui() {
        this.init();
    }

    public void tick() {
        this.wrapper.tick();
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrolled, double p_299502_) {
        if (this.wrapper.mouseScrolled(mouseX, mouseY, scrolled, p_299502_)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrolled, p_299502_);
    }

    public boolean mouseClicked(double i, double j, int k) {
        if (this.wrapper.mouseClicked(i, j, k)) {
            return true;
        }
        return super.mouseClicked(i, j, k);
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        if (this.wrapper.mouseDragged(x, y, button, dx, dy)) {
            return true;
        }
        return super.mouseDragged(x, y, button, dx, dy);
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.wrapper.mouseReleased(x, y, button)) {
            return true;
        }
        return super.mouseReleased(x, y, button);
    }

    public void setFocused(GuiEventListener gui) {
        if (this.wrapper.subgui != null) {
            this.wrapper.subgui.setFocused(gui);
        } else {
            if (gui != null && !this.children().contains(gui)) {
                return;
            }
            this.wrapper.changeFocus(this.getFocused(), gui);
            super.setFocused(gui);
        }
    }

    public GuiEventListener getFocused() {
        if (this.wrapper.subgui != null) {
            return this.wrapper.subgui.getFocused();
        }
        return super.getFocused();
    }

    @Override
    public void elementClicked() {
        if (this.wrapper.subgui != null && this.wrapper.subgui instanceof GuiBasic) {
            ((GuiBasic)this.wrapper.subgui).elementClicked();
        }
    }

    @Override
    public void subGuiClosed(Screen subgui) {
    }

    public boolean charTyped(char c, int i) {
        if (this.wrapper.charTyped(c, i)) {
            return true;
        }
        return super.charTyped(c, i);
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.wrapper.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean isInventoryKey(int i) {
        return this.minecraft.options.keyInventory.getKey().getValue() == i;
    }

    public boolean shouldCloseOnEsc() {
        return this.closeOnEsc;
    }

    public void close() {
        this.onClose();
    }

    public void onClose() {
        this.wrapper.close();
    }

    public void addButton(GuiButtonNop button) {
        this.wrapper.npcbuttons.put(button.id, button);
        super.addRenderableWidget((GuiEventListener)button);
    }

    public void addTopButton(GuiMenuTopButton button) {
        this.wrapper.topbuttons.put(button.id, button);
        super.addRenderableWidget((GuiEventListener)button);
    }

    public void addSideButton(GuiMenuSideButton button) {
        this.wrapper.sidebuttons.put(button.id, button);
        super.addRenderableWidget((GuiEventListener)button);
    }

    public GuiButtonNop getButton(int i) {
        return this.wrapper.npcbuttons.get(i);
    }

    public GuiMenuSideButton getSideButton(int i) {
        return this.wrapper.sidebuttons.get(i);
    }

    public GuiMenuTopButton getTopButton(int i) {
        return this.wrapper.topbuttons.get(i);
    }

    public void addTextField(GuiTextFieldNop tf) {
        this.wrapper.textfields.put(tf.id, tf);
    }

    public GuiTextFieldNop getTextField(int i) {
        return this.wrapper.textfields.get(i);
    }

    public void add(IGui gui) {
        this.wrapper.components.add(gui);
    }

    public IGui get(int id) {
        for (IGui comp : this.wrapper.components) {
            if (comp.getID() != id) continue;
            return comp;
        }
        return null;
    }

    public void addLabel(GuiLabel label) {
        this.wrapper.labels.put(label.id, label);
    }

    public GuiLabel getLabel(int i) {
        return this.wrapper.labels.get(i);
    }

    public void addSlider(GuiSliderNop slider) {
        this.wrapper.sliders.put(slider.id, slider);
        this.addRenderableWidget((GuiEventListener)slider);
    }

    public GuiSliderNop getSlider(int i) {
        return this.wrapper.sliders.get(i);
    }

    public void addScroll(GuiCustomScrollNop scroll) {
        scroll.init(this.minecraft, scroll.width, scroll.height);
        this.wrapper.scrolls.put(scroll.id, scroll);
    }

    public GuiCustomScrollNop getScroll(int id) {
        return this.wrapper.scrolls.get(id);
    }

    @Override
    public void save() {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = graphics.pose();
        this.wrapper.mouseX = mouseX;
        this.wrapper.mouseY = mouseY;
        int x = mouseX;
        int y = mouseY;
        if (this.wrapper.subgui != null) {
            y = 0;
            x = 0;
        }
        if (this.drawDefaultBackground && this.wrapper.subgui == null) {
            this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.background != null) {
            matrixStack.pushPose();
            matrixStack.translate((float)this.guiLeft, (float)this.guiTop, 0.0f);
            matrixStack.scale(this.bgScale, this.bgScale, this.bgScale);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.background);
            if (this.imageWidth > 256) {
                graphics.blit(this.background, 0, 0, 0, 0, 250, this.imageHeight);
                graphics.blit(this.background, 250, 0, 256 - (this.imageWidth - 250), 0, this.imageWidth - 250, this.imageHeight);
            } else {
                graphics.blit(this.background, 0, 0, 0, 0, this.imageWidth, this.imageHeight);
            }
            matrixStack.popPose();
        }
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        for (GuiLabel label : new ArrayList<GuiLabel>(this.wrapper.labels.values())) {
            label.render(graphics, mouseX, mouseY, partialTicks);
        }
        for (GuiTextFieldNop tf : new ArrayList<GuiTextFieldNop>(this.wrapper.textfields.values())) {
            tf.renderWidget(graphics, x, y, partialTicks);
        }
        for (GuiCustomScrollNop scroll : new ArrayList<GuiCustomScrollNop>(this.wrapper.scrolls.values())) {
            scroll.render(graphics, x, y, partialTicks);
        }
        for (IGui comp : new ArrayList<IGui>(this.wrapper.components)) {
            comp.render(graphics, x, y);
        }
        for (Screen gui : new ArrayList<Screen>(this.wrapper.extra.values())) {
            gui.render(graphics, x, y, partialTicks);
        }
        super.render(graphics, x, y, partialTicks);
        if (this.wrapper.subgui != null) {
            matrixStack.translate(0.0f, 0.0f, 60.0f);
            this.wrapper.subgui.render(graphics, mouseX, mouseY, partialTicks);
            matrixStack.translate(0.0f, 0.0f, -60.0f);
        }
    }

    public Font getFontRenderer() {
        return this.font;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void doubleClicked() {
    }

    public void setScreen(Screen gui) {
        this.minecraft.setScreen(gui);
    }

    public void setSubGui(Screen gui) {
        this.wrapper.setSubgui(gui);
        this.init();
    }

    @Override
    public boolean hasSubGui() {
        return this.wrapper.subgui != null;
    }

    @Override
    public Screen getSubGui() {
        return this.wrapper.getSubGui();
    }

    public void drawNpc(GuiGraphics graphics, LivingEntity entity, int x, int y, float zoomed, int rotation) {
        this.wrapper.drawNpc(graphics, entity, x, y, zoomed, rotation, this.guiLeft, this.guiTop);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void openLink(String link) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(link));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Screen getParent() {
        return this.wrapper.getParent();
    }
}

