/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_437;
import net.minecraft.class_897;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.controllers.CobblemonHelper;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityFakeLiving;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.shared.client.gui.components.GuiButtonBiDirectional;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiButtonYesNo;
import noppes.npcs.shared.client.gui.components.GuiCustomScrollNop;
import noppes.npcs.shared.client.gui.components.GuiTextFieldNop;
import noppes.npcs.shared.client.gui.listeners.ICustomScrollListener;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;
import noppes.npcs.shared.client.gui.listeners.ITextfieldListener;

public class GuiCreationExtra
extends GuiCreationScreenInterface
implements ICustomScrollListener,
ITextfieldListener {
    private final String[] ignoredTags = new String[]{"CanBreakDoors", "Bred", "PlayerCreated", "HasReproduced"};
    private final String[] grimmsTags = new String[]{"DataSkin", "DataHair", "DataFace", "DataUniform", "DataGemstone", "DataVisor", "DataGloves", "DataCape"};
    private final String[] booleanTags = new String[0];
    private GuiCustomScrollNop scroll;
    private Map<String, GuiType> data = new HashMap<String, GuiType>();
    private GuiType selected;
    public int nextAvailableFieldId = 0;

    public GuiCreationExtra(EntityNPCInterface npc) {
        super(npc);
        this.active = 2;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        if (this.entity == null) {
            return;
        }
        this.data = this.getData(this.entity);
        if (this.scroll == null) {
            this.scroll = new GuiCustomScrollNop(this, 0);
            ArrayList<String> list = new ArrayList<String>(this.data.keySet());
            this.scroll.setList(list);
            if (list.isEmpty()) {
                return;
            }
            this.scroll.setSelected((String)list.get(0));
        }
        this.selected = this.data.get(this.scroll.getSelected());
        if (this.selected == null) {
            return;
        }
        this.scroll.guiLeft = this.guiLeft;
        this.scroll.guiTop = this.guiTop + 46;
        this.scroll.setSize(100, this.imageHeight - 74);
        this.addScroll(this.scroll);
        this.selected.init();
    }

    public Map<String, GuiType> getData(class_1309 entity) {
        HashMap<String, GuiType> data = new HashMap<String, GuiType>();
        class_2487 compound = this.getExtras(entity);
        Set keys = compound.method_10541();
        for (String name : keys) {
            byte b;
            if (this.isIgnored(name)) continue;
            class_2520 base = compound.method_10580(name);
            if (name.equals("Age")) {
                data.put("Child", new GuiTypeBoolean("Child", entity.method_6109()));
                continue;
            }
            if (name.equals("Color") && base.method_10711() == 1) {
                data.put("Color", new GuiTypeByte("Color", compound.method_10571("Color")));
                continue;
            }
            if (base.method_10711() == 3) {
                data.put(name, new GuiTypeInt(name, compound.method_10550(name)));
                continue;
            }
            if (base.method_10711() != 1 || (b = ((class_2481)base).method_10698()) != 0 && b != 1) continue;
            if (this.playerdata.extra.method_10545(name)) {
                b = this.playerdata.extra.method_10571(name);
            }
            data.put(name, new GuiTypeBoolean(name, b == 1));
        }
        if (PixelmonHelper.isPixelmon((class_1297)entity)) {
            data.put("Model", new GuiTypePixelmon("Model"));
        }
        if (CobblemonHelper.isPokemon((class_1297)entity)) {
            data.put("CobblemonModel", new GuiTypeCobblemon("CobblemonModel"));
        }
        if (entity.method_5653().equals("tgvstyle.Dog")) {
            data.put("Breed", new GuiTypeDoggyStyle("Breed"));
        }
        return data;
    }

    private boolean isIgnored(String tag) {
        for (String s : this.ignoredTags) {
            if (!s.equals(tag)) continue;
            return true;
        }
        return false;
    }

    private boolean isGrimms(String tag) {
        for (String s : this.grimmsTags) {
            if (!s.equals(tag)) continue;
            return true;
        }
        return false;
    }

    private void updateTexture() {
        class_1309 entity = this.playerdata.getEntity(this.npc);
        class_897 render = this.field_22787.method_1561().method_3953((class_1297)entity);
        this.npc.display.setSkinTexture(render.method_3931((class_1297)entity).toString());
    }

    private class_2487 getExtras(class_1309 entity) {
        class_2487 fake = new class_2487();
        new EntityFakeLiving(entity.method_37908()).method_5652(fake);
        class_2487 compound = new class_2487();
        try {
            entity.method_5652(compound);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Set keys = fake.method_10541();
        for (String name : keys) {
            compound.method_10551(name);
        }
        return compound;
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScrollNop scroll) {
        if (scroll.id == 0) {
            this.method_25426();
        } else if (this.selected != null) {
            this.selected.scrollClicked(i, j, k, scroll);
        }
    }

    @Override
    public void buttonEvent(GuiButtonNop btn) {
        if (this.selected != null) {
            this.selected.buttonEvent(btn);
        }
    }

    @Override
    public void unFocused(GuiTextFieldNop textfield) {
        if (this.selected != null) {
            this.selected.unFocused(textfield);
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScrollNop scroll) {
    }

    abstract class GuiType {
        public String name;

        public GuiType(GuiCreationExtra this$0, String name) {
            this.name = name;
        }

        public void init() {
        }

        public void buttonEvent(GuiButtonNop button) {
        }

        public void scrollClicked(double i, double j, int k, GuiCustomScrollNop scroll) {
        }

        public void unFocused(GuiTextFieldNop textfield) {
        }
    }

    class GuiTypeBoolean
    extends GuiType {
        private boolean bo;

        public GuiTypeBoolean(String name, boolean bo) {
            super(GuiCreationExtra.this, name);
            this.bo = bo;
        }

        @Override
        public void init() {
            GuiCreationExtra.this.addButton(new GuiButtonYesNo((IGuiInterface)GuiCreationExtra.this, 11, GuiCreationExtra.this.guiLeft + 120, GuiCreationExtra.this.guiTop + 50, 60, 20, this.bo));
        }

        @Override
        public void buttonEvent(GuiButtonNop button) {
            if (button.id != 11) {
                return;
            }
            this.bo = ((GuiButtonYesNo)button).getBoolean();
            if (this.name.equals("Child")) {
                GuiCreationExtra.this.playerdata.extra.method_10569("Age", this.bo ? -24000 : 0);
                GuiCreationExtra.this.playerdata.clearEntity();
            } else {
                GuiCreationExtra.this.playerdata.extra.method_10556(this.name, this.bo);
                GuiCreationExtra.this.playerdata.clearEntity();
                GuiCreationExtra.this.updateTexture();
            }
        }
    }

    class GuiTypeByte
    extends GuiType {
        private byte b;

        public GuiTypeByte(String name, byte b) {
            super(GuiCreationExtra.this, name);
            this.b = b;
        }

        @Override
        public void init() {
            GuiCreationExtra.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationExtra.this, 11, GuiCreationExtra.this.guiLeft + 120, GuiCreationExtra.this.guiTop + 45, 50, 20, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}, this.b));
        }

        @Override
        public void buttonEvent(GuiButtonNop button) {
            if (button.id != 11) {
                return;
            }
            GuiCreationExtra.this.playerdata.extra.method_10567(this.name, (byte)button.getValue());
            GuiCreationExtra.this.playerdata.clearEntity();
            GuiCreationExtra.this.updateTexture();
        }
    }

    class GuiTypeInt
    extends GuiType {
        private int initVal;
        private int fieldId;

        public GuiTypeInt(String name, int b) {
            super(GuiCreationExtra.this, name);
            this.initVal = b;
            this.fieldId = GuiCreationExtra.this.nextAvailableFieldId++;
        }

        @Override
        public void init() {
            GuiTextFieldNop field = new GuiTextFieldNop(11, (class_437)GuiCreationExtra.this, GuiCreationExtra.this.guiLeft + 120, GuiCreationExtra.this.guiTop + 45, 50, 20, "" + this.initVal);
            field.setNumbersOnly();
            GuiCreationExtra.this.addTextField(field);
        }

        @Override
        public void unFocused(GuiTextFieldNop textfield) {
            if (textfield.id != 11) {
                return;
            }
            GuiCreationExtra.this.playerdata.extra.method_10569(this.name, textfield.getInteger());
            GuiCreationExtra.this.playerdata.clearEntity();
            GuiCreationExtra.this.updateTexture();
        }
    }

    class GuiTypePixelmon
    extends GuiType {
        public GuiTypePixelmon(String name) {
            super(GuiCreationExtra.this, name);
        }

        @Override
        public void init() {
            GuiCustomScrollNop scroll = new GuiCustomScrollNop(GuiCreationExtra.this, 1);
            scroll.setSize(120, 200);
            scroll.guiLeft = GuiCreationExtra.this.guiLeft + 120;
            scroll.guiTop = GuiCreationExtra.this.guiTop + 20;
            GuiCreationExtra.this.addScroll(scroll);
            scroll.setList(PixelmonHelper.getPixelmonList());
            scroll.setSelected(PixelmonHelper.getName(GuiCreationExtra.this.entity));
        }

        @Override
        public void scrollClicked(double i, double j, int k, GuiCustomScrollNop scroll) {
            String name = scroll.getSelected();
            GuiCreationExtra.this.playerdata.setExtra(GuiCreationExtra.this.entity, "name", name);
            GuiCreationExtra.this.updateTexture();
        }
    }

    class GuiTypeCobblemon
    extends GuiType {
        public GuiTypeCobblemon(String name) {
            super(GuiCreationExtra.this, name);
        }

        @Override
        public void init() {
            GuiCustomScrollNop scroll = new GuiCustomScrollNop(GuiCreationExtra.this, 1);
            scroll.setSize(120, 200);
            scroll.guiLeft = GuiCreationExtra.this.guiLeft + 120;
            scroll.guiTop = GuiCreationExtra.this.guiTop + 20;
            GuiCreationExtra.this.addScroll(scroll);
            scroll.setList(CobblemonHelper.getTypes());
            scroll.setSelected(CobblemonHelper.getType((class_1297)GuiCreationExtra.this.entity).toString());
        }

        @Override
        public void scrollClicked(double i, double j, int k, GuiCustomScrollNop scroll) {
            String name = scroll.getSelected();
            GuiCreationExtra.this.playerdata.setExtra(GuiCreationExtra.this.entity, "CobblemonModel", name);
            GuiCreationExtra.this.updateTexture();
        }
    }

    class GuiTypeDoggyStyle
    extends GuiType {
        public GuiTypeDoggyStyle(String name) {
            super(GuiCreationExtra.this, name);
        }

        @Override
        public void init() {
            Enum breed = null;
            try {
                Method method = GuiCreationExtra.this.entity.getClass().getMethod("getBreedID", new Class[0]);
                breed = (Enum)method.invoke((Object)GuiCreationExtra.this.entity, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GuiCreationExtra.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationExtra.this, 11, GuiCreationExtra.this.guiLeft + 120, GuiCreationExtra.this.guiTop + 45, 50, 20, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"}, breed.ordinal()));
        }

        @Override
        public void buttonEvent(GuiButtonNop button) {
            if (button.id != 11) {
                return;
            }
            int breed = button.getValue();
            class_1309 entity = GuiCreationExtra.this.playerdata.getEntity(GuiCreationExtra.this.npc);
            GuiCreationExtra.this.playerdata.setExtra(entity, "breed", "" + button.getValue());
            GuiCreationExtra.this.updateTexture();
        }
    }
}

