/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.select;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiCustomScrollNop;
import noppes.npcs.shared.client.gui.listeners.ICustomScrollListener;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;
import noppes.npcs.shared.client.util.AssetsFinder;

public class GuiTextureSelection
extends GuiNPCInterface
implements ICustomScrollListener {
    private String up = "..<" + class_1074.method_4662((String)"gui.up", (Object[])new Object[0]) + ">..";
    private GuiCustomScrollNop scrollCategories;
    private GuiCustomScrollNop scrollQuests;
    private String location = "";
    private String selectedDomain;
    public class_2960 selectedResource;
    private int type = 0;
    private static final HashMap<String, List<class_2960>> domains = new HashMap();
    private static final HashMap<String, class_2960> textures = new HashMap();

    public GuiTextureSelection(EntityNPCInterface npc, String texture, int type) {
        this.npc = npc;
        this.type = type;
        this.drawDefaultBackground = false;
        this.title = "";
        this.setBackground("menubg.png");
        this.imageWidth = 366;
        this.imageHeight = 226;
        if (domains.isEmpty()) {
            List<class_2960> resources = AssetsFinder.find("textures", ".png");
            for (class_2960 loc : resources) {
                domains.computeIfAbsent(loc.method_12836(), k -> new ArrayList()).add(loc);
            }
        }
        if (texture != null && !texture.isEmpty() && !texture.startsWith("http")) {
            this.selectedResource = class_2960.method_12829((String)texture);
            this.selectedDomain = this.selectedResource.method_12836();
            if (!domains.containsKey(this.selectedDomain)) {
                this.selectedDomain = null;
            }
            int i = this.selectedResource.method_12832().lastIndexOf(47);
            this.location = this.selectedResource.method_12832().substring(0, i + 1);
        }
    }

    public static void clear() {
        domains.clear();
        textures.clear();
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.title = this.selectedDomain != null ? this.selectedDomain + ":" + this.location : "";
        this.addButton(new GuiButtonNop(this, 2, this.guiLeft + 264, this.guiTop + 170, 90, 20, "gui.done"));
        this.addButton(new GuiButtonNop(this, 1, this.guiLeft + 264, this.guiTop + 190, 90, 20, "gui.cancel"));
        if (this.scrollCategories == null) {
            this.scrollCategories = new GuiCustomScrollNop(this, 0);
            this.scrollCategories.setSize(120, 200);
        }
        if (this.selectedDomain == null) {
            this.scrollCategories.setList(Lists.newArrayList(domains.keySet()));
            if (this.selectedDomain != null) {
                this.scrollCategories.setSelected(this.selectedDomain);
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.up);
            List<class_2960> data = domains.get(this.selectedDomain);
            for (class_2960 td : data) {
                String path;
                int i;
                String fullPath = td.method_12832();
                if (fullPath.indexOf(47) >= 0) {
                    fullPath = fullPath.substring(0, fullPath.lastIndexOf(47) + 1);
                }
                if (!this.location.isEmpty() && (!fullPath.startsWith(this.location) || fullPath.equals(this.location)) || (i = (path = fullPath.substring(this.location.length())).indexOf(47)) < 0 || (path = path.substring(0, i)).isEmpty() || list.contains(path)) continue;
                list.add(path);
            }
            this.scrollCategories.setList(list);
        }
        this.scrollCategories.guiLeft = this.guiLeft + 4;
        this.scrollCategories.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollCategories);
        if (this.scrollQuests == null) {
            this.scrollQuests = new GuiCustomScrollNop(this, 1);
            this.scrollQuests.setSize(130, 200);
        }
        if (this.selectedDomain != null) {
            textures.clear();
            List<class_2960> data = domains.get(this.selectedDomain);
            ArrayList<String> list = new ArrayList<String>();
            Object loc = this.location;
            if (this.scrollCategories.hasSelected() && !this.scrollCategories.getSelected().equals(this.up)) {
                loc = (String)loc + this.scrollCategories.getSelected() + "/";
            }
            for (class_2960 td : data) {
                String name = td.method_12832();
                String path = td.method_12832();
                if (name.indexOf(47) >= 0) {
                    name = name.substring(name.lastIndexOf(47) + 1);
                    path = path.substring(0, path.lastIndexOf(47) + 1);
                }
                if (!path.equals(loc) || list.contains(name)) continue;
                list.add(name);
                textures.put(name, td);
            }
            this.scrollQuests.setList(list);
        }
        if (this.selectedResource != null) {
            this.scrollQuests.setSelected(this.selectedResource.method_12832());
        }
        this.scrollQuests.guiLeft = this.guiLeft + 125;
        this.scrollQuests.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollQuests);
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        this.npc.textureLocation = null;
        if (guibutton.id == 2) {
            if (this.type == 0) {
                this.npc.display.setSkinTexture(this.selectedResource.toString());
            }
            if (this.type == 1) {
                this.npc.display.setCapeTexture(this.selectedResource.toString());
            }
            if (this.type == 2) {
                this.npc.display.setOverlayTexture(this.selectedResource.toString());
            }
        }
        this.close();
        class_437 class_4372 = this.wrapper.parent;
        if (class_4372 instanceof IGuiInterface) {
            IGuiInterface igui = (IGuiInterface)class_4372;
            igui.initGui();
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.type == 0) {
            this.npc.textureLocation = this.selectedResource;
        }
        if (this.type == 1) {
            this.npc.textureCloakLocation = this.selectedResource;
        }
        if (this.type == 2) {
            this.npc.textureGlowLocation = this.selectedResource;
        }
        this.drawNpc(graphics, (class_1309)this.npc, 333, 154, 2.0f, this.type == 1 ? 180 : 0);
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScrollNop scroll) {
        if (scroll == this.scrollQuests) {
            if (scroll.id == 1) {
                this.selectedResource = textures.get(scroll.getSelected());
            }
        } else {
            this.method_25426();
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScrollNop scroll) {
        if (scroll == this.scrollCategories) {
            if (this.selectedDomain == null) {
                this.selectedDomain = selection;
            } else if (selection.equals(this.up)) {
                int i = this.location.lastIndexOf(47, this.location.length() - 2);
                if (i < 0) {
                    if (this.location.isEmpty()) {
                        this.selectedDomain = null;
                    }
                    this.location = "";
                } else {
                    this.location = this.location.substring(0, i + 1);
                }
            } else {
                this.location = this.location + selection + "/";
            }
            this.scrollCategories.clearSelection();
            this.scrollQuests.clearSelection();
            this.method_25426();
        } else {
            if (this.type == 0) {
                this.npc.display.setSkinTexture(this.selectedResource.toString());
            }
            if (this.type == 1) {
                this.npc.display.setCapeTexture(this.selectedResource.toString());
            }
            if (this.type == 2) {
                this.npc.display.setOverlayTexture(this.selectedResource.toString());
            }
            this.close();
            class_437 class_4372 = this.wrapper.parent;
            if (class_4372 instanceof IGuiInterface) {
                IGuiInterface igui = (IGuiInterface)class_4372;
                igui.initGui();
            }
        }
    }
}

