/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketAchievement;
import noppes.npcs.packets.client.PacketChat;

public class CmdQuest {
    public static LiteralArgumentBuilder<class_2168> register() {
        LiteralArgumentBuilder command = class_2170.method_9247((String)"quest");
        command.then(class_2170.method_9247((String)"start").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = class_2186.method_9312((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unknown QuestID")).create();
            }
            for (class_3222 player : players) {
                PlayerData data = PlayerData.get((class_1657)player);
                QuestData questdata = new QuestData(quest);
                data.questData.activeQuests.put(quest.id, questdata);
                data.save(true);
                Packets.send(player, new PacketAchievement((class_2561)class_2561.method_43471((String)"quest.newquest"), (class_2561)class_2561.method_43471((String)quest.title), 2));
                Packets.send(player, new PacketChat((class_2561)class_2561.method_43471((String)"quest.newquest").method_27693(":").method_10852((class_2561)class_2561.method_43471((String)quest.title))));
            }
            return 1;
        }))));
        command.then(class_2170.method_9247((String)"finish").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = class_2186.method_9312((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unknown QuestID")).create();
            }
            for (class_3222 player : players) {
                PlayerData data = PlayerData.get((class_1657)player);
                data.questData.finishedQuests.put(quest.id, System.currentTimeMillis());
                data.save(true);
            }
            return 1;
        }))));
        command.then(class_2170.method_9247((String)"stop").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = class_2186.method_9312((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unknown QuestID")).create();
            }
            for (class_3222 player : players) {
                PlayerData data = PlayerData.get((class_1657)player);
                data.questData.activeQuests.remove(quest.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(class_2170.method_9247((String)"remove").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = class_2186.method_9312((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unknown QuestID")).create();
            }
            for (class_3222 player : players) {
                PlayerData data = PlayerData.get((class_1657)player);
                data.questData.activeQuests.remove(quest.id);
                data.questData.finishedQuests.remove(quest.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(class_2170.method_9247((String)"objective").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"quest", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = class_2186.method_9312((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unknown QuestID")).create();
            }
            for (class_3222 player : players) {
                IQuestObjective[] objectives;
                PlayerData data = PlayerData.get((class_1657)player);
                if (!data.questData.activeQuests.containsKey(quest.id)) continue;
                for (IQuestObjective ob : objectives = quest.questInterface.getObjectives((class_1657)player)) {
                    player.method_43496(ob.getMCText());
                }
            }
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"objective", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(context -> {
            Collection players = class_2186.method_9312((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unknown QuestID")).create();
            }
            int objective = IntegerArgumentType.getInteger((CommandContext)context, (String)"objective");
            for (class_3222 player : players) {
                IQuestObjective[] objectives;
                PlayerData data = PlayerData.get((class_1657)player);
                if (!data.questData.activeQuests.containsKey(quest.id) || objective >= (objectives = quest.questInterface.getObjectives((class_1657)player)).length) continue;
                player.method_43496(objectives[objective].getMCText());
            }
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = class_2186.method_9312((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Quest quest = QuestController.instance.quests.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"quest"));
            if (quest == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unknown QuestID")).create();
            }
            int objective = IntegerArgumentType.getInteger((CommandContext)context, (String)"objective");
            int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            for (class_3222 player : players) {
                IQuestObjective[] objectives;
                PlayerData data = PlayerData.get((class_1657)player);
                if (!data.questData.activeQuests.containsKey(quest.id) || objective >= (objectives = quest.questInterface.getObjectives((class_1657)player)).length) continue;
                objectives[objective].setProgress(value);
            }
            return 1;
        }))))));
        ((LiteralArgumentBuilder)command.requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"reload").executes(context -> {
            new QuestController().load((class_7225.class_7874)((class_2168)context.getSource()).method_30497());
            SyncController.syncAllQuests((class_7225.class_7874)((class_2168)context.getSource()).method_30497());
            return 1;
        }));
        return command;
    }
}

