/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashSet;
import java.util.Locale;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import noppes.npcs.NBTTags;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.handler.data.IFaction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.entity.EntityNPCInterface;

public class Faction
implements IFaction {
    public String name = "";
    public int color = Integer.parseInt("FF00", 16);
    public HashSet<Integer> attackFactions;
    public int id = -1;
    public int neutralPoints = 500;
    public int friendlyPoints = 1500;
    public int defaultPoints = 1000;
    public boolean hideFaction = false;
    public boolean getsAttacked = false;

    public Faction() {
        this.attackFactions = new HashSet();
    }

    public Faction(int id, String name, int color, int defaultPoints) {
        this.name = name;
        this.color = color;
        this.defaultPoints = defaultPoints;
        this.id = id;
        this.attackFactions = new HashSet();
    }

    public static String formatName(String name) {
        name = name.toLowerCase(Locale.ROOT).trim();
        return name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1);
    }

    public void readNBT(class_2487 compound) {
        this.name = compound.method_10558("Name");
        this.color = compound.method_10550("Color");
        this.id = compound.method_10550("Slot");
        this.neutralPoints = compound.method_10550("NeutralPoints");
        this.friendlyPoints = compound.method_10550("FriendlyPoints");
        this.defaultPoints = compound.method_10550("DefaultPoints");
        this.hideFaction = compound.method_10577("HideFaction");
        this.getsAttacked = compound.method_10577("GetsAttacked");
        this.attackFactions = NBTTags.getIntegerSet(compound.method_10554("AttackFactions", 10));
    }

    public class_2487 writeNBT(class_2487 compound) {
        compound.method_10569("Slot", this.id);
        compound.method_10582("Name", this.name);
        compound.method_10569("Color", this.color);
        compound.method_10569("NeutralPoints", this.neutralPoints);
        compound.method_10569("FriendlyPoints", this.friendlyPoints);
        compound.method_10569("DefaultPoints", this.defaultPoints);
        compound.method_10556("HideFaction", this.hideFaction);
        compound.method_10556("GetsAttacked", this.getsAttacked);
        compound.method_10566("AttackFactions", (class_2520)NBTTags.nbtIntegerCollection(this.attackFactions));
        return compound;
    }

    public boolean isFriendlyToPlayer(class_1657 player) {
        PlayerFactionData data = PlayerData.get((class_1657)player).factionData;
        return data.getFactionPoints(player, this.id) >= this.friendlyPoints;
    }

    public boolean isAggressiveToPlayer(class_1657 player) {
        if (player.method_31549().field_7477) {
            return false;
        }
        PlayerFactionData data = PlayerData.get((class_1657)player).factionData;
        return data.getFactionPoints(player, this.id) < this.neutralPoints;
    }

    public boolean isNeutralToPlayer(class_1657 player) {
        PlayerFactionData data = PlayerData.get((class_1657)player).factionData;
        int points = data.getFactionPoints(player, this.id);
        return points >= this.neutralPoints && points < this.friendlyPoints;
    }

    public boolean isAggressiveToNpc(EntityNPCInterface entity) {
        return this.attackFactions.contains(entity.faction.id);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getDefaultPoints() {
        return this.defaultPoints;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int playerStatus(IPlayer player) {
        PlayerFactionData data = PlayerData.get(player.getMCEntity()).factionData;
        int points = data.getFactionPoints((class_1657)player.getMCEntity(), this.id);
        if (points >= this.friendlyPoints) {
            return 1;
        }
        if (points < this.neutralPoints) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean hostileToNpc(ICustomNpc npc) {
        return this.attackFactions.contains(npc.getFaction().getId());
    }

    @Override
    public void setDefaultPoints(int points) {
        this.defaultPoints = points;
    }

    @Override
    public boolean hostileToFaction(int factionId) {
        return this.attackFactions.contains(factionId);
    }

    @Override
    public int[] getHostileList() {
        int[] a = new int[this.attackFactions.size()];
        int i = 0;
        for (Integer val : this.attackFactions) {
            a[i++] = val;
        }
        return a;
    }

    @Override
    public void addHostile(int id) {
        if (this.attackFactions.contains(id)) {
            throw new CustomNPCsException("Faction " + this.id + " is already hostile to " + id, new Object[0]);
        }
        this.attackFactions.add(id);
    }

    @Override
    public void removeHostile(int id) {
        this.attackFactions.remove(id);
    }

    @Override
    public boolean hasHostile(int id) {
        return this.attackFactions.contains(id);
    }

    @Override
    public boolean getIsHidden() {
        return this.hideFaction;
    }

    @Override
    public void setIsHidden(boolean bo) {
        this.hideFaction = bo;
    }

    @Override
    public boolean getAttackedByMobs() {
        return this.getsAttacked;
    }

    @Override
    public void setAttackedByMobs(boolean bo) {
        this.getsAttacked = bo;
    }

    @Override
    public void save() {
        FactionController.instance.saveFaction(this);
    }
}

