/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;

public class FactionOptions {
    public boolean decreaseFactionPoints = false;
    public boolean decreaseFaction2Points = false;
    public int factionId = -1;
    public int faction2Id = -1;
    public int factionPoints = 100;
    public int faction2Points = 100;

    public void load(class_2487 compound) {
        this.factionId = compound.method_10550("OptionFactions1");
        this.faction2Id = compound.method_10550("OptionFactions2");
        this.decreaseFactionPoints = compound.method_10577("DecreaseFaction1Points");
        this.decreaseFaction2Points = compound.method_10577("DecreaseFaction2Points");
        this.factionPoints = compound.method_10550("OptionFaction1Points");
        this.faction2Points = compound.method_10550("OptionFaction2Points");
    }

    public class_2487 save(class_2487 par1CompoundTag) {
        par1CompoundTag.method_10569("OptionFactions1", this.factionId);
        par1CompoundTag.method_10569("OptionFactions2", this.faction2Id);
        par1CompoundTag.method_10569("OptionFaction1Points", this.factionPoints);
        par1CompoundTag.method_10569("OptionFaction2Points", this.faction2Points);
        par1CompoundTag.method_10556("DecreaseFaction1Points", this.decreaseFactionPoints);
        par1CompoundTag.method_10556("DecreaseFaction2Points", this.decreaseFaction2Points);
        return par1CompoundTag;
    }

    public boolean hasFaction(int id) {
        return this.factionId == id || this.faction2Id == id;
    }

    public void addPoints(class_1657 player) {
        if (this.factionId < 0 && this.faction2Id < 0) {
            return;
        }
        PlayerData playerdata = PlayerData.get(player);
        PlayerFactionData data = playerdata.factionData;
        if (this.factionId >= 0 && this.factionPoints > 0) {
            this.addPoints(player, data, this.factionId, this.decreaseFactionPoints, this.factionPoints);
        }
        if (this.faction2Id >= 0 && this.faction2Points > 0) {
            this.addPoints(player, data, this.faction2Id, this.decreaseFaction2Points, this.faction2Points);
        }
        playerdata.updateClient = true;
    }

    private void addPoints(class_1657 player, PlayerFactionData data, int factionId, boolean decrease, int points) {
        Faction faction = FactionController.instance.getFaction(factionId);
        if (faction == null) {
            return;
        }
        if (!faction.hideFaction) {
            String message = decrease ? "faction.decreasepoints" : "faction.increasepoints";
            player.method_43496((class_2561)class_2561.method_43469((String)message, (Object[])new Object[]{faction.name, points}));
        }
        data.increasePoints(player, factionId, decrease ? -points : points);
    }
}

