/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.data.PlayerBankData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerItemGiverData;
import noppes.npcs.controllers.data.PlayerMailData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.controllers.data.PlayerSkinData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.shared.common.util.LogWriter;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.NBTJsonUtil;

public class PlayerData {
    private static Map<Integer, PlayerData> dataMap = new HashMap<Integer, PlayerData>();
    public class_2338 scriptBlockPos = class_2338.field_10980;
    public PlayerDialogData dialogData = new PlayerDialogData();
    public PlayerBankData bankData = new PlayerBankData();
    public PlayerQuestData questData = new PlayerQuestData();
    public PlayerTransportData transportData = new PlayerTransportData();
    public PlayerFactionData factionData = new PlayerFactionData();
    public PlayerItemGiverData itemgiverData = new PlayerItemGiverData();
    public PlayerMailData mailData = new PlayerMailData();
    public PlayerSkinData skinData = new PlayerSkinData();
    public PlayerScriptData scriptData;
    public class_2487 scriptStoreddata = new class_2487();
    public DataTimers timers = new DataTimers(this);
    public EntityNPCInterface editingNpc;
    public class_2487 cloned;
    public class_1657 player;
    public String playername = "";
    public String uuid = "";
    private EntityNPCInterface activeCompanion = null;
    public int companionID = 0;
    public int playerLevel = 0;
    public boolean updateClient = false;
    public int dialogId = -1;
    public class_1799 prevHeldItem = class_1799.field_8037;
    public class_1297 mounted;
    public UUID iAmStealingYourDatas = UUID.randomUUID();
    private static final class_2960 key = new class_2960("customnpcs", "playerdata");

    public void setNBT(class_7225.class_7874 provider, class_2487 data) {
        this.dialogData.loadNBTData(data);
        this.bankData.loadNBTData(provider, data);
        this.questData.loadNBTData(data);
        this.transportData.loadNBTData(data);
        this.factionData.loadNBTData(data);
        this.itemgiverData.loadNBTData(data);
        this.mailData.loadNBTData(data);
        this.skinData.loadNBTData(data);
        this.timers.load(data);
        if (this.player != null) {
            this.playername = this.player.method_5477().getString();
            this.uuid = this.player.method_5667().toString();
        } else {
            this.playername = data.method_10558("PlayerName");
            this.uuid = data.method_10558("UUID");
        }
        this.companionID = data.method_10550("PlayerCompanionId");
        if (data.method_10545("PlayerCompanion") && !this.hasCompanion() && this.player != null) {
            EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, this.player.method_37908());
            npc.method_5749(data.method_10562("PlayerCompanion"));
            npc.method_5814(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
            if (npc.role.getType() == 6) {
                ((RoleCompanion)npc.role).setSitting(false);
                this.player.method_37908().method_8649((class_1297)npc);
                this.setCompanion(npc);
            }
        }
        this.scriptStoreddata = data.method_10562("ScriptStoreddata");
    }

    public class_2487 getSyncNBT() {
        class_2487 compound = new class_2487();
        this.dialogData.saveNBTData(compound);
        this.questData.saveNBTData(compound);
        this.factionData.saveNBTData(compound);
        return compound;
    }

    public class_2487 getNBT() {
        class_2487 nbt;
        if (this.player != null) {
            this.playername = this.player.method_5477().getString();
            this.uuid = this.player.method_5667().toString();
        }
        class_2487 compound = new class_2487();
        this.dialogData.saveNBTData(compound);
        if (this.player != null) {
            this.bankData.saveNBTData((class_7225.class_7874)this.player.method_56673(), compound);
        }
        this.questData.saveNBTData(compound);
        this.transportData.saveNBTData(compound);
        this.factionData.saveNBTData(compound);
        this.itemgiverData.saveNBTData(compound);
        this.mailData.saveNBTData(compound);
        this.skinData.saveNBTData(compound);
        this.timers.save(compound);
        compound.method_10582("PlayerName", this.playername);
        compound.method_10582("UUID", this.uuid);
        compound.method_10569("PlayerCompanionId", this.companionID);
        compound.method_10566("ScriptStoreddata", (class_2520)this.scriptStoreddata);
        if (this.hasCompanion() && this.activeCompanion.method_5786(nbt = new class_2487())) {
            compound.method_10566("PlayerCompanion", (class_2520)nbt);
        }
        return compound;
    }

    public boolean hasCompanion() {
        return this.activeCompanion != null && !this.activeCompanion.method_31481();
    }

    public void setCompanion(EntityNPCInterface npc) {
        if (npc != null && npc.role.getType() != 6) {
            return;
        }
        ++this.companionID;
        this.activeCompanion = npc;
        if (npc != null) {
            ((RoleCompanion)npc.role).companionID = this.companionID;
        }
        this.save(false);
    }

    public void updateCompanion(class_1937 level) {
        if (!this.hasCompanion() || level == this.activeCompanion.method_37908()) {
            return;
        }
        RoleCompanion role = (RoleCompanion)this.activeCompanion.role;
        role.owner = this.player;
        if (!role.isFollowing()) {
            return;
        }
        class_2487 nbt = new class_2487();
        this.activeCompanion.method_5786(nbt);
        this.activeCompanion.method_31472();
        EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, level);
        npc.method_5749(nbt);
        npc.method_5814(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
        this.setCompanion(npc);
        ((RoleCompanion)npc.role).setSitting(false);
        level.method_8649((class_1297)npc);
    }

    public synchronized void save(boolean update) {
        class_2487 compound = this.getNBT();
        String filename = this.uuid + ".json";
        CustomNPCsScheduler.runTack(() -> {
            try {
                File saveDir = CustomNpcs.getLevelSaveDirectory("playerdata");
                File file = new File(saveDir, filename + "_new");
                File file1 = new File(saveDir, filename);
                NBTJsonUtil.SaveFile(file, compound);
                if (file1.exists()) {
                    file1.delete();
                }
                file.renameTo(file1);
            }
            catch (Exception e) {
                LogWriter.except(e);
            }
        });
        if (update) {
            this.updateClient = true;
        }
    }

    public static class_2487 loadPlayerData(String player) {
        File saveDir = CustomNpcs.getLevelSaveDirectory("playerdata");
        Object filename = player;
        if (((String)filename).isEmpty()) {
            filename = "noplayername";
        }
        filename = (String)filename + ".json";
        File file = null;
        try {
            file = new File(saveDir, (String)filename);
            if (file.exists()) {
                return NBTJsonUtil.LoadFile(file);
            }
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
        }
        return new class_2487();
    }

    public static void reset(class_1657 player) {
        dataMap.put(player.method_5628(), new PlayerData());
    }

    public static PlayerData get(class_1657 player) {
        if (player.method_37908().field_9236) {
            return CustomNpcs.proxy.getPlayerData(player);
        }
        PlayerData data = dataMap.computeIfAbsent(player.method_5628(), i -> new PlayerData());
        if (data.player == null) {
            data.player = player;
            data.playerLevel = player.field_7520;
            data.scriptData = new PlayerScriptData(player);
            class_2487 compound = PlayerData.loadPlayerData(player.method_5667().toString());
            data.setNBT((class_7225.class_7874)player.method_56673(), compound);
        }
        return data;
    }
}

